/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.gameEngine;

import com.amazon.ask.model.services.gameEngine.EventReportingType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Event {
    @JsonProperty(value="shouldEndInputHandler")
    private Boolean shouldEndInputHandler = null;
    @JsonProperty(value="meets")
    private List<String> meets = new ArrayList<String>();
    @JsonProperty(value="fails")
    private List<String> fails = new ArrayList<String>();
    @JsonProperty(value="reports")
    private EventReportingType reports = null;
    @JsonProperty(value="maximumInvocations")
    private Integer maximumInvocations = null;
    @JsonProperty(value="triggerTimeMilliseconds")
    private Long triggerTimeMilliseconds = null;

    public static Builder builder() {
        return new Builder();
    }

    private Event(Builder builder) {
        this.shouldEndInputHandler = builder.shouldEndInputHandler;
        this.meets = builder.meets;
        this.fails = builder.fails;
        this.reports = builder.reports;
        this.maximumInvocations = builder.maximumInvocations;
        this.triggerTimeMilliseconds = builder.triggerTimeMilliseconds;
    }

    public Boolean getShouldEndInputHandler() {
        return this.shouldEndInputHandler;
    }

    public List<String> getMeets() {
        return this.meets;
    }

    public List<String> getFails() {
        return this.fails;
    }

    public EventReportingType getReports() {
        return this.reports;
    }

    public Integer getMaximumInvocations() {
        return this.maximumInvocations;
    }

    public Long getTriggerTimeMilliseconds() {
        return this.triggerTimeMilliseconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event servicesGameEngineEvent = (Event)o;
        return Objects.equals(this.shouldEndInputHandler, servicesGameEngineEvent.shouldEndInputHandler) && Objects.equals(this.meets, servicesGameEngineEvent.meets) && Objects.equals(this.fails, servicesGameEngineEvent.fails) && Objects.equals((Object)this.reports, (Object)servicesGameEngineEvent.reports) && Objects.equals(this.maximumInvocations, servicesGameEngineEvent.maximumInvocations) && Objects.equals(this.triggerTimeMilliseconds, servicesGameEngineEvent.triggerTimeMilliseconds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shouldEndInputHandler, this.meets, this.fails, this.reports, this.maximumInvocations, this.triggerTimeMilliseconds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    shouldEndInputHandler: ").append(this.toIndentedString(this.shouldEndInputHandler)).append("\n");
        sb.append("    meets: ").append(this.toIndentedString(this.meets)).append("\n");
        sb.append("    fails: ").append(this.toIndentedString(this.fails)).append("\n");
        sb.append("    reports: ").append(this.toIndentedString((Object)this.reports)).append("\n");
        sb.append("    maximumInvocations: ").append(this.toIndentedString(this.maximumInvocations)).append("\n");
        sb.append("    triggerTimeMilliseconds: ").append(this.toIndentedString(this.triggerTimeMilliseconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Boolean shouldEndInputHandler;
        private List<String> meets;
        private List<String> fails;
        private EventReportingType reports;
        private Integer maximumInvocations;
        private Long triggerTimeMilliseconds;

        private Builder() {
        }

        @JsonProperty(value="shouldEndInputHandler")
        public Builder withShouldEndInputHandler(Boolean shouldEndInputHandler) {
            this.shouldEndInputHandler = shouldEndInputHandler;
            return this;
        }

        @JsonProperty(value="meets")
        public Builder withMeets(List<String> meets) {
            this.meets = meets;
            return this;
        }

        public Builder addMeetsItem(String meetsItem) {
            if (this.meets == null) {
                this.meets = new ArrayList<String>();
            }
            this.meets.add(meetsItem);
            return this;
        }

        @JsonProperty(value="fails")
        public Builder withFails(List<String> fails) {
            this.fails = fails;
            return this;
        }

        public Builder addFailsItem(String failsItem) {
            if (this.fails == null) {
                this.fails = new ArrayList<String>();
            }
            this.fails.add(failsItem);
            return this;
        }

        @JsonProperty(value="reports")
        public Builder withReports(EventReportingType reports) {
            this.reports = reports;
            return this;
        }

        @JsonProperty(value="maximumInvocations")
        public Builder withMaximumInvocations(Integer maximumInvocations) {
            this.maximumInvocations = maximumInvocations;
            return this;
        }

        @JsonProperty(value="triggerTimeMilliseconds")
        public Builder withTriggerTimeMilliseconds(Long triggerTimeMilliseconds) {
            this.triggerTimeMilliseconds = triggerTimeMilliseconds;
            return this;
        }

        public Event build() {
            return new Event(this);
        }
    }
}

