/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.gadgetController;

import com.amazon.ask.model.services.gadgetController.LightAnimation;
import com.amazon.ask.model.services.gadgetController.TriggerEventType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SetLightParameters {
    @JsonProperty(value="triggerEvent")
    private TriggerEventType triggerEvent = null;
    @JsonProperty(value="triggerEventTimeMs")
    private Integer triggerEventTimeMs = null;
    @JsonProperty(value="animations")
    private List<LightAnimation> animations = new ArrayList<LightAnimation>();

    public static Builder builder() {
        return new Builder();
    }

    private SetLightParameters(Builder builder) {
        this.triggerEvent = builder.triggerEvent;
        this.triggerEventTimeMs = builder.triggerEventTimeMs;
        this.animations = builder.animations;
    }

    public TriggerEventType getTriggerEvent() {
        return this.triggerEvent;
    }

    public Integer getTriggerEventTimeMs() {
        return this.triggerEventTimeMs;
    }

    public List<LightAnimation> getAnimations() {
        return this.animations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetLightParameters servicesGadgetControllerSetLightParameters = (SetLightParameters)o;
        return Objects.equals((Object)this.triggerEvent, (Object)servicesGadgetControllerSetLightParameters.triggerEvent) && Objects.equals(this.triggerEventTimeMs, servicesGadgetControllerSetLightParameters.triggerEventTimeMs) && Objects.equals(this.animations, servicesGadgetControllerSetLightParameters.animations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.triggerEvent, this.triggerEventTimeMs, this.animations});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetLightParameters {\n");
        sb.append("    triggerEvent: ").append(this.toIndentedString((Object)this.triggerEvent)).append("\n");
        sb.append("    triggerEventTimeMs: ").append(this.toIndentedString(this.triggerEventTimeMs)).append("\n");
        sb.append("    animations: ").append(this.toIndentedString(this.animations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private TriggerEventType triggerEvent;
        private Integer triggerEventTimeMs;
        private List<LightAnimation> animations;

        private Builder() {
        }

        @JsonProperty(value="triggerEvent")
        public Builder withTriggerEvent(TriggerEventType triggerEvent) {
            this.triggerEvent = triggerEvent;
            return this;
        }

        @JsonProperty(value="triggerEventTimeMs")
        public Builder withTriggerEventTimeMs(Integer triggerEventTimeMs) {
            this.triggerEventTimeMs = triggerEventTimeMs;
            return this;
        }

        @JsonProperty(value="animations")
        public Builder withAnimations(List<LightAnimation> animations) {
            this.animations = animations;
            return this;
        }

        public Builder addAnimationsItem(LightAnimation animationsItem) {
            if (this.animations == null) {
                this.animations = new ArrayList<LightAnimation>();
            }
            this.animations.add(animationsItem);
            return this;
        }

        public SetLightParameters build() {
            return new SetLightParameters(this);
        }
    }
}

