/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.deviceAddress;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ShortAddress {
    @JsonProperty(value="countryCode")
    private String countryCode = null;
    @JsonProperty(value="postalCode")
    private String postalCode = null;

    public static Builder builder() {
        return new Builder();
    }

    private ShortAddress(Builder builder) {
        this.countryCode = builder.countryCode;
        this.postalCode = builder.postalCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortAddress servicesDeviceAddressShortAddress = (ShortAddress)o;
        return Objects.equals(this.countryCode, servicesDeviceAddressShortAddress.countryCode) && Objects.equals(this.postalCode, servicesDeviceAddressShortAddress.postalCode);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.postalCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShortAddress {\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String countryCode;
        private String postalCode;

        private Builder() {
        }

        @JsonProperty(value="countryCode")
        public Builder withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @JsonProperty(value="postalCode")
        public Builder withPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public ShortAddress build() {
            return new ShortAddress(this);
        }
    }
}

