/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.deviceAddress.DeviceAddressServiceClient;
import com.amazon.ask.model.services.directive.DirectiveServiceClient;
import com.amazon.ask.model.services.listManagement.ListManagementServiceClient;
import com.amazon.ask.model.services.monetization.MonetizationServiceClient;
import com.amazon.ask.model.services.reminderManagement.ReminderManagementServiceClient;
import com.amazon.ask.model.services.ups.UpsServiceClient;

public class ServiceClientFactory {
    private ApiConfiguration defaultApiConfiguration;

    private ServiceClientFactory(ApiConfiguration defaultApiConfiguration) {
        this.defaultApiConfiguration = defaultApiConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DeviceAddressServiceClient getDeviceAddressService() {
        try {
            return new DeviceAddressServiceClient(this.defaultApiConfiguration);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error while initializing DeviceAddressServiceClient: " + ex.getMessage(), ex);
        }
    }

    public DirectiveServiceClient getDirectiveService() {
        try {
            return new DirectiveServiceClient(this.defaultApiConfiguration);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error while initializing DirectiveServiceClient: " + ex.getMessage(), ex);
        }
    }

    public ListManagementServiceClient getListManagementService() {
        try {
            return new ListManagementServiceClient(this.defaultApiConfiguration);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error while initializing ListManagementServiceClient: " + ex.getMessage(), ex);
        }
    }

    public MonetizationServiceClient getMonetizationService() {
        try {
            return new MonetizationServiceClient(this.defaultApiConfiguration);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error while initializing MonetizationServiceClient: " + ex.getMessage(), ex);
        }
    }

    public ReminderManagementServiceClient getReminderManagementService() {
        try {
            return new ReminderManagementServiceClient(this.defaultApiConfiguration);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error while initializing ReminderManagementServiceClient: " + ex.getMessage(), ex);
        }
    }

    public UpsServiceClient getUpsService() {
        try {
            return new UpsServiceClient(this.defaultApiConfiguration);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error while initializing UpsServiceClient: " + ex.getMessage(), ex);
        }
    }

    public static final class Builder {
        private ApiConfiguration defaultApiConfiguration;

        private Builder() {
        }

        public Builder withDefaultApiConfiguration(ApiConfiguration defaultApiConfiguration) {
            this.defaultApiConfiguration = defaultApiConfiguration;
            return this;
        }

        public ServiceClientFactory build() {
            return new ServiceClientFactory(this.defaultApiConfiguration);
        }
    }
}

