/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services;

import com.amazon.ask.model.services.AuthenticationConfiguration;

public class DefaultAuthenticationConfiguration
implements AuthenticationConfiguration {
    private final String clientId;
    private final String clientSecret;

    protected DefaultAuthenticationConfiguration(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public DefaultAuthenticationConfiguration build() {
            return new DefaultAuthenticationConfiguration(this.clientId, this.clientSecret);
        }
    }
}

