/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.system;

import com.amazon.ask.model.interfaces.system.ErrorType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Error {
    @JsonProperty(value="type")
    private ErrorType type = null;
    @JsonProperty(value="message")
    private String message = null;

    public static Builder builder() {
        return new Builder();
    }

    private Error(Builder builder) {
        this.type = builder.type;
        this.message = builder.message;
    }

    public ErrorType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error interfacesSystemError = (Error)o;
        return Objects.equals((Object)this.type, (Object)interfacesSystemError.type) && Objects.equals(this.message, interfacesSystemError.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.message});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private ErrorType type;
        private String message;

        private Builder() {
        }

        @JsonProperty(value="type")
        public Builder withType(ErrorType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="message")
        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Error build() {
            return new Error(this);
        }
    }
}

