/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.geolocation;

import com.amazon.ask.model.interfaces.geolocation.Altitude;
import com.amazon.ask.model.interfaces.geolocation.Coordinate;
import com.amazon.ask.model.interfaces.geolocation.Heading;
import com.amazon.ask.model.interfaces.geolocation.LocationServices;
import com.amazon.ask.model.interfaces.geolocation.Speed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class GeolocationState {
    @JsonProperty(value="timestamp")
    private String timestamp = null;
    @JsonProperty(value="coordinate")
    private Coordinate coordinate = null;
    @JsonProperty(value="altitude")
    private Altitude altitude = null;
    @JsonProperty(value="heading")
    private Heading heading = null;
    @JsonProperty(value="speed")
    private Speed speed = null;
    @JsonProperty(value="locationServices")
    private LocationServices locationServices = null;

    public static Builder builder() {
        return new Builder();
    }

    private GeolocationState(Builder builder) {
        this.timestamp = builder.timestamp;
        this.coordinate = builder.coordinate;
        this.altitude = builder.altitude;
        this.heading = builder.heading;
        this.speed = builder.speed;
        this.locationServices = builder.locationServices;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public Altitude getAltitude() {
        return this.altitude;
    }

    public Heading getHeading() {
        return this.heading;
    }

    public Speed getSpeed() {
        return this.speed;
    }

    public LocationServices getLocationServices() {
        return this.locationServices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeolocationState interfacesGeolocationGeolocationState = (GeolocationState)o;
        return Objects.equals(this.timestamp, interfacesGeolocationGeolocationState.timestamp) && Objects.equals(this.coordinate, interfacesGeolocationGeolocationState.coordinate) && Objects.equals(this.altitude, interfacesGeolocationGeolocationState.altitude) && Objects.equals(this.heading, interfacesGeolocationGeolocationState.heading) && Objects.equals(this.speed, interfacesGeolocationGeolocationState.speed) && Objects.equals(this.locationServices, interfacesGeolocationGeolocationState.locationServices);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.coordinate, this.altitude, this.heading, this.speed, this.locationServices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeolocationState {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    coordinate: ").append(this.toIndentedString(this.coordinate)).append("\n");
        sb.append("    altitude: ").append(this.toIndentedString(this.altitude)).append("\n");
        sb.append("    heading: ").append(this.toIndentedString(this.heading)).append("\n");
        sb.append("    speed: ").append(this.toIndentedString(this.speed)).append("\n");
        sb.append("    locationServices: ").append(this.toIndentedString(this.locationServices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String timestamp;
        private Coordinate coordinate;
        private Altitude altitude;
        private Heading heading;
        private Speed speed;
        private LocationServices locationServices;

        private Builder() {
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="coordinate")
        public Builder withCoordinate(Coordinate coordinate) {
            this.coordinate = coordinate;
            return this;
        }

        @JsonProperty(value="altitude")
        public Builder withAltitude(Altitude altitude) {
            this.altitude = altitude;
            return this;
        }

        @JsonProperty(value="heading")
        public Builder withHeading(Heading heading) {
            this.heading = heading;
            return this;
        }

        @JsonProperty(value="speed")
        public Builder withSpeed(Speed speed) {
            this.speed = speed;
            return this;
        }

        @JsonProperty(value="locationServices")
        public Builder withLocationServices(LocationServices locationServices) {
            this.locationServices = locationServices;
            return this;
        }

        public GeolocationState build() {
            return new GeolocationState(this);
        }
    }
}

