/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.gameEngine;

import com.amazon.ask.model.Directive;
import com.amazon.ask.model.services.gameEngine.Event;
import com.amazon.ask.model.services.gameEngine.Recognizer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class StartInputHandlerDirective
extends Directive {
    @JsonProperty(value="timeout")
    private Long timeout = null;
    @JsonProperty(value="proxies")
    private List<String> proxies = new ArrayList<String>();
    @JsonProperty(value="recognizers")
    private Map<String, Recognizer> recognizers = new HashMap<String, Recognizer>();
    @JsonProperty(value="events")
    private Map<String, Event> events = new HashMap<String, Event>();

    public static Builder builder() {
        return new Builder();
    }

    private StartInputHandlerDirective(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "GameEngine.StartInputHandler";
        this.timeout = builder.timeout;
        this.proxies = builder.proxies;
        this.recognizers = builder.recognizers;
        this.events = builder.events;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public List<String> getProxies() {
        return this.proxies;
    }

    public Map<String, Recognizer> getRecognizers() {
        return this.recognizers;
    }

    public Map<String, Event> getEvents() {
        return this.events;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartInputHandlerDirective interfacesGameEngineStartInputHandlerDirective = (StartInputHandlerDirective)o;
        return Objects.equals(this.timeout, interfacesGameEngineStartInputHandlerDirective.timeout) && Objects.equals(this.proxies, interfacesGameEngineStartInputHandlerDirective.proxies) && Objects.equals(this.recognizers, interfacesGameEngineStartInputHandlerDirective.recognizers) && Objects.equals(this.events, interfacesGameEngineStartInputHandlerDirective.events) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.timeout, this.proxies, this.recognizers, this.events, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StartInputHandlerDirective {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    proxies: ").append(this.toIndentedString(this.proxies)).append("\n");
        sb.append("    recognizers: ").append(this.toIndentedString(this.recognizers)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Long timeout;
        private List<String> proxies;
        private Map<String, Recognizer> recognizers;
        private Map<String, Event> events;

        private Builder() {
        }

        @JsonProperty(value="timeout")
        public Builder withTimeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        @JsonProperty(value="proxies")
        public Builder withProxies(List<String> proxies) {
            this.proxies = proxies;
            return this;
        }

        public Builder addProxiesItem(String proxiesItem) {
            if (this.proxies == null) {
                this.proxies = new ArrayList<String>();
            }
            this.proxies.add(proxiesItem);
            return this;
        }

        @JsonProperty(value="recognizers")
        public Builder withRecognizers(Map<String, Recognizer> recognizers) {
            this.recognizers = recognizers;
            return this;
        }

        public Builder putRecognizersItem(String key, Recognizer recognizersItem) {
            if (this.recognizers == null) {
                this.recognizers = new HashMap<String, Recognizer>();
            }
            this.recognizers.put(key, recognizersItem);
            return this;
        }

        @JsonProperty(value="events")
        public Builder withEvents(Map<String, Event> events) {
            this.events = events;
            return this;
        }

        public Builder putEventsItem(String key, Event eventsItem) {
            if (this.events == null) {
                this.events = new HashMap<String, Event>();
            }
            this.events.put(key, eventsItem);
            return this;
        }

        public StartInputHandlerDirective build() {
            return new StartInputHandlerDirective(this);
        }
    }
}

