/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.connections.requests;

import com.amazon.ask.model.interfaces.connections.entities.PostalAddress;
import com.amazon.ask.model.interfaces.connections.requests.BaseRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ScheduleTaxiReservationRequest
extends BaseRequest {
    @JsonProperty(value="pickupTime")
    private String pickupTime = null;
    @JsonProperty(value="partySize")
    private String partySize = null;
    @JsonProperty(value="pickupLocation")
    private PostalAddress pickupLocation = null;
    @JsonProperty(value="dropOffLocation")
    private PostalAddress dropOffLocation = null;

    public static Builder builder() {
        return new Builder();
    }

    private ScheduleTaxiReservationRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "ScheduleTaxiReservationRequest";
        this.version = builder.version;
        this.pickupTime = builder.pickupTime;
        this.partySize = builder.partySize;
        this.pickupLocation = builder.pickupLocation;
        this.dropOffLocation = builder.dropOffLocation;
    }

    public String getPickupTime() {
        return this.pickupTime;
    }

    public String getPartySize() {
        return this.partySize;
    }

    public PostalAddress getPickupLocation() {
        return this.pickupLocation;
    }

    public PostalAddress getDropOffLocation() {
        return this.dropOffLocation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleTaxiReservationRequest interfacesConnectionsRequestsScheduleTaxiReservationRequest = (ScheduleTaxiReservationRequest)o;
        return Objects.equals(this.pickupTime, interfacesConnectionsRequestsScheduleTaxiReservationRequest.pickupTime) && Objects.equals(this.partySize, interfacesConnectionsRequestsScheduleTaxiReservationRequest.partySize) && Objects.equals(this.pickupLocation, interfacesConnectionsRequestsScheduleTaxiReservationRequest.pickupLocation) && Objects.equals(this.dropOffLocation, interfacesConnectionsRequestsScheduleTaxiReservationRequest.dropOffLocation) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pickupTime, this.partySize, this.pickupLocation, this.dropOffLocation, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduleTaxiReservationRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    pickupTime: ").append(this.toIndentedString(this.pickupTime)).append("\n");
        sb.append("    partySize: ").append(this.toIndentedString(this.partySize)).append("\n");
        sb.append("    pickupLocation: ").append(this.toIndentedString(this.pickupLocation)).append("\n");
        sb.append("    dropOffLocation: ").append(this.toIndentedString(this.dropOffLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String version;
        private String pickupTime;
        private String partySize;
        private PostalAddress pickupLocation;
        private PostalAddress dropOffLocation;

        private Builder() {
        }

        @JsonProperty(value="@version")
        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="pickupTime")
        public Builder withPickupTime(String pickupTime) {
            this.pickupTime = pickupTime;
            return this;
        }

        @JsonProperty(value="partySize")
        public Builder withPartySize(String partySize) {
            this.partySize = partySize;
            return this;
        }

        @JsonProperty(value="pickupLocation")
        public Builder withPickupLocation(PostalAddress pickupLocation) {
            this.pickupLocation = pickupLocation;
            return this;
        }

        @JsonProperty(value="dropOffLocation")
        public Builder withDropOffLocation(PostalAddress dropOffLocation) {
            this.dropOffLocation = dropOffLocation;
            return this;
        }

        public ScheduleTaxiReservationRequest build() {
            return new ScheduleTaxiReservationRequest(this);
        }
    }
}

