/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.connections;

import com.amazon.ask.model.Directive;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SendRequestDirective
extends Directive {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="payload")
    private Map<String, Object> payload = new HashMap<String, Object>();
    @JsonProperty(value="token")
    private String token = null;

    public static Builder builder() {
        return new Builder();
    }

    private SendRequestDirective(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Connections.SendRequest";
        this.name = builder.name;
        this.payload = builder.payload;
        this.token = builder.token;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendRequestDirective interfacesConnectionsSendRequestDirective = (SendRequestDirective)o;
        return Objects.equals(this.name, interfacesConnectionsSendRequestDirective.name) && Objects.equals(this.payload, interfacesConnectionsSendRequestDirective.payload) && Objects.equals(this.token, interfacesConnectionsSendRequestDirective.token) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.payload, this.token, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendRequestDirective {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String name;
        private Map<String, Object> payload;
        private String token;

        private Builder() {
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="payload")
        public Builder withPayload(Map<String, Object> payload) {
            this.payload = payload;
            return this;
        }

        public Builder putPayloadItem(String key, Object payloadItem) {
            if (this.payload == null) {
                this.payload = new HashMap<String, Object>();
            }
            this.payload.put(key, payloadItem);
            return this;
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public SendRequestDirective build() {
            return new SendRequestDirective(this);
        }
    }
}

