/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.audioplayer;

import com.amazon.ask.model.interfaces.audioplayer.ErrorType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Error {
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="type")
    private ErrorType type = null;

    public static Builder builder() {
        return new Builder();
    }

    private Error(Builder builder) {
        this.message = builder.message;
        this.type = builder.type;
    }

    public String getMessage() {
        return this.message;
    }

    public ErrorType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error interfacesAudioplayerError = (Error)o;
        return Objects.equals(this.message, interfacesAudioplayerError.message) && Objects.equals((Object)this.type, (Object)interfacesAudioplayerError.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String message;
        private ErrorType type;

        private Builder() {
        }

        @JsonProperty(value="message")
        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        @JsonProperty(value="type")
        public Builder withType(ErrorType type) {
            this.type = type;
            return this;
        }

        public Error build() {
            return new Error(this);
        }
    }
}

