/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.audioplayer;

import com.amazon.ask.model.interfaces.audioplayer.PlayerActivity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AudioPlayerState {
    @JsonProperty(value="offsetInMilliseconds")
    private Long offsetInMilliseconds = null;
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="playerActivity")
    private PlayerActivity playerActivity = null;

    public static Builder builder() {
        return new Builder();
    }

    private AudioPlayerState(Builder builder) {
        this.offsetInMilliseconds = builder.offsetInMilliseconds;
        this.token = builder.token;
        this.playerActivity = builder.playerActivity;
    }

    public Long getOffsetInMilliseconds() {
        return this.offsetInMilliseconds;
    }

    public String getToken() {
        return this.token;
    }

    public PlayerActivity getPlayerActivity() {
        return this.playerActivity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioPlayerState interfacesAudioplayerAudioPlayerState = (AudioPlayerState)o;
        return Objects.equals(this.offsetInMilliseconds, interfacesAudioplayerAudioPlayerState.offsetInMilliseconds) && Objects.equals(this.token, interfacesAudioplayerAudioPlayerState.token) && Objects.equals((Object)this.playerActivity, (Object)interfacesAudioplayerAudioPlayerState.playerActivity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.offsetInMilliseconds, this.token, this.playerActivity});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AudioPlayerState {\n");
        sb.append("    offsetInMilliseconds: ").append(this.toIndentedString(this.offsetInMilliseconds)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    playerActivity: ").append(this.toIndentedString((Object)this.playerActivity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Long offsetInMilliseconds;
        private String token;
        private PlayerActivity playerActivity;

        private Builder() {
        }

        @JsonProperty(value="offsetInMilliseconds")
        public Builder withOffsetInMilliseconds(Long offsetInMilliseconds) {
            this.offsetInMilliseconds = offsetInMilliseconds;
            return this;
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="playerActivity")
        public Builder withPlayerActivity(PlayerActivity playerActivity) {
            this.playerActivity = playerActivity;
            return this;
        }

        public AudioPlayerState build() {
            return new AudioPlayerState(this);
        }
    }
}

