/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.audioplayer;

import com.amazon.ask.model.interfaces.display.Image;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AudioItemMetadata {
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="subtitle")
    private String subtitle = null;
    @JsonProperty(value="art")
    private Image art = null;
    @JsonProperty(value="backgroundImage")
    private Image backgroundImage = null;

    public static Builder builder() {
        return new Builder();
    }

    private AudioItemMetadata(Builder builder) {
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.art = builder.art;
        this.backgroundImage = builder.backgroundImage;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public Image getArt() {
        return this.art;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioItemMetadata interfacesAudioplayerAudioItemMetadata = (AudioItemMetadata)o;
        return Objects.equals(this.title, interfacesAudioplayerAudioItemMetadata.title) && Objects.equals(this.subtitle, interfacesAudioplayerAudioItemMetadata.subtitle) && Objects.equals(this.art, interfacesAudioplayerAudioItemMetadata.art) && Objects.equals(this.backgroundImage, interfacesAudioplayerAudioItemMetadata.backgroundImage);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.subtitle, this.art, this.backgroundImage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AudioItemMetadata {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    subtitle: ").append(this.toIndentedString(this.subtitle)).append("\n");
        sb.append("    art: ").append(this.toIndentedString(this.art)).append("\n");
        sb.append("    backgroundImage: ").append(this.toIndentedString(this.backgroundImage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String title;
        private String subtitle;
        private Image art;
        private Image backgroundImage;

        private Builder() {
        }

        @JsonProperty(value="title")
        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="subtitle")
        public Builder withSubtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        @JsonProperty(value="art")
        public Builder withArt(Image art) {
            this.art = art;
            return this;
        }

        @JsonProperty(value="backgroundImage")
        public Builder withBackgroundImage(Image backgroundImage) {
            this.backgroundImage = backgroundImage;
            return this;
        }

        public AudioItemMetadata build() {
            return new AudioItemMetadata(this);
        }
    }
}

