/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.audioplayer;

import com.amazon.ask.model.interfaces.audioplayer.AudioItemMetadata;
import com.amazon.ask.model.interfaces.audioplayer.Stream;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AudioItem {
    @JsonProperty(value="stream")
    private Stream stream = null;
    @JsonProperty(value="metadata")
    private AudioItemMetadata metadata = null;

    public static Builder builder() {
        return new Builder();
    }

    private AudioItem(Builder builder) {
        this.stream = builder.stream;
        this.metadata = builder.metadata;
    }

    public Stream getStream() {
        return this.stream;
    }

    public AudioItemMetadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioItem interfacesAudioplayerAudioItem = (AudioItem)o;
        return Objects.equals(this.stream, interfacesAudioplayerAudioItem.stream) && Objects.equals(this.metadata, interfacesAudioplayerAudioItem.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.stream, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AudioItem {\n");
        sb.append("    stream: ").append(this.toIndentedString(this.stream)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Stream stream;
        private AudioItemMetadata metadata;

        private Builder() {
        }

        @JsonProperty(value="stream")
        public Builder withStream(Stream stream) {
            this.stream = stream;
            return this;
        }

        @JsonProperty(value="metadata")
        public Builder withMetadata(AudioItemMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public AudioItem build() {
            return new AudioItem(this);
        }
    }
}

