/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.amazonpay.model.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Price {
    @JsonProperty(value="amount")
    private String amount = null;
    @JsonProperty(value="currencyCode")
    private String currencyCode = null;

    public static Builder builder() {
        return new Builder();
    }

    private Price(Builder builder) {
        this.amount = builder.amount;
        this.currencyCode = builder.currencyCode;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Price interfacesAmazonpayModelResponsePrice = (Price)o;
        return Objects.equals(this.amount, interfacesAmazonpayModelResponsePrice.amount) && Objects.equals(this.currencyCode, interfacesAmazonpayModelResponsePrice.currencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currencyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Price {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String amount;
        private String currencyCode;

        private Builder() {
        }

        @JsonProperty(value="amount")
        public Builder withAmount(String amount) {
            this.amount = amount;
            return this;
        }

        @JsonProperty(value="currencyCode")
        public Builder withCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Price build() {
            return new Price(this);
        }
    }
}

