/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class VideoSource {
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="duration")
    private Integer duration = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="repeatCount")
    private Integer repeatCount = null;
    @JsonProperty(value="offset")
    private Integer offset = null;

    public static Builder builder() {
        return new Builder();
    }

    private VideoSource(Builder builder) {
        this.description = builder.description;
        this.duration = builder.duration;
        this.url = builder.url;
        this.repeatCount = builder.repeatCount;
        this.offset = builder.offset;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoSource interfacesAlexaPresentationAplVideoSource = (VideoSource)o;
        return Objects.equals(this.description, interfacesAlexaPresentationAplVideoSource.description) && Objects.equals(this.duration, interfacesAlexaPresentationAplVideoSource.duration) && Objects.equals(this.url, interfacesAlexaPresentationAplVideoSource.url) && Objects.equals(this.repeatCount, interfacesAlexaPresentationAplVideoSource.repeatCount) && Objects.equals(this.offset, interfacesAlexaPresentationAplVideoSource.offset);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.duration, this.url, this.repeatCount, this.offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoSource {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    repeatCount: ").append(this.toIndentedString(this.repeatCount)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String description;
        private Integer duration;
        private String url;
        private Integer repeatCount;
        private Integer offset;

        private Builder() {
        }

        @JsonProperty(value="description")
        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="duration")
        public Builder withDuration(Integer duration) {
            this.duration = duration;
            return this;
        }

        @JsonProperty(value="url")
        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        @JsonProperty(value="repeatCount")
        public Builder withRepeatCount(Integer repeatCount) {
            this.repeatCount = repeatCount;
            return this;
        }

        @JsonProperty(value="offset")
        public Builder withOffset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public VideoSource build() {
            return new VideoSource(this);
        }
    }
}

