/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.interfaces.alexa.presentation.apl.Command;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SendEventCommand
extends Command {
    @JsonProperty(value="arguments")
    private List<String> arguments = new ArrayList<String>();
    @JsonProperty(value="components")
    private List<String> components = new ArrayList<String>();

    public static Builder builder() {
        return new Builder();
    }

    private SendEventCommand(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "SendEvent";
        this.delay = builder.delay;
        this.description = builder.description;
        this.when = builder.when;
        this.arguments = builder.arguments;
        this.components = builder.components;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<String> getComponents() {
        return this.components;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendEventCommand interfacesAlexaPresentationAplSendEventCommand = (SendEventCommand)o;
        return Objects.equals(this.arguments, interfacesAlexaPresentationAplSendEventCommand.arguments) && Objects.equals(this.components, interfacesAlexaPresentationAplSendEventCommand.components) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arguments, this.components, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendEventCommand {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Integer delay;
        private String description;
        private Boolean when;
        private List<String> arguments;
        private List<String> components;

        private Builder() {
        }

        @JsonProperty(value="delay")
        public Builder withDelay(Integer delay) {
            this.delay = delay;
            return this;
        }

        @JsonProperty(value="description")
        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="when")
        public Builder withWhen(Boolean when) {
            this.when = when;
            return this;
        }

        @JsonProperty(value="arguments")
        public Builder withArguments(List<String> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder addArgumentsItem(String argumentsItem) {
            if (this.arguments == null) {
                this.arguments = new ArrayList<String>();
            }
            this.arguments.add(argumentsItem);
            return this;
        }

        @JsonProperty(value="components")
        public Builder withComponents(List<String> components) {
            this.components = components;
            return this;
        }

        public Builder addComponentsItem(String componentsItem) {
            if (this.components == null) {
                this.components = new ArrayList<String>();
            }
            this.components.add(componentsItem);
            return this;
        }

        public SendEventCommand build() {
            return new SendEventCommand(this);
        }
    }
}

