/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.apl;

import com.amazon.ask.model.interfaces.alexa.presentation.apl.Command;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AutoPageCommand
extends Command {
    @JsonProperty(value="componentId")
    private String componentId = null;
    @JsonProperty(value="count")
    private Integer count = null;
    @JsonProperty(value="duration")
    private Integer duration = null;

    public static Builder builder() {
        return new Builder();
    }

    private AutoPageCommand(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "AutoPage";
        this.delay = builder.delay;
        this.description = builder.description;
        this.when = builder.when;
        this.componentId = builder.componentId;
        this.count = builder.count;
        this.duration = builder.duration;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getDuration() {
        return this.duration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoPageCommand interfacesAlexaPresentationAplAutoPageCommand = (AutoPageCommand)o;
        return Objects.equals(this.componentId, interfacesAlexaPresentationAplAutoPageCommand.componentId) && Objects.equals(this.count, interfacesAlexaPresentationAplAutoPageCommand.count) && Objects.equals(this.duration, interfacesAlexaPresentationAplAutoPageCommand.duration) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.componentId, this.count, this.duration, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutoPageCommand {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    componentId: ").append(this.toIndentedString(this.componentId)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private Integer delay;
        private String description;
        private Boolean when;
        private String componentId;
        private Integer count;
        private Integer duration;

        private Builder() {
        }

        @JsonProperty(value="delay")
        public Builder withDelay(Integer delay) {
            this.delay = delay;
            return this;
        }

        @JsonProperty(value="description")
        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="when")
        public Builder withWhen(Boolean when) {
            this.when = when;
            return this;
        }

        @JsonProperty(value="componentId")
        public Builder withComponentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        @JsonProperty(value="count")
        public Builder withCount(Integer count) {
            this.count = count;
            return this;
        }

        @JsonProperty(value="duration")
        public Builder withDuration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public AutoPageCommand build() {
            return new AutoPageCommand(this);
        }
    }
}

