/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.er.dynamic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class EntityValueAndSynonyms {
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="synonyms")
    private List<String> synonyms = new ArrayList<String>();

    public static Builder builder() {
        return new Builder();
    }

    private EntityValueAndSynonyms(Builder builder) {
        this.value = builder.value;
        this.synonyms = builder.synonyms;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityValueAndSynonyms erDynamicEntityValueAndSynonyms = (EntityValueAndSynonyms)o;
        return Objects.equals(this.value, erDynamicEntityValueAndSynonyms.value) && Objects.equals(this.synonyms, erDynamicEntityValueAndSynonyms.synonyms);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.synonyms);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityValueAndSynonyms {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    synonyms: ").append(this.toIndentedString(this.synonyms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String value;
        private List<String> synonyms;

        private Builder() {
        }

        @JsonProperty(value="value")
        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="synonyms")
        public Builder withSynonyms(List<String> synonyms) {
            this.synonyms = synonyms;
            return this;
        }

        public Builder addSynonymsItem(String synonymsItem) {
            if (this.synonyms == null) {
                this.synonyms = new ArrayList<String>();
            }
            this.synonyms.add(synonymsItem);
            return this;
        }

        public EntityValueAndSynonyms build() {
            return new EntityValueAndSynonyms(this);
        }
    }
}

