/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.er.dynamic;

import com.amazon.ask.model.er.dynamic.Entity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class EntityListItem {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="values")
    private List<Entity> values = new ArrayList<Entity>();

    public static Builder builder() {
        return new Builder();
    }

    private EntityListItem(Builder builder) {
        this.name = builder.name;
        this.values = builder.values;
    }

    public String getName() {
        return this.name;
    }

    public List<Entity> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityListItem erDynamicEntityListItem = (EntityListItem)o;
        return Objects.equals(this.name, erDynamicEntityListItem.name) && Objects.equals(this.values, erDynamicEntityListItem.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityListItem {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String name;
        private List<Entity> values;

        private Builder() {
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="values")
        public Builder withValues(List<Entity> values) {
            this.values = values;
            return this;
        }

        public Builder addValuesItem(Entity valuesItem) {
            if (this.values == null) {
                this.values = new ArrayList<Entity>();
            }
            this.values.add(valuesItem);
            return this;
        }

        public EntityListItem build() {
            return new EntityListItem(this);
        }
    }
}

