/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.interfaces.alexa.presentation.apl.AlexaPresentationAplInterface;
import com.amazon.ask.model.interfaces.audioplayer.AudioPlayerInterface;
import com.amazon.ask.model.interfaces.display.DisplayInterface;
import com.amazon.ask.model.interfaces.geolocation.GeolocationInterface;
import com.amazon.ask.model.interfaces.videoapp.VideoAppInterface;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SupportedInterfaces {
    @JsonProperty(value="Alexa.Presentation.APL")
    private AlexaPresentationAplInterface alexaPresentationAPL = null;
    @JsonProperty(value="AudioPlayer")
    private AudioPlayerInterface audioPlayer = null;
    @JsonProperty(value="Display")
    private DisplayInterface display = null;
    @JsonProperty(value="VideoApp")
    private VideoAppInterface videoApp = null;
    @JsonProperty(value="Geolocation")
    private GeolocationInterface geolocation = null;

    public static Builder builder() {
        return new Builder();
    }

    private SupportedInterfaces(Builder builder) {
        this.alexaPresentationAPL = builder.alexaPresentationAPL;
        this.audioPlayer = builder.audioPlayer;
        this.display = builder.display;
        this.videoApp = builder.videoApp;
        this.geolocation = builder.geolocation;
    }

    public AlexaPresentationAplInterface getAlexaPresentationAPL() {
        return this.alexaPresentationAPL;
    }

    public AudioPlayerInterface getAudioPlayer() {
        return this.audioPlayer;
    }

    public DisplayInterface getDisplay() {
        return this.display;
    }

    public VideoAppInterface getVideoApp() {
        return this.videoApp;
    }

    public GeolocationInterface getGeolocation() {
        return this.geolocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportedInterfaces supportedInterfaces = (SupportedInterfaces)o;
        return Objects.equals(this.alexaPresentationAPL, supportedInterfaces.alexaPresentationAPL) && Objects.equals(this.audioPlayer, supportedInterfaces.audioPlayer) && Objects.equals(this.display, supportedInterfaces.display) && Objects.equals(this.videoApp, supportedInterfaces.videoApp) && Objects.equals(this.geolocation, supportedInterfaces.geolocation);
    }

    public int hashCode() {
        return Objects.hash(this.alexaPresentationAPL, this.audioPlayer, this.display, this.videoApp, this.geolocation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupportedInterfaces {\n");
        sb.append("    alexaPresentationAPL: ").append(this.toIndentedString(this.alexaPresentationAPL)).append("\n");
        sb.append("    audioPlayer: ").append(this.toIndentedString(this.audioPlayer)).append("\n");
        sb.append("    display: ").append(this.toIndentedString(this.display)).append("\n");
        sb.append("    videoApp: ").append(this.toIndentedString(this.videoApp)).append("\n");
        sb.append("    geolocation: ").append(this.toIndentedString(this.geolocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private AlexaPresentationAplInterface alexaPresentationAPL;
        private AudioPlayerInterface audioPlayer;
        private DisplayInterface display;
        private VideoAppInterface videoApp;
        private GeolocationInterface geolocation;

        private Builder() {
        }

        @JsonProperty(value="Alexa.Presentation.APL")
        public Builder withAlexaPresentationAPL(AlexaPresentationAplInterface alexaPresentationAPL) {
            this.alexaPresentationAPL = alexaPresentationAPL;
            return this;
        }

        @JsonProperty(value="AudioPlayer")
        public Builder withAudioPlayer(AudioPlayerInterface audioPlayer) {
            this.audioPlayer = audioPlayer;
            return this;
        }

        @JsonProperty(value="Display")
        public Builder withDisplay(DisplayInterface display) {
            this.display = display;
            return this;
        }

        @JsonProperty(value="VideoApp")
        public Builder withVideoApp(VideoAppInterface videoApp) {
            this.videoApp = videoApp;
            return this;
        }

        @JsonProperty(value="Geolocation")
        public Builder withGeolocation(GeolocationInterface geolocation) {
            this.geolocation = geolocation;
            return this;
        }

        public SupportedInterfaces build() {
            return new SupportedInterfaces(this);
        }
    }
}

