/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.Scope;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Permissions {
    @JsonProperty(value="consentToken")
    private String consentToken = null;
    @JsonProperty(value="scopes")
    private Map<String, Scope> scopes = new HashMap<String, Scope>();

    public static Builder builder() {
        return new Builder();
    }

    private Permissions(Builder builder) {
        this.consentToken = builder.consentToken;
        this.scopes = builder.scopes;
    }

    public String getConsentToken() {
        return this.consentToken;
    }

    public Map<String, Scope> getScopes() {
        return this.scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permissions permissions = (Permissions)o;
        return Objects.equals(this.consentToken, permissions.consentToken) && Objects.equals(this.scopes, permissions.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.consentToken, this.scopes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Permissions {\n");
        sb.append("    consentToken: ").append(this.toIndentedString(this.consentToken)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String consentToken;
        private Map<String, Scope> scopes;

        private Builder() {
        }

        @JsonProperty(value="consentToken")
        public Builder withConsentToken(String consentToken) {
            this.consentToken = consentToken;
            return this;
        }

        @JsonProperty(value="scopes")
        public Builder withScopes(Map<String, Scope> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder putScopesItem(String key, Scope scopesItem) {
            if (this.scopes == null) {
                this.scopes = new HashMap<String, Scope>();
            }
            this.scopes.put(key, scopesItem);
            return this;
        }

        public Permissions build() {
            return new Permissions(this);
        }
    }
}

