/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.interfaces.audioplayer.AudioPlayerState;
import com.amazon.ask.model.interfaces.automotive.AutomotiveState;
import com.amazon.ask.model.interfaces.display.DisplayState;
import com.amazon.ask.model.interfaces.geolocation.GeolocationState;
import com.amazon.ask.model.interfaces.system.SystemState;
import com.amazon.ask.model.interfaces.viewport.ViewportState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Context {
    @JsonProperty(value="System")
    private SystemState system = null;
    @JsonProperty(value="AudioPlayer")
    private AudioPlayerState audioPlayer = null;
    @JsonProperty(value="Automotive")
    private AutomotiveState automotive = null;
    @JsonProperty(value="Display")
    private DisplayState display = null;
    @JsonProperty(value="Geolocation")
    private GeolocationState geolocation = null;
    @JsonProperty(value="Viewport")
    private ViewportState viewport = null;

    public static Builder builder() {
        return new Builder();
    }

    private Context(Builder builder) {
        this.system = builder.system;
        this.audioPlayer = builder.audioPlayer;
        this.automotive = builder.automotive;
        this.display = builder.display;
        this.geolocation = builder.geolocation;
        this.viewport = builder.viewport;
    }

    public SystemState getSystem() {
        return this.system;
    }

    public AudioPlayerState getAudioPlayer() {
        return this.audioPlayer;
    }

    public AutomotiveState getAutomotive() {
        return this.automotive;
    }

    public DisplayState getDisplay() {
        return this.display;
    }

    public GeolocationState getGeolocation() {
        return this.geolocation;
    }

    public ViewportState getViewport() {
        return this.viewport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context context = (Context)o;
        return Objects.equals(this.system, context.system) && Objects.equals(this.audioPlayer, context.audioPlayer) && Objects.equals(this.automotive, context.automotive) && Objects.equals(this.display, context.display) && Objects.equals(this.geolocation, context.geolocation) && Objects.equals(this.viewport, context.viewport);
    }

    public int hashCode() {
        return Objects.hash(this.system, this.audioPlayer, this.automotive, this.display, this.geolocation, this.viewport);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Context {\n");
        sb.append("    system: ").append(this.toIndentedString(this.system)).append("\n");
        sb.append("    audioPlayer: ").append(this.toIndentedString(this.audioPlayer)).append("\n");
        sb.append("    automotive: ").append(this.toIndentedString(this.automotive)).append("\n");
        sb.append("    display: ").append(this.toIndentedString(this.display)).append("\n");
        sb.append("    geolocation: ").append(this.toIndentedString(this.geolocation)).append("\n");
        sb.append("    viewport: ").append(this.toIndentedString(this.viewport)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private SystemState system;
        private AudioPlayerState audioPlayer;
        private AutomotiveState automotive;
        private DisplayState display;
        private GeolocationState geolocation;
        private ViewportState viewport;

        private Builder() {
        }

        @JsonProperty(value="System")
        public Builder withSystem(SystemState system) {
            this.system = system;
            return this;
        }

        @JsonProperty(value="AudioPlayer")
        public Builder withAudioPlayer(AudioPlayerState audioPlayer) {
            this.audioPlayer = audioPlayer;
            return this;
        }

        @JsonProperty(value="Automotive")
        public Builder withAutomotive(AutomotiveState automotive) {
            this.automotive = automotive;
            return this;
        }

        @JsonProperty(value="Display")
        public Builder withDisplay(DisplayState display) {
            this.display = display;
            return this;
        }

        @JsonProperty(value="Geolocation")
        public Builder withGeolocation(GeolocationState geolocation) {
            this.geolocation = geolocation;
            return this;
        }

        @JsonProperty(value="Viewport")
        public Builder withViewport(ViewportState viewport) {
            this.viewport = viewport;
            return this;
        }

        public Context build() {
            return new Context(this);
        }
    }
}

