/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.attributes.persistence.impl;

import com.amazon.ask.exception.PersistenceException;
import com.amazon.ask.model.Context;
import com.amazon.ask.model.Device;
import com.amazon.ask.model.RequestEnvelope;
import com.amazon.ask.model.User;
import com.amazon.ask.model.interfaces.system.SystemState;
import java.util.Optional;
import java.util.function.Function;

public class PartitionKeyGenerators {
    private PartitionKeyGenerators() {
    }

    public static Function<RequestEnvelope, String> userId() {
        return r -> Optional.ofNullable(r).map(RequestEnvelope::getContext).map(Context::getSystem).map(SystemState::getUser).map(User::getUserId).orElseThrow(() -> new PersistenceException("Could not retrieve user ID from request envelope to generate persistence ID"));
    }

    public static Function<RequestEnvelope, String> deviceId() {
        return r -> Optional.ofNullable(r).map(RequestEnvelope::getContext).map(Context::getSystem).map(SystemState::getDevice).map(Device::getDeviceId).orElseThrow(() -> new PersistenceException("Could not retrieve device ID from request envelope to generate persistence ID"));
    }
}

