/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.response;

import com.amazon.ask.model.Directive;
import com.amazon.ask.model.Intent;
import com.amazon.ask.model.Response;
import com.amazon.ask.model.canfulfill.CanFulfillIntent;
import com.amazon.ask.model.dialog.ConfirmIntentDirective;
import com.amazon.ask.model.dialog.ConfirmSlotDirective;
import com.amazon.ask.model.dialog.DelegateDirective;
import com.amazon.ask.model.dialog.ElicitSlotDirective;
import com.amazon.ask.model.interfaces.alexa.experimentation.ExperimentTriggerResponse;
import com.amazon.ask.model.interfaces.audioplayer.AudioItem;
import com.amazon.ask.model.interfaces.audioplayer.AudioItemMetadata;
import com.amazon.ask.model.interfaces.audioplayer.ClearBehavior;
import com.amazon.ask.model.interfaces.audioplayer.ClearQueueDirective;
import com.amazon.ask.model.interfaces.audioplayer.PlayBehavior;
import com.amazon.ask.model.interfaces.audioplayer.PlayDirective;
import com.amazon.ask.model.interfaces.audioplayer.StopDirective;
import com.amazon.ask.model.interfaces.audioplayer.Stream;
import com.amazon.ask.model.interfaces.display.Hint;
import com.amazon.ask.model.interfaces.display.HintDirective;
import com.amazon.ask.model.interfaces.display.PlainTextHint;
import com.amazon.ask.model.interfaces.display.RenderTemplateDirective;
import com.amazon.ask.model.interfaces.display.Template;
import com.amazon.ask.model.interfaces.videoapp.LaunchDirective;
import com.amazon.ask.model.interfaces.videoapp.Metadata;
import com.amazon.ask.model.interfaces.videoapp.VideoItem;
import com.amazon.ask.model.ui.AskForPermissionsConsentCard;
import com.amazon.ask.model.ui.Card;
import com.amazon.ask.model.ui.Image;
import com.amazon.ask.model.ui.LinkAccountCard;
import com.amazon.ask.model.ui.OutputSpeech;
import com.amazon.ask.model.ui.Reprompt;
import com.amazon.ask.model.ui.SimpleCard;
import com.amazon.ask.model.ui.SsmlOutputSpeech;
import com.amazon.ask.model.ui.StandardCard;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ResponseBuilder {
    private static final String SPEAK_OPEN_TAG = "<speak>";
    private static final String SPEAK_CLOSE_TAG = "</speak>";
    protected OutputSpeech speech;
    protected Card card;
    protected List<Directive> directiveList;
    protected Boolean shouldEndSession;
    protected Reprompt reprompt;
    protected CanFulfillIntent canFulfillIntent;
    protected Object apiResponse;
    protected ExperimentTriggerResponse experimentTriggerResponse;

    public Optional<Response> build() {
        return Optional.of(Response.builder().withOutputSpeech(this.speech).withCard(this.card).withReprompt(this.reprompt).withDirectives(this.directiveList).withCanFulfillIntent(this.canFulfillIntent).withShouldEndSession(this.shouldEndSession).withApiResponse(this.apiResponse).withExperimentation(this.experimentTriggerResponse).build());
    }

    public ResponseBuilder withSpeech(String speechText) {
        return this.withSpeech(speechText, null);
    }

    public ResponseBuilder withSpeech(String speechText, com.amazon.ask.model.ui.PlayBehavior playBehavior) {
        this.speech = SsmlOutputSpeech.builder().withSsml(SPEAK_OPEN_TAG + this.trimOutputSpeech(speechText) + SPEAK_CLOSE_TAG).withPlayBehavior(playBehavior).build();
        return this;
    }

    public ResponseBuilder withCard(Card card) {
        this.card = card;
        return this;
    }

    public ResponseBuilder withSimpleCard(String cardTitle, String cardText) {
        this.card = SimpleCard.builder().withContent(cardText).withTitle(cardTitle).build();
        return this;
    }

    public ResponseBuilder withStandardCard(String cardTitle, String cardText, Image image) {
        this.card = StandardCard.builder().withText(cardText).withImage(image).withTitle(cardTitle).build();
        return this;
    }

    public ResponseBuilder withLinkAccountCard() {
        this.card = LinkAccountCard.builder().build();
        return this;
    }

    public ResponseBuilder withAskForPermissionsConsentCard(List<String> permissions) {
        this.card = AskForPermissionsConsentCard.builder().withPermissions(permissions).build();
        return this;
    }

    public ResponseBuilder withReprompt(String text) {
        return this.withReprompt(text, null, null);
    }

    public ResponseBuilder withReprompt(String text, Directive directive) {
        return this.withReprompt(text, directive, null);
    }

    public ResponseBuilder withReprompt(String text, com.amazon.ask.model.ui.PlayBehavior playBehavior) {
        return this.withReprompt(text, null, playBehavior);
    }

    public ResponseBuilder withReprompt(String text, Directive directive, com.amazon.ask.model.ui.PlayBehavior playBehavior) {
        if (directive != null) {
            SsmlOutputSpeech outputSpeech = null;
            if (text == null || text.isEmpty()) {
                if (playBehavior != null) {
                    outputSpeech = SsmlOutputSpeech.builder().withPlayBehavior(playBehavior).build();
                }
            } else {
                outputSpeech = SsmlOutputSpeech.builder().withSsml(SPEAK_OPEN_TAG + this.trimOutputSpeech(text) + SPEAK_CLOSE_TAG).withPlayBehavior(playBehavior).build();
            }
            this.reprompt = Reprompt.builder().withOutputSpeech(outputSpeech).addDirectivesItem(directive).build();
        } else {
            this.reprompt = Reprompt.builder().withOutputSpeech((OutputSpeech)SsmlOutputSpeech.builder().withSsml(SPEAK_OPEN_TAG + this.trimOutputSpeech(text) + SPEAK_CLOSE_TAG).withPlayBehavior(playBehavior).build()).build();
        }
        this.withShouldEndSession(false);
        return this;
    }

    public ResponseBuilder withShouldEndSession(Boolean shouldEndSession) {
        if (!this.isVideoAppLaunchDirectivePresent()) {
            this.shouldEndSession = shouldEndSession;
        }
        return this;
    }

    public ResponseBuilder withApiResponse(Object apiResponse) {
        this.apiResponse = apiResponse;
        return this;
    }

    public ResponseBuilder addHintDirective(String hintText) {
        PlainTextHint hint = PlainTextHint.builder().withText(hintText).build();
        HintDirective hintDirective = HintDirective.builder().withHint((Hint)hint).build();
        return this.addDirective((Directive)hintDirective);
    }

    public ResponseBuilder addVideoAppLaunchDirective(String source, String title, String subtitle) {
        Metadata metadata = Metadata.builder().withSubtitle(subtitle).withTitle(title).build();
        VideoItem videoItem = VideoItem.builder().withSource(source).withMetadata(metadata).build();
        LaunchDirective videoDirective = LaunchDirective.builder().withVideoItem(videoItem).build();
        this.shouldEndSession = null;
        return this.addDirective((Directive)videoDirective);
    }

    public ResponseBuilder addRenderTemplateDirective(Template template) {
        RenderTemplateDirective templateDirective = RenderTemplateDirective.builder().withTemplate(template).build();
        return this.addDirective((Directive)templateDirective);
    }

    public ResponseBuilder addDelegateDirective(Intent updatedIntent) {
        DelegateDirective delegateDirective = DelegateDirective.builder().withUpdatedIntent(updatedIntent).build();
        return this.addDirective((Directive)delegateDirective);
    }

    public ResponseBuilder addElicitSlotDirective(String slotName, Intent updatedIntent) {
        ElicitSlotDirective elicitSlotDirective = ElicitSlotDirective.builder().withUpdatedIntent(updatedIntent).withSlotToElicit(slotName).build();
        return this.addDirective((Directive)elicitSlotDirective);
    }

    public ResponseBuilder addConfirmSlotDirective(String slotName, Intent updatedIntent) {
        ConfirmSlotDirective confirmSlotDirective = ConfirmSlotDirective.builder().withSlotToConfirm(slotName).withUpdatedIntent(updatedIntent).build();
        return this.addDirective((Directive)confirmSlotDirective);
    }

    public ResponseBuilder addConfirmIntentDirective(Intent updatedIntent) {
        ConfirmIntentDirective confirmIntentDirective = ConfirmIntentDirective.builder().withUpdatedIntent(updatedIntent).build();
        return this.addDirective((Directive)confirmIntentDirective);
    }

    public ResponseBuilder addAudioPlayerPlayDirective(PlayBehavior playBehavior, Long offsetInMilliseconds, String expectedPreviousToken, String token, String url) {
        return this.addAudioPlayerPlayDirective(playBehavior, offsetInMilliseconds, expectedPreviousToken, token, url, null);
    }

    public ResponseBuilder addAudioPlayerPlayDirective(PlayBehavior playBehavior, Long offsetInMilliseconds, String expectedPreviousToken, String token, String url, AudioItemMetadata metadata) {
        return this.addDirective((Directive)this.buildAudioPlayerPlayDirective(playBehavior, offsetInMilliseconds, expectedPreviousToken, token, url, metadata));
    }

    public ResponseBuilder addAudioPlayerStopDirective() {
        StopDirective stopDirective = StopDirective.builder().build();
        return this.addDirective((Directive)stopDirective);
    }

    public ResponseBuilder addAudioPlayerClearQueueDirective(ClearBehavior clearBehavior) {
        ClearQueueDirective clearQueueDirective = ClearQueueDirective.builder().withClearBehavior(clearBehavior).build();
        return this.addDirective((Directive)clearQueueDirective);
    }

    public ResponseBuilder addDirective(Directive directive) {
        if (this.directiveList == null) {
            this.directiveList = new ArrayList<Directive>();
        }
        this.directiveList.add(directive);
        return this;
    }

    public ResponseBuilder addExperimentTrigger(String experimentId) {
        if (this.experimentTriggerResponse == null) {
            this.experimentTriggerResponse = ExperimentTriggerResponse.builder().build();
        }
        this.experimentTriggerResponse.getTriggeredExperiments().add(experimentId);
        return this;
    }

    public ResponseBuilder withCanFulfillIntent(CanFulfillIntent canFulfillIntent) {
        this.canFulfillIntent = canFulfillIntent;
        return this;
    }

    private boolean isVideoAppLaunchDirectivePresent() {
        if (this.directiveList == null || this.directiveList.isEmpty()) {
            return false;
        }
        for (Directive directive : this.directiveList) {
            if (directive == null || !directive.getType().equals("VideoApp.Launch")) continue;
            return true;
        }
        return false;
    }

    private String trimOutputSpeech(String outputSpeech) {
        if (outputSpeech == null) {
            return "";
        }
        String trimmedOutputSpeech = outputSpeech.trim();
        if (trimmedOutputSpeech.startsWith(SPEAK_OPEN_TAG) && trimmedOutputSpeech.endsWith(SPEAK_CLOSE_TAG)) {
            return trimmedOutputSpeech.substring(SPEAK_OPEN_TAG.length(), trimmedOutputSpeech.length() - SPEAK_CLOSE_TAG.length()).trim();
        }
        return trimmedOutputSpeech;
    }

    private PlayDirective buildAudioPlayerPlayDirective(PlayBehavior playBehavior, Long offsetInMilliseconds, String expectedPreviousToken, String token, String url, AudioItemMetadata metadata) {
        Stream stream = Stream.builder().withOffsetInMilliseconds(offsetInMilliseconds).withExpectedPreviousToken(expectedPreviousToken).withToken(token).withUrl(url).build();
        AudioItem.Builder audioItemBuilder = AudioItem.builder();
        if (metadata != null) {
            audioItemBuilder.withMetadata(metadata);
        }
        AudioItem audioItem = audioItemBuilder.withStream(stream).build();
        return PlayDirective.builder().withPlayBehavior(playBehavior).withAudioItem(audioItem).build();
    }
}

