/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.dispatcher.request.handler;

import com.amazon.ask.attributes.AttributesManager;
import com.amazon.ask.attributes.persistence.PersistenceAdapter;
import com.amazon.ask.exception.template.TemplateFactoryException;
import com.amazon.ask.model.Request;
import com.amazon.ask.model.RequestEnvelope;
import com.amazon.ask.model.Response;
import com.amazon.ask.model.services.ServiceClientFactory;
import com.amazon.ask.request.exception.handler.impl.AbstractHandlerInput;
import com.amazon.ask.response.ResponseBuilder;
import com.amazon.ask.response.template.TemplateFactory;
import com.amazon.ask.util.ValidationUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class HandlerInput
extends AbstractHandlerInput<Request> {
    protected final RequestEnvelope requestEnvelope;
    protected final AttributesManager attributesManager;
    protected final ServiceClientFactory serviceClientFactory;
    protected final ResponseBuilder responseBuilder;
    protected final JsonNode requestEnvelopeJson;
    protected final TemplateFactory<HandlerInput, Response> templateFactory;

    protected HandlerInput(RequestEnvelope requestEnvelope, PersistenceAdapter persistenceAdapter, Object context, ServiceClientFactory serviceClientFactory, JsonNode requestEnvelopeJson, TemplateFactory<HandlerInput, Response> templateFactory) {
        super((Object)((RequestEnvelope)ValidationUtils.assertNotNull((Object)requestEnvelope, (String)"request envelope")).getRequest(), context);
        this.requestEnvelope = requestEnvelope;
        this.serviceClientFactory = serviceClientFactory;
        this.attributesManager = AttributesManager.builder().withRequestEnvelope(requestEnvelope).withPersistenceAdapter(persistenceAdapter).build();
        this.responseBuilder = new ResponseBuilder();
        this.requestEnvelopeJson = requestEnvelopeJson;
        this.templateFactory = templateFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Response> generateTemplateResponse(String responseTemplateName, Map<String, Object> dataMap) throws TemplateFactoryException {
        return Optional.of(this.templateFactory.processTemplate(responseTemplateName, dataMap, (Object)this));
    }

    public RequestEnvelope getRequestEnvelope() {
        return this.requestEnvelope;
    }

    public AttributesManager getAttributesManager() {
        return this.attributesManager;
    }

    public JsonNode getRequestEnvelopeJson() {
        return this.requestEnvelopeJson;
    }

    public ServiceClientFactory getServiceClientFactory() {
        if (this.serviceClientFactory == null) {
            throw new IllegalStateException("Attempting to use service client factory with no configured API client");
        }
        return this.serviceClientFactory;
    }

    public boolean matches(Predicate<HandlerInput> predicate) {
        return predicate.test(this);
    }

    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    public static final class Builder
    extends AbstractHandlerInput.Builder<Request, Builder> {
        private RequestEnvelope requestEnvelope;
        private PersistenceAdapter persistenceAdapter;
        private ServiceClientFactory serviceClientFactory;
        private JsonNode requestEnvelopeJson;
        private TemplateFactory templateFactory;

        private Builder() {
        }

        public Builder withRequestEnvelope(RequestEnvelope requestEnvelope) {
            this.requestEnvelope = requestEnvelope;
            return this;
        }

        public Builder withPersistenceAdapter(PersistenceAdapter persistenceAdapter) {
            this.persistenceAdapter = persistenceAdapter;
            return this;
        }

        public Builder withServiceClientFactory(ServiceClientFactory serviceClientFactory) {
            this.serviceClientFactory = serviceClientFactory;
            return this;
        }

        public Builder withRequestEnvelopeJson(JsonNode requestEnvelopeJson) {
            this.requestEnvelopeJson = requestEnvelopeJson;
            return this;
        }

        public Builder withTemplateFactory(TemplateFactory templateFactory) {
            this.templateFactory = templateFactory;
            return this;
        }

        public HandlerInput build() {
            return new HandlerInput(this.requestEnvelope, this.persistenceAdapter, this.context, this.serviceClientFactory, this.requestEnvelopeJson, (TemplateFactory<HandlerInput, Response>)this.templateFactory);
        }
    }
}

