/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.util;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentUtils {
    private static Logger logger = LoggerFactory.getLogger(UserAgentUtils.class);

    private UserAgentUtils() {
    }

    public static String getUserAgent() {
        return UserAgentUtils.getUserAgent(null);
    }

    public static String getUserAgent(String customUserAgent) {
        Properties systemProperties;
        try {
            systemProperties = System.getProperties();
        }
        catch (SecurityException e) {
            logger.debug("Unable to determine JVM version due to security restrictions.");
            systemProperties = null;
        }
        return UserAgentUtils.internalGetUserAgent(systemProperties, customUserAgent);
    }

    static String internalGetUserAgent(Properties systemProperties, String customUserAgent) {
        String coreUserAgent = String.format("ask-java/%s Java/%s", "2.17.2", UserAgentUtils.getJavaVersion(systemProperties));
        return coreUserAgent + (customUserAgent != null ? " " + customUserAgent : "");
    }

    private static String getJavaVersion(Properties systemProperties) {
        if (systemProperties != null && systemProperties.getProperty("java.version") != null) {
            return systemProperties.getProperty("java.version");
        }
        return "UNKNOWN";
    }
}

