/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.request;

import com.amazon.ask.dispatcher.request.handler.HandlerInput;
import com.amazon.ask.model.IntentRequest;
import com.amazon.ask.model.Request;
import com.amazon.ask.model.Slot;
import com.amazon.ask.model.canfulfill.CanFulfillIntentRequest;
import com.amazon.ask.model.interfaces.display.ElementSelectedRequest;
import com.amazon.ask.request.viewport.ViewportProfile;
import com.amazon.ask.request.viewport.ViewportUtils;
import java.util.function.Predicate;

public class Predicates {
    private Predicates() {
    }

    public static <T extends Request> Predicate<HandlerInput> requestType(Class<T> requestType) {
        return i -> requestType.isInstance(i.getRequestEnvelope().getRequest());
    }

    public static Predicate<HandlerInput> intentName(String intentName) {
        return i -> i.getRequestEnvelope().getRequest() instanceof IntentRequest && intentName.equals(((IntentRequest)i.getRequestEnvelope().getRequest()).getIntent().getName());
    }

    public static Predicate<HandlerInput> canFulfillIntentName(String intentName) {
        return i -> i.getRequestEnvelope().getRequest() instanceof CanFulfillIntentRequest && intentName.equals(((CanFulfillIntentRequest)i.getRequestEnvelope().getRequest()).getIntent().getName());
    }

    public static Predicate<HandlerInput> slotValue(String slotName, String slotValue) {
        return i -> i.getRequestEnvelope().getRequest() instanceof IntentRequest && ((IntentRequest)i.getRequestEnvelope().getRequest()).getIntent().getSlots() != null && ((IntentRequest)i.getRequestEnvelope().getRequest()).getIntent().getSlots().containsKey(slotName) && slotValue.equals(((Slot)((IntentRequest)i.getRequestEnvelope().getRequest()).getIntent().getSlots().get(slotName)).getValue());
    }

    public static Predicate<HandlerInput> canFulfillSlotValue(String slotName, String slotValue) {
        return i -> i.getRequestEnvelope().getRequest() instanceof CanFulfillIntentRequest && ((CanFulfillIntentRequest)i.getRequestEnvelope().getRequest()).getIntent().getSlots() != null && ((CanFulfillIntentRequest)i.getRequestEnvelope().getRequest()).getIntent().getSlots().containsKey(slotName) && slotValue.equals(((Slot)((CanFulfillIntentRequest)i.getRequestEnvelope().getRequest()).getIntent().getSlots().get(slotName)).getValue());
    }

    public static Predicate<HandlerInput> selectedElementToken(String elementToken) {
        return i -> i.getRequestEnvelope().getRequest() instanceof ElementSelectedRequest && elementToken.equals(((ElementSelectedRequest)i.getRequestEnvelope().getRequest()).getToken());
    }

    public static Predicate<HandlerInput> requestAttribute(String key, Object value) {
        return i -> i.getAttributesManager().getRequestAttributes().containsKey(key) && value.equals(i.getAttributesManager().getRequestAttributes().get(key));
    }

    public static Predicate<HandlerInput> sessionAttribute(String key, Object value) {
        return i -> i.getRequestEnvelope().getSession() != null && i.getAttributesManager().getSessionAttributes().containsKey(key) && value.equals(i.getAttributesManager().getSessionAttributes().get(key));
    }

    public static Predicate<HandlerInput> persistentAttribute(String key, Object value) {
        return i -> i.getAttributesManager().getPersistentAttributes().containsKey(key) && value.equals(i.getAttributesManager().getPersistentAttributes().get(key));
    }

    public static Predicate<HandlerInput> viewportProfile(ViewportProfile viewportProfile) {
        return i -> viewportProfile.equals((Object)ViewportUtils.getViewportProfile(i.getRequestEnvelope()));
    }
}

