/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask;

import com.amazon.ask.AlexaSkill;
import com.amazon.ask.attributes.persistence.PersistenceAdapter;
import com.amazon.ask.builder.CustomSkillConfiguration;
import com.amazon.ask.dispatcher.request.handler.HandlerInput;
import com.amazon.ask.exception.AskSdkException;
import com.amazon.ask.impl.AbstractSkill;
import com.amazon.ask.model.RequestEnvelope;
import com.amazon.ask.model.Response;
import com.amazon.ask.model.ResponseEnvelope;
import com.amazon.ask.model.services.ApiClient;
import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.DefaultApiConfiguration;
import com.amazon.ask.model.services.Serializer;
import com.amazon.ask.model.services.ServiceClientFactory;
import com.amazon.ask.request.UnmarshalledRequest;
import com.amazon.ask.request.dispatcher.GenericRequestDispatcher;
import com.amazon.ask.request.dispatcher.impl.BaseRequestDispatcher;
import com.amazon.ask.request.impl.BaseUnmarshalledRequest;
import com.amazon.ask.response.template.TemplateFactory;
import com.amazon.ask.util.JacksonSerializer;
import com.amazon.ask.util.JsonMarshaller;
import com.amazon.ask.util.JsonUnmarshaller;
import com.amazon.ask.util.UserAgentUtils;
import com.amazon.ask.util.impl.JacksonJsonMarshaller;
import com.amazon.ask.util.impl.JacksonJsonUnmarshaller;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.Optional;

public class CustomSkill
extends AbstractSkill<RequestEnvelope, ResponseEnvelope>
implements AlexaSkill<RequestEnvelope, ResponseEnvelope> {
    protected final GenericRequestDispatcher<HandlerInput, Optional<Response>> requestDispatcher;
    protected final PersistenceAdapter persistenceAdapter;
    protected final ApiClient apiClient;
    protected final Serializer serializer;
    protected final String customUserAgent;
    protected final String skillId;
    protected final TemplateFactory<HandlerInput, Response> templateFactory;

    public CustomSkill(CustomSkillConfiguration configuration) {
        super((JsonUnmarshaller)JacksonJsonUnmarshaller.withTypeBinding(RequestEnvelope.class, (String)"request"), (JsonMarshaller)JacksonJsonMarshaller.forType(ResponseEnvelope.class));
        this.persistenceAdapter = configuration.getPersistenceAdapter();
        this.requestDispatcher = BaseRequestDispatcher.builder().withRequestMappers((Collection)configuration.getRequestMappers()).withHandlerAdapters((Collection)configuration.getHandlerAdapters()).withExceptionMapper(configuration.getExceptionMapper()).withRequestInterceptors((Collection)configuration.getRequestInterceptors()).withResponseInterceptors((Collection)configuration.getResponseInterceptors()).build();
        this.apiClient = configuration.getApiClient();
        this.serializer = new JacksonSerializer();
        this.customUserAgent = configuration.getCustomUserAgent();
        this.skillId = configuration.getSkillId();
        this.templateFactory = configuration.getTemplateFactory();
    }

    public ResponseEnvelope invoke(RequestEnvelope requestEnvelope) {
        return this.invoke(requestEnvelope, null);
    }

    public ResponseEnvelope invoke(RequestEnvelope requestEnvelope, Object context) {
        return this.invoke((UnmarshalledRequest<RequestEnvelope>)new BaseUnmarshalledRequest((Object)requestEnvelope, null), context);
    }

    protected ResponseEnvelope invoke(UnmarshalledRequest<RequestEnvelope> unmarshalledRequest, Object context) {
        RequestEnvelope requestEnvelope = (RequestEnvelope)unmarshalledRequest.getUnmarshalledRequest();
        JsonNode requestEnvelopeJson = unmarshalledRequest.getRequestJson();
        if (this.skillId != null && !requestEnvelope.getContext().getSystem().getApplication().getApplicationId().equals(this.skillId)) {
            throw new AskSdkException("AlexaSkill ID verification failed.");
        }
        ServiceClientFactory serviceClientFactory = this.apiClient != null ? ServiceClientFactory.builder().withDefaultApiConfiguration(this.getApiConfiguration(requestEnvelope)).build() : null;
        HandlerInput handlerInput = ((HandlerInput.Builder)HandlerInput.builder().withRequestEnvelope(requestEnvelope).withPersistenceAdapter(this.persistenceAdapter).withContext(context)).withRequestEnvelopeJson(requestEnvelopeJson).withServiceClientFactory(serviceClientFactory).withTemplateFactory(this.templateFactory).build();
        Optional response = (Optional)this.requestDispatcher.dispatch((Object)handlerInput);
        return ResponseEnvelope.builder().withResponse(response != null ? (Response)response.orElse(null) : null).withSessionAttributes(requestEnvelope.getSession() != null ? handlerInput.getAttributesManager().getSessionAttributes() : null).withVersion("1.0").withUserAgent(UserAgentUtils.getUserAgent(this.customUserAgent)).build();
    }

    protected ApiConfiguration getApiConfiguration(RequestEnvelope requestEnvelope) {
        String apiEndpoint = requestEnvelope.getContext().getSystem().getApiEndpoint();
        String apiToken = requestEnvelope.getContext().getSystem().getApiAccessToken();
        return DefaultApiConfiguration.builder().withApiClient(this.apiClient).withApiEndpoint(apiEndpoint).withAuthorizationValue(apiToken).withSerializer(this.serializer).build();
    }
}

