/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.services;

import com.amazon.ask.model.services.ApiClient;
import com.amazon.ask.model.services.ApiClientRequest;
import com.amazon.ask.model.services.ApiClientResponse;
import com.amazon.ask.model.services.Pair;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ApacheHttpApiClient
implements ApiClient {
    private final CloseableHttpClient httpClient;

    private ApacheHttpApiClient(Builder builder) {
        this.httpClient = builder.httpClient;
    }

    public static ApacheHttpApiClient standard() {
        return new Builder().withHttpClient(HttpClients.createDefault()).build();
    }

    public static Builder custom() {
        return new Builder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiClientResponse invoke(ApiClientRequest request) {
        HttpUriRequest lowLevelRequest = this.generateRequest(request);
        try (CloseableHttpResponse lowLevelResponse = this.httpClient.execute(lowLevelRequest);){
            ApiClientResponse apiClientResponse = this.generateResponse(lowLevelResponse);
            return apiClientResponse;
        }
        catch (IOException e) {
            throw new RuntimeException("There was an error executing the request", e);
        }
    }

    private HttpUriRequest generateRequest(ApiClientRequest request) {
        HttpGet lowLevelRequest;
        switch (request.getMethod()) {
            case "GET": {
                lowLevelRequest = new HttpGet(request.getUrl());
                break;
            }
            case "PUT": {
                lowLevelRequest = new HttpPut(request.getUrl());
                break;
            }
            case "POST": {
                lowLevelRequest = new HttpPost(request.getUrl());
                break;
            }
            case "DELETE": {
                lowLevelRequest = new HttpDelete(request.getUrl());
                break;
            }
            case "OPTIONS": {
                lowLevelRequest = new HttpOptions(request.getUrl());
                break;
            }
            case "HEAD": {
                lowLevelRequest = new HttpHead(request.getUrl());
                break;
            }
            case "PATCH": {
                lowLevelRequest = new HttpPatch(request.getUrl());
                break;
            }
            default: {
                throw new RuntimeException("Invalid request method: " + request.getMethod());
            }
        }
        if (request.getHeaders() != null) {
            for (Pair header : request.getHeaders()) {
                lowLevelRequest.setHeader((String)header.getName(), (String)header.getValue());
            }
        }
        if (lowLevelRequest instanceof HttpEntityEnclosingRequestBase && request.getBody() != null) {
            StringEntity entity = new StringEntity(request.getBody(), ContentType.APPLICATION_JSON);
            ((HttpEntityEnclosingRequestBase)lowLevelRequest).setEntity((HttpEntity)entity);
        }
        return lowLevelRequest;
    }

    private ApiClientResponse generateResponse(CloseableHttpResponse lowLevelResponse) throws IOException {
        ApiClientResponse response = new ApiClientResponse();
        response.setStatusCode(lowLevelResponse.getStatusLine().getStatusCode());
        response.setHeaders(Arrays.stream(lowLevelResponse.getAllHeaders()).map(h -> new Pair((Object)h.getName(), (Object)h.getValue())).collect(Collectors.toList()));
        if (lowLevelResponse.getEntity() != null) {
            response.setBody(EntityUtils.toString((HttpEntity)lowLevelResponse.getEntity()));
        }
        return response;
    }

    public static final class Builder {
        private CloseableHttpClient httpClient;

        private Builder() {
        }

        public Builder withHttpClient(CloseableHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public ApacheHttpApiClient build() {
            return new ApacheHttpApiClient(this);
        }
    }
}

