/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.svg;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Picture;
import android.graphics.RectF;
import com.autonavi.ae.svg.CSSParser;
import com.autonavi.ae.svg.PreserveAspectRatio;
import com.autonavi.ae.svg.RenderOptions;
import com.autonavi.ae.svg.SVGAndroidRenderer;
import com.autonavi.ae.svg.SVGExternalFileResolver;
import com.autonavi.ae.svg.SVGParseException;
import com.autonavi.ae.svg.SVGParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SVG {
    private static final String VERSION = "1.4";
    private static final int DEFAULT_PICTURE_WIDTH = 512;
    private static final int DEFAULT_PICTURE_HEIGHT = 512;
    private static final double SQRT2 = 1.414213562373095;
    private static SVGExternalFileResolver externalFileResolver = null;
    private static boolean enableInternalEntities = true;
    private Svg rootElement = null;
    private String title = "";
    private String desc = "";
    private float renderDPI = 96.0f;
    private CSSParser.Ruleset cssRules = new CSSParser.Ruleset();
    private Map<String, SvgElementBase> idToElementMap = new HashMap<String, SvgElementBase>();
    static final long SPECIFIED_FILL = 1L;
    static final long SPECIFIED_FILL_RULE = 2L;
    static final long SPECIFIED_FILL_OPACITY = 4L;
    static final long SPECIFIED_STROKE = 8L;
    static final long SPECIFIED_STROKE_OPACITY = 16L;
    static final long SPECIFIED_STROKE_WIDTH = 32L;
    static final long SPECIFIED_STROKE_LINECAP = 64L;
    static final long SPECIFIED_STROKE_LINEJOIN = 128L;
    static final long SPECIFIED_STROKE_MITERLIMIT = 256L;
    static final long SPECIFIED_STROKE_DASHARRAY = 512L;
    static final long SPECIFIED_STROKE_DASHOFFSET = 1024L;
    static final long SPECIFIED_OPACITY = 2048L;
    static final long SPECIFIED_COLOR = 4096L;
    static final long SPECIFIED_FONT_FAMILY = 8192L;
    static final long SPECIFIED_FONT_SIZE = 16384L;
    static final long SPECIFIED_FONT_WEIGHT = 32768L;
    static final long SPECIFIED_FONT_STYLE = 65536L;
    static final long SPECIFIED_TEXT_DECORATION = 131072L;
    static final long SPECIFIED_TEXT_ANCHOR = 262144L;
    static final long SPECIFIED_OVERFLOW = 524288L;
    static final long SPECIFIED_CLIP = 0x100000L;
    static final long SPECIFIED_MARKER_START = 0x200000L;
    static final long SPECIFIED_MARKER_MID = 0x400000L;
    static final long SPECIFIED_MARKER_END = 0x800000L;
    static final long SPECIFIED_DISPLAY = 0x1000000L;
    static final long SPECIFIED_VISIBILITY = 0x2000000L;
    static final long SPECIFIED_STOP_COLOR = 0x4000000L;
    static final long SPECIFIED_STOP_OPACITY = 0x8000000L;
    static final long SPECIFIED_CLIP_PATH = 0x10000000L;
    static final long SPECIFIED_CLIP_RULE = 0x20000000L;
    static final long SPECIFIED_MASK = 0x40000000L;
    static final long SPECIFIED_SOLID_COLOR = 0x80000000L;
    static final long SPECIFIED_SOLID_OPACITY = 0x100000000L;
    static final long SPECIFIED_VIEWPORT_FILL = 0x200000000L;
    static final long SPECIFIED_VIEWPORT_FILL_OPACITY = 0x400000000L;
    static final long SPECIFIED_VECTOR_EFFECT = 0x800000000L;
    static final long SPECIFIED_DIRECTION = 0x1000000000L;
    static final long SPECIFIED_IMAGE_RENDERING = 0x2000000000L;
    private static final long SPECIFIED_ALL = -1L;

    SVG() {
    }

    public static SVG getFromInputStream(InputStream inputStream) throws SVGParseException {
        return new SVGParser().parse(inputStream, enableInternalEntities);
    }

    public static SVG getFromString(String string2) throws SVGParseException {
        return new SVGParser().parse(new ByteArrayInputStream(string2.getBytes()), enableInternalEntities);
    }

    public static SVG getFromResource(Context context, int n2) throws SVGParseException {
        return SVG.getFromResource(context.getResources(), n2);
    }

    public static SVG getFromResource(Resources object, int n2) throws SVGParseException {
        SVG sVG;
        SVGParser sVGParser = new SVGParser();
        object = object.openRawResource(n2);
        try {
            sVG = sVGParser.parse((InputStream)object, enableInternalEntities);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)object).close();
        }
        catch (IOException iOException) {}
        return sVG;
    }

    public static SVG getFromAsset(AssetManager object, String object2) throws SVGParseException, IOException {
        SVGParser sVGParser = new SVGParser();
        object = object.open((String)object2);
        try {
            object2 = sVGParser.parse((InputStream)object, enableInternalEntities);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)object).close();
        }
        catch (IOException iOException) {}
        return object2;
    }

    public static void setInternalEntitiesEnabled(boolean bl2) {
        enableInternalEntities = bl2;
    }

    public static boolean isInternalEntitiesEnabled() {
        return enableInternalEntities;
    }

    public static void registerExternalFileResolver(SVGExternalFileResolver sVGExternalFileResolver) {
        externalFileResolver = sVGExternalFileResolver;
    }

    public static void deregisterExternalFileResolver() {
        externalFileResolver = null;
    }

    public void setRenderDPI(float f2) {
        this.renderDPI = f2;
    }

    public float getRenderDPI() {
        return this.renderDPI;
    }

    public Picture renderToPicture() {
        return this.renderToPicture(null);
    }

    public Picture renderToPicture(int n2, int n3) {
        return this.renderToPicture(n2, n3, null);
    }

    public Picture renderToPicture(RenderOptions renderOptions) {
        Box box;
        Box box2 = box = renderOptions != null && renderOptions.hasViewBox() ? renderOptions.viewBox : this.rootElement.viewBox;
        if (renderOptions != null && renderOptions.hasViewPort()) {
            float f2 = renderOptions.viewPort.maxX();
            float f3 = renderOptions.viewPort.maxY();
            return this.renderToPicture((int)Math.ceil(f2), (int)Math.ceil(f3), renderOptions);
        }
        if (this.rootElement.width != null && this.rootElement.width.unit != Unit.percent && this.rootElement.height != null && this.rootElement.height.unit != Unit.percent) {
            float f4 = this.rootElement.width.floatValue(this.renderDPI);
            float f5 = this.rootElement.height.floatValue(this.renderDPI);
            return this.renderToPicture((int)Math.ceil(f4), (int)Math.ceil(f5), renderOptions);
        }
        if (this.rootElement.width != null && box != null) {
            float f6 = this.rootElement.width.floatValue(this.renderDPI);
            float f7 = f6 * box.height / box.width;
            return this.renderToPicture((int)Math.ceil(f6), (int)Math.ceil(f7), renderOptions);
        }
        if (this.rootElement.height != null && box != null) {
            float f8 = this.rootElement.height.floatValue(this.renderDPI);
            float f9 = f8 * box.width / box.height;
            return this.renderToPicture((int)Math.ceil(f9), (int)Math.ceil(f8), renderOptions);
        }
        return this.renderToPicture(512, 512, renderOptions);
    }

    public Picture renderToPicture(int n2, int n3, RenderOptions renderOptions) {
        Picture picture = new Picture();
        Canvas canvas = picture.beginRecording(n2, n3);
        if (renderOptions == null || renderOptions.viewPort == null) {
            renderOptions = renderOptions == null ? new RenderOptions() : new RenderOptions(renderOptions);
            renderOptions.viewPort(0.0f, 0.0f, n2, n3);
        }
        new SVGAndroidRenderer(canvas, this.renderDPI).renderDocument(this, renderOptions);
        picture.endRecording();
        return picture;
    }

    public Picture renderViewToPicture(String string2, int n2, int n3) {
        RenderOptions renderOptions = new RenderOptions();
        renderOptions.view(string2).viewPort(0.0f, 0.0f, n2, n3);
        string2 = new Picture();
        Canvas canvas = string2.beginRecording(n2, n3);
        new SVGAndroidRenderer(canvas, this.renderDPI).renderDocument(this, renderOptions);
        string2.endRecording();
        return string2;
    }

    public void renderToCanvas(Canvas canvas) {
        this.renderToCanvas(canvas, (RenderOptions)null);
    }

    public void renderToCanvas(Canvas canvas, RectF rectF) {
        RenderOptions renderOptions = new RenderOptions();
        if (rectF != null) {
            renderOptions.viewPort(rectF.left, rectF.top, rectF.width(), rectF.height());
        } else {
            renderOptions.viewPort(0.0f, 0.0f, canvas.getWidth(), canvas.getHeight());
        }
        new SVGAndroidRenderer(canvas, this.renderDPI).renderDocument(this, renderOptions);
    }

    public void renderToCanvas(Canvas canvas, RenderOptions renderOptions) {
        if (renderOptions == null) {
            renderOptions = new RenderOptions();
        }
        if (!renderOptions.hasViewPort()) {
            renderOptions.viewPort(0.0f, 0.0f, canvas.getWidth(), canvas.getHeight());
        }
        new SVGAndroidRenderer(canvas, this.renderDPI).renderDocument(this, renderOptions);
    }

    public void renderViewToCanvas(String string2, Canvas canvas) {
        this.renderToCanvas(canvas, RenderOptions.create().view(string2));
    }

    public void renderViewToCanvas(String object, Canvas canvas, RectF rectF) {
        object = RenderOptions.create().view((String)object);
        if (rectF != null) {
            ((RenderOptions)object).viewPort(rectF.left, rectF.top, rectF.width(), rectF.height());
        }
        this.renderToCanvas(canvas, (RenderOptions)object);
    }

    public static String getVersion() {
        return VERSION;
    }

    public String getDocumentTitle() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.title;
    }

    public String getDocumentDescription() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.desc;
    }

    public String getDocumentSVGVersion() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        return this.rootElement.version;
    }

    public Set<String> getViewList() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        Object object = this.getElementsByTagName("view");
        HashSet<String> hashSet = new HashSet<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            View view = (View)((SvgObject)object.next());
            if (view.id == null) continue;
            hashSet.add(view.id);
        }
        return hashSet;
    }

    public float getDocumentWidth() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        SVG sVG = this;
        return sVG.getDocumentDimensions((float)sVG.renderDPI).width;
    }

    public void setDocumentWidth(float f2) {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.width = new Length(f2);
    }

    public void setDocumentWidth(String string2) throws SVGParseException {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.width = SVGParser.parseLength(string2);
    }

    public float getDocumentHeight() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        SVG sVG = this;
        return sVG.getDocumentDimensions((float)sVG.renderDPI).height;
    }

    public void setDocumentHeight(float f2) {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.height = new Length(f2);
    }

    public void setDocumentHeight(String string2) throws SVGParseException {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.height = SVGParser.parseLength(string2);
    }

    public void setDocumentViewBox(float f2, float f3, float f4, float f5) {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.viewBox = new Box(f2, f3, f4, f5);
    }

    public RectF getDocumentViewBox() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        if (this.rootElement.viewBox == null) {
            return null;
        }
        return this.rootElement.viewBox.toRectF();
    }

    public void setDocumentPreserveAspectRatio(PreserveAspectRatio preserveAspectRatio) {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        this.rootElement.preserveAspectRatio = preserveAspectRatio;
    }

    public PreserveAspectRatio getDocumentPreserveAspectRatio() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        if (this.rootElement.preserveAspectRatio == null) {
            return null;
        }
        return this.rootElement.preserveAspectRatio;
    }

    public float getDocumentAspectRatio() {
        if (this.rootElement == null) {
            throw new IllegalArgumentException("SVG document is empty");
        }
        Length length = this.rootElement.width;
        Length length2 = this.rootElement.height;
        if (length != null && length2 != null && length.unit != Unit.percent && length2.unit != Unit.percent) {
            if (!length.isZero() && !length2.isZero()) {
                return length.floatValue(this.renderDPI) / length2.floatValue(this.renderDPI);
            }
            return -1.0f;
        }
        if (this.rootElement.viewBox != null && this.rootElement.viewBox.width != 0.0f && this.rootElement.viewBox.height != 0.0f) {
            return this.rootElement.viewBox.width / this.rootElement.viewBox.height;
        }
        return -1.0f;
    }

    Svg getRootElement() {
        return this.rootElement;
    }

    void setRootElement(Svg svg) {
        this.rootElement = svg;
    }

    SvgObject resolveIRI(String string2) {
        if (string2 == null) {
            return null;
        }
        if ((string2 = this.cssQuotedString(string2)).length() > 1 && string2.startsWith("#")) {
            return this.getElementById(string2.substring(1));
        }
        return null;
    }

    private String cssQuotedString(String string2) {
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1).replace("\\\"", "\"");
        } else if (string2.startsWith("'") && string2.endsWith("'")) {
            string2 = string2.substring(1, string2.length() - 1).replace("\\'", "'");
        }
        return string2.replace("\\\n", "").replace("\\A", "\n");
    }

    private Box getDocumentDimensions(float f2) {
        Length length = this.rootElement.width;
        Length length2 = this.rootElement.height;
        if (length != null && !length.isZero() && length.unit != Unit.percent && length.unit != Unit.em && length.unit != Unit.ex) {
            float f3 = length.floatValue(f2);
            if (length2 != null) {
                if (length2.isZero() || length2.unit == Unit.percent || length2.unit == Unit.em || length2.unit == Unit.ex) {
                    return new Box(-1.0f, -1.0f, -1.0f, -1.0f);
                }
                f2 = length2.floatValue(f2);
            } else {
                f2 = this.rootElement.viewBox != null ? f3 * this.rootElement.viewBox.height / this.rootElement.viewBox.width : f3;
            }
            return new Box(0.0f, 0.0f, f3, f2);
        }
        return new Box(-1.0f, -1.0f, -1.0f, -1.0f);
    }

    void addCSSRules(CSSParser.Ruleset ruleset) {
        this.cssRules.addAll(ruleset);
    }

    List<CSSParser.Rule> getCSSRules() {
        return this.cssRules.getRules();
    }

    boolean hasCSSRules() {
        return !this.cssRules.isEmpty();
    }

    void clearRenderCSSRules() {
        this.cssRules.removeFromSource(CSSParser.Source.RenderOptions);
    }

    void setTitle(String string2) {
        this.title = string2;
    }

    void setDesc(String string2) {
        this.desc = string2;
    }

    static SVGExternalFileResolver getFileResolver() {
        return externalFileResolver;
    }

    SvgElementBase getElementById(String string2) {
        if (string2 != null && string2.length() != 0) {
            if (string2.equals(this.rootElement.id)) {
                return this.rootElement;
            }
            if (this.idToElementMap.containsKey(string2)) {
                return this.idToElementMap.get(string2);
            }
            SVG sVG = this;
            SvgElementBase svgElementBase = sVG.getElementById(sVG.rootElement, string2);
            this.idToElementMap.put(string2, svgElementBase);
            return svgElementBase;
        }
        return null;
    }

    private SvgElementBase getElementById(SvgContainer object, String string2) {
        SvgElementBase svgObject2 = (SvgElementBase)((Object)object);
        if (string2.equals(svgObject2.id)) {
            return svgObject2;
        }
        for (SvgObject svgObject : object.getChildren()) {
            SvgElementBase svgElementBase;
            if (!(svgObject instanceof SvgElementBase)) continue;
            SvgElementBase svgElementBase2 = (SvgElementBase)svgObject;
            if (string2.equals(svgElementBase2.id)) {
                return svgElementBase2;
            }
            if (!(svgObject instanceof SvgContainer) || (svgElementBase = this.getElementById((SvgContainer)((Object)svgObject), string2)) == null) continue;
            return svgElementBase;
        }
        return null;
    }

    private List<SvgObject> getElementsByTagName(String string2) {
        ArrayList<SvgObject> arrayList = new ArrayList<SvgObject>();
        this.getElementsByTagName(arrayList, this.rootElement, string2);
        return arrayList;
    }

    private void getElementsByTagName(List<SvgObject> list, SvgObject object, String string2) {
        if (((SvgObject)object).getNodeName().equals(string2)) {
            list.add((SvgObject)object);
        }
        if (object instanceof SvgContainer) {
            for (SvgObject svgObject : ((SvgContainer)object).getChildren()) {
                this.getElementsByTagName(list, svgObject, string2);
            }
        }
    }

    static enum Unit {
        px,
        em,
        ex,
        in,
        cm,
        mm,
        pt,
        pc,
        percent;

    }

    static enum GradientSpread {
        pad,
        reflect,
        repeat;

    }

    static class Box {
        float minX;
        float minY;
        float width;
        float height;

        Box(float f2, float f3, float f4, float f5) {
            this.minX = f2;
            this.minY = f3;
            this.width = f4;
            this.height = f5;
        }

        Box(Box box) {
            this.minX = box.minX;
            this.minY = box.minY;
            this.width = box.width;
            this.height = box.height;
        }

        static Box fromLimits(float f2, float f3, float f4, float f5) {
            return new Box(f2, f3, f4 - f2, f5 - f3);
        }

        RectF toRectF() {
            return new RectF(this.minX, this.minY, this.maxX(), this.maxY());
        }

        float maxX() {
            return this.minX + this.width;
        }

        float maxY() {
            return this.minY + this.height;
        }

        void union(Box box) {
            if (box.minX < this.minX) {
                this.minX = box.minX;
            }
            if (box.minY < this.minY) {
                this.minY = box.minY;
            }
            if (box.maxX() > this.maxX()) {
                this.width = box.maxX() - this.minX;
            }
            if (box.maxY() > this.maxY()) {
                this.height = box.maxY() - this.minY;
            }
        }

        public String toString() {
            return "[" + this.minX + " " + this.minY + " " + this.width + " " + this.height + "]";
        }
    }

    static class Style
    implements Cloneable {
        long specifiedFlags = 0L;
        SvgPaint fill;
        FillRule fillRule;
        Float fillOpacity;
        SvgPaint stroke;
        Float strokeOpacity;
        Length strokeWidth;
        LineCap strokeLineCap;
        LineJoin strokeLineJoin;
        Float strokeMiterLimit;
        Length[] strokeDashArray;
        Length strokeDashOffset;
        Float opacity;
        Colour color;
        List<String> fontFamily;
        Length fontSize;
        Integer fontWeight;
        FontStyle fontStyle;
        TextDecoration textDecoration;
        TextDirection direction;
        TextAnchor textAnchor;
        Boolean overflow;
        CSSClipRect clip;
        String markerStart;
        String markerMid;
        String markerEnd;
        Boolean display;
        Boolean visibility;
        SvgPaint stopColor;
        Float stopOpacity;
        String clipPath;
        FillRule clipRule;
        String mask;
        SvgPaint solidColor;
        Float solidOpacity;
        SvgPaint viewportFill;
        Float viewportFillOpacity;
        VectorEffect vectorEffect;
        RenderQuality imageRendering;
        static final int FONT_WEIGHT_NORMAL = 400;
        static final int FONT_WEIGHT_BOLD = 700;
        static final int FONT_WEIGHT_LIGHTER = -1;
        static final int FONT_WEIGHT_BOLDER = 1;

        Style() {
        }

        static Style getDefaultStyle() {
            Style style2 = new Style();
            new Style().specifiedFlags = -1L;
            style2.fill = Colour.BLACK;
            style2.fillRule = FillRule.NonZero;
            style2.fillOpacity = Float.valueOf(1.0f);
            style2.stroke = null;
            style2.strokeOpacity = Float.valueOf(1.0f);
            style2.strokeWidth = new Length(1.0f);
            style2.strokeLineCap = LineCap.Butt;
            style2.strokeLineJoin = LineJoin.Miter;
            style2.strokeMiterLimit = Float.valueOf(4.0f);
            style2.strokeDashArray = null;
            style2.strokeDashOffset = new Length(0.0f);
            style2.opacity = Float.valueOf(1.0f);
            style2.color = Colour.BLACK;
            style2.fontFamily = null;
            style2.fontSize = new Length(12.0f, Unit.pt);
            style2.fontWeight = 400;
            style2.fontStyle = FontStyle.Normal;
            style2.textDecoration = TextDecoration.None;
            style2.direction = TextDirection.LTR;
            style2.textAnchor = TextAnchor.Start;
            style2.overflow = Boolean.TRUE;
            style2.clip = null;
            style2.markerStart = null;
            style2.markerMid = null;
            style2.markerEnd = null;
            style2.display = Boolean.TRUE;
            style2.visibility = Boolean.TRUE;
            style2.stopColor = Colour.BLACK;
            style2.stopOpacity = Float.valueOf(1.0f);
            style2.clipPath = null;
            style2.clipRule = FillRule.NonZero;
            style2.mask = null;
            style2.solidColor = null;
            style2.solidOpacity = Float.valueOf(1.0f);
            style2.viewportFill = null;
            style2.viewportFillOpacity = Float.valueOf(1.0f);
            style2.vectorEffect = VectorEffect.None;
            style2.imageRendering = RenderQuality.auto;
            return style2;
        }

        void resetNonInheritingProperties(boolean bl2) {
            this.display = Boolean.TRUE;
            this.overflow = bl2 ? Boolean.TRUE : Boolean.FALSE;
            this.clip = null;
            this.clipPath = null;
            this.opacity = Float.valueOf(1.0f);
            this.stopColor = Colour.BLACK;
            this.stopOpacity = Float.valueOf(1.0f);
            this.mask = null;
            this.solidColor = null;
            this.solidOpacity = Float.valueOf(1.0f);
            this.viewportFill = null;
            this.viewportFillOpacity = Float.valueOf(1.0f);
            this.vectorEffect = VectorEffect.None;
        }

        protected Object clone() throws CloneNotSupportedException {
            Style style2 = (Style)super.clone();
            if (this.strokeDashArray != null) {
                style2.strokeDashArray = (Length[])this.strokeDashArray.clone();
            }
            return style2;
        }

        public static enum FillRule {
            NonZero,
            EvenOdd;

        }

        public static enum LineCap {
            Butt,
            Round,
            Square;

        }

        public static enum LineJoin {
            Miter,
            Round,
            Bevel;

        }

        public static enum FontStyle {
            Normal,
            Italic,
            Oblique;

        }

        public static enum TextAnchor {
            Start,
            Middle,
            End;

        }

        public static enum TextDecoration {
            None,
            Underline,
            Overline,
            LineThrough,
            Blink;

        }

        public static enum TextDirection {
            LTR,
            RTL;

        }

        public static enum VectorEffect {
            None,
            NonScalingStroke;

        }

        public static enum RenderQuality {
            auto,
            optimizeQuality,
            optimizeSpeed;

        }
    }

    static abstract class SvgPaint
    implements Cloneable {
        SvgPaint() {
        }
    }

    static class Colour
    extends SvgPaint {
        int colour;
        static final Colour BLACK = new Colour(-16777216);
        static final Colour TRANSPARENT = new Colour(0);

        Colour(int n2) {
            this.colour = n2;
        }

        public String toString() {
            return String.format("#%08x", this.colour);
        }
    }

    static class CurrentColor
    extends SvgPaint {
        private static CurrentColor instance = new CurrentColor();

        private CurrentColor() {
        }

        static CurrentColor getInstance() {
            return instance;
        }
    }

    static class PaintReference
    extends SvgPaint {
        String href;
        SvgPaint fallback;

        PaintReference(String string2, SvgPaint svgPaint) {
            this.href = string2;
            this.fallback = svgPaint;
        }

        public String toString() {
            return this.href + " " + this.fallback;
        }
    }

    static class Length
    implements Cloneable {
        float value;
        Unit unit;

        Length(float f2, Unit unit) {
            this.value = f2;
            this.unit = unit;
        }

        Length(float f2) {
            this.value = f2;
            this.unit = Unit.px;
        }

        float floatValue() {
            return this.value;
        }

        float floatValueX(SVGAndroidRenderer object) {
            switch (this.unit) {
                case px: {
                    return this.value;
                }
                case em: {
                    return this.value * ((SVGAndroidRenderer)object).getCurrentFontSize();
                }
                case ex: {
                    return this.value * ((SVGAndroidRenderer)object).getCurrentFontXHeight();
                }
                case in: {
                    return this.value * ((SVGAndroidRenderer)object).getDPI();
                }
                case cm: {
                    return this.value * ((SVGAndroidRenderer)object).getDPI() / 2.54f;
                }
                case mm: {
                    return this.value * ((SVGAndroidRenderer)object).getDPI() / 25.4f;
                }
                case pt: {
                    return this.value * ((SVGAndroidRenderer)object).getDPI() / 72.0f;
                }
                case pc: {
                    return this.value * ((SVGAndroidRenderer)object).getDPI() / 6.0f;
                }
                case percent: {
                    object = ((SVGAndroidRenderer)object).getCurrentViewPortInUserUnits();
                    if (object == null) {
                        return this.value;
                    }
                    return this.value * ((Box)object).width / 100.0f;
                }
            }
            return this.value;
        }

        float floatValueY(SVGAndroidRenderer object) {
            if (this.unit == Unit.percent) {
                if ((object = ((SVGAndroidRenderer)object).getCurrentViewPortInUserUnits()) == null) {
                    return this.value;
                }
                return this.value * ((Box)object).height / 100.0f;
            }
            return this.floatValueX((SVGAndroidRenderer)object);
        }

        float floatValue(SVGAndroidRenderer object) {
            if (this.unit == Unit.percent) {
                if ((object = ((SVGAndroidRenderer)object).getCurrentViewPortInUserUnits()) == null) {
                    return this.value;
                }
                float f2 = ((Box)object).width;
                float f3 = ((Box)object).height;
                if (f2 == f3) {
                    return this.value * f2 / 100.0f;
                }
                float f4 = f2;
                float f5 = f3;
                f3 = (float)(Math.sqrt(f4 * f4 + f5 * f5) / 1.414213562373095);
                return this.value * f3 / 100.0f;
            }
            return this.floatValueX((SVGAndroidRenderer)object);
        }

        float floatValue(SVGAndroidRenderer sVGAndroidRenderer, float f2) {
            if (this.unit == Unit.percent) {
                return this.value * f2 / 100.0f;
            }
            return this.floatValueX(sVGAndroidRenderer);
        }

        float floatValue(float f2) {
            switch (this.unit) {
                case px: {
                    return this.value;
                }
                default: {
                    return this.value;
                }
                case in: {
                    return this.value * f2;
                }
                case cm: {
                    return this.value * f2 / 2.54f;
                }
                case mm: {
                    return this.value * f2 / 25.4f;
                }
                case pt: {
                    return this.value * f2 / 72.0f;
                }
                case pc: 
            }
            return this.value * f2 / 6.0f;
        }

        boolean isZero() {
            return this.value == 0.0f;
        }

        boolean isNegative() {
            return this.value < 0.0f;
        }

        public String toString() {
            return String.valueOf(this.value) + (Object)((Object)this.unit);
        }
    }

    static class CSSClipRect {
        Length top;
        Length right;
        Length bottom;
        Length left;

        CSSClipRect(Length length, Length length2, Length length3, Length length4) {
            this.top = length;
            this.right = length2;
            this.bottom = length3;
            this.left = length4;
        }
    }

    static class SvgObject {
        SVG document;
        SvgContainer parent;

        SvgObject() {
        }

        String getNodeName() {
            return "";
        }
    }

    static abstract class SvgElementBase
    extends SvgObject {
        String id = null;
        Boolean spacePreserve = null;
        Style baseStyle = null;
        Style style = null;
        List<String> classNames = null;

        SvgElementBase() {
        }

        public String toString() {
            return this.getNodeName();
        }
    }

    static abstract class SvgElement
    extends SvgElementBase {
        Box boundingBox = null;

        SvgElement() {
        }
    }

    static interface SvgConditional {
        public void setRequiredFeatures(Set<String> var1);

        public Set<String> getRequiredFeatures();

        public void setRequiredExtensions(String var1);

        public String getRequiredExtensions();

        public void setSystemLanguage(Set<String> var1);

        public Set<String> getSystemLanguage();

        public void setRequiredFormats(Set<String> var1);

        public Set<String> getRequiredFormats();

        public void setRequiredFonts(Set<String> var1);

        public Set<String> getRequiredFonts();
    }

    static abstract class SvgConditionalElement
    extends SvgElement
    implements SvgConditional {
        Set<String> requiredFeatures = null;
        String requiredExtensions = null;
        Set<String> systemLanguage = null;
        Set<String> requiredFormats = null;
        Set<String> requiredFonts = null;

        SvgConditionalElement() {
        }

        @Override
        public void setRequiredFeatures(Set<String> set) {
            this.requiredFeatures = set;
        }

        @Override
        public Set<String> getRequiredFeatures() {
            return this.requiredFeatures;
        }

        @Override
        public void setRequiredExtensions(String string2) {
            this.requiredExtensions = string2;
        }

        @Override
        public String getRequiredExtensions() {
            return this.requiredExtensions;
        }

        @Override
        public void setSystemLanguage(Set<String> set) {
            this.systemLanguage = set;
        }

        @Override
        public Set<String> getSystemLanguage() {
            return this.systemLanguage;
        }

        @Override
        public void setRequiredFormats(Set<String> set) {
            this.requiredFormats = set;
        }

        @Override
        public Set<String> getRequiredFormats() {
            return this.requiredFormats;
        }

        @Override
        public void setRequiredFonts(Set<String> set) {
            this.requiredFonts = set;
        }

        @Override
        public Set<String> getRequiredFonts() {
            return this.requiredFonts;
        }
    }

    static interface SvgContainer {
        public List<SvgObject> getChildren();

        public void addChild(SvgObject var1) throws SVGParseException;
    }

    static abstract class SvgConditionalContainer
    extends SvgElement
    implements SvgConditional,
    SvgContainer {
        List<SvgObject> children = new ArrayList<SvgObject>();
        Set<String> requiredFeatures = null;
        String requiredExtensions = null;
        Set<String> systemLanguage = null;
        Set<String> requiredFormats = null;
        Set<String> requiredFonts = null;

        SvgConditionalContainer() {
        }

        @Override
        public List<SvgObject> getChildren() {
            return this.children;
        }

        @Override
        public void addChild(SvgObject svgObject) throws SVGParseException {
            this.children.add(svgObject);
        }

        @Override
        public void setRequiredFeatures(Set<String> set) {
            this.requiredFeatures = set;
        }

        @Override
        public Set<String> getRequiredFeatures() {
            return this.requiredFeatures;
        }

        @Override
        public void setRequiredExtensions(String string2) {
            this.requiredExtensions = string2;
        }

        @Override
        public String getRequiredExtensions() {
            return this.requiredExtensions;
        }

        @Override
        public void setSystemLanguage(Set<String> set) {
            this.systemLanguage = set;
        }

        @Override
        public Set<String> getSystemLanguage() {
            return null;
        }

        @Override
        public void setRequiredFormats(Set<String> set) {
            this.requiredFormats = set;
        }

        @Override
        public Set<String> getRequiredFormats() {
            return this.requiredFormats;
        }

        @Override
        public void setRequiredFonts(Set<String> set) {
            this.requiredFonts = set;
        }

        @Override
        public Set<String> getRequiredFonts() {
            return this.requiredFonts;
        }
    }

    static interface HasTransform {
        public void setTransform(Matrix var1);
    }

    static abstract class SvgPreserveAspectRatioContainer
    extends SvgConditionalContainer {
        PreserveAspectRatio preserveAspectRatio = null;

        SvgPreserveAspectRatioContainer() {
        }
    }

    static abstract class SvgViewBoxContainer
    extends SvgPreserveAspectRatioContainer {
        Box viewBox;

        SvgViewBoxContainer() {
        }
    }

    static class Svg
    extends SvgViewBoxContainer {
        Length x;
        Length y;
        Length width;
        Length height;
        public String version;

        Svg() {
        }

        @Override
        String getNodeName() {
            return "svg";
        }
    }

    static class Group
    extends SvgConditionalContainer
    implements HasTransform {
        Matrix transform;

        Group() {
        }

        @Override
        public void setTransform(Matrix matrix) {
            this.transform = matrix;
        }

        @Override
        String getNodeName() {
            return "group";
        }
    }

    static interface NotDirectlyRendered {
    }

    static class Defs
    extends Group
    implements NotDirectlyRendered {
        Defs() {
        }

        @Override
        String getNodeName() {
            return "defs";
        }
    }

    static abstract class GraphicsElement
    extends SvgConditionalElement
    implements HasTransform {
        Matrix transform;

        GraphicsElement() {
        }

        @Override
        public void setTransform(Matrix matrix) {
            this.transform = matrix;
        }
    }

    static class Use
    extends Group {
        String href;
        Length x;
        Length y;
        Length width;
        Length height;

        Use() {
        }

        @Override
        String getNodeName() {
            return "use";
        }
    }

    static class Path
    extends GraphicsElement {
        PathDefinition d;
        Float pathLength;

        Path() {
        }

        @Override
        String getNodeName() {
            return "path";
        }
    }

    static class Rect
    extends GraphicsElement {
        Length x;
        Length y;
        Length width;
        Length height;
        Length rx;
        Length ry;

        Rect() {
        }

        @Override
        String getNodeName() {
            return "rect";
        }
    }

    static class Circle
    extends GraphicsElement {
        Length cx;
        Length cy;
        Length r;

        Circle() {
        }

        @Override
        String getNodeName() {
            return "circle";
        }
    }

    static class Ellipse
    extends GraphicsElement {
        Length cx;
        Length cy;
        Length rx;
        Length ry;

        Ellipse() {
        }

        @Override
        String getNodeName() {
            return "ellipse";
        }
    }

    static class Line
    extends GraphicsElement {
        Length x1;
        Length y1;
        Length x2;
        Length y2;

        Line() {
        }

        @Override
        String getNodeName() {
            return "line";
        }
    }

    static class PolyLine
    extends GraphicsElement {
        float[] points;

        PolyLine() {
        }

        @Override
        String getNodeName() {
            return "polyline";
        }
    }

    static class Polygon
    extends PolyLine {
        Polygon() {
        }

        @Override
        String getNodeName() {
            return "polygon";
        }
    }

    static interface TextRoot {
    }

    static interface TextChild {
        public void setTextRoot(TextRoot var1);

        public TextRoot getTextRoot();
    }

    static abstract class TextContainer
    extends SvgConditionalContainer {
        TextContainer() {
        }

        @Override
        public void addChild(SvgObject svgObject) throws SVGParseException {
            if (svgObject instanceof TextChild) {
                this.children.add(svgObject);
                return;
            }
            throw new SVGParseException("Text content elements cannot contain " + svgObject + " elements.");
        }
    }

    static abstract class TextPositionedContainer
    extends TextContainer {
        List<Length> x;
        List<Length> y;
        List<Length> dx;
        List<Length> dy;

        TextPositionedContainer() {
        }
    }

    static class Text
    extends TextPositionedContainer
    implements HasTransform,
    TextRoot {
        Matrix transform;

        Text() {
        }

        @Override
        public void setTransform(Matrix matrix) {
            this.transform = matrix;
        }

        @Override
        String getNodeName() {
            return "text";
        }
    }

    static class TSpan
    extends TextPositionedContainer
    implements TextChild {
        private TextRoot textRoot;

        TSpan() {
        }

        @Override
        public void setTextRoot(TextRoot textRoot) {
            this.textRoot = textRoot;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }

        @Override
        String getNodeName() {
            return "tspan";
        }
    }

    static class TextSequence
    extends SvgObject
    implements TextChild {
        String text;
        private TextRoot textRoot;

        TextSequence(String string2) {
            this.text = string2;
        }

        public String toString() {
            return "TextChild: '" + this.text + "'";
        }

        @Override
        public void setTextRoot(TextRoot textRoot) {
            this.textRoot = textRoot;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }
    }

    static class TRef
    extends TextContainer
    implements TextChild {
        String href;
        private TextRoot textRoot;

        TRef() {
        }

        @Override
        public void setTextRoot(TextRoot textRoot) {
            this.textRoot = textRoot;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }

        @Override
        String getNodeName() {
            return "tref";
        }
    }

    static class TextPath
    extends TextContainer
    implements TextChild {
        String href;
        Length startOffset;
        private TextRoot textRoot;

        TextPath() {
        }

        @Override
        public void setTextRoot(TextRoot textRoot) {
            this.textRoot = textRoot;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }

        @Override
        String getNodeName() {
            return "textPath";
        }
    }

    static class Switch
    extends Group {
        Switch() {
        }

        @Override
        String getNodeName() {
            return "switch";
        }
    }

    static class Symbol
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        Symbol() {
        }

        @Override
        String getNodeName() {
            return "symbol";
        }
    }

    static class Marker
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        boolean markerUnitsAreUser;
        Length refX;
        Length refY;
        Length markerWidth;
        Length markerHeight;
        Float orient;

        Marker() {
        }

        @Override
        String getNodeName() {
            return "marker";
        }
    }

    static abstract class GradientElement
    extends SvgElementBase
    implements SvgContainer {
        List<SvgObject> children = new ArrayList<SvgObject>();
        Boolean gradientUnitsAreUser;
        Matrix gradientTransform;
        GradientSpread spreadMethod;
        String href;

        GradientElement() {
        }

        @Override
        public List<SvgObject> getChildren() {
            return this.children;
        }

        @Override
        public void addChild(SvgObject svgObject) throws SVGParseException {
            if (svgObject instanceof Stop) {
                this.children.add(svgObject);
                return;
            }
            throw new SVGParseException("Gradient elements cannot contain " + svgObject + " elements.");
        }
    }

    static class Stop
    extends SvgElementBase
    implements SvgContainer {
        Float offset;

        Stop() {
        }

        @Override
        public List<SvgObject> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public void addChild(SvgObject svgObject) {
        }

        @Override
        String getNodeName() {
            return "stop";
        }
    }

    static class SvgLinearGradient
    extends GradientElement {
        Length x1;
        Length y1;
        Length x2;
        Length y2;

        SvgLinearGradient() {
        }

        @Override
        String getNodeName() {
            return "linearGradient";
        }
    }

    static class SvgRadialGradient
    extends GradientElement {
        Length cx;
        Length cy;
        Length r;
        Length fx;
        Length fy;

        SvgRadialGradient() {
        }

        @Override
        String getNodeName() {
            return "radialGradient";
        }
    }

    static class ClipPath
    extends Group
    implements NotDirectlyRendered {
        Boolean clipPathUnitsAreUser;

        ClipPath() {
        }

        @Override
        String getNodeName() {
            return "clipPath";
        }
    }

    static class Pattern
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        Boolean patternUnitsAreUser;
        Boolean patternContentUnitsAreUser;
        Matrix patternTransform;
        Length x;
        Length y;
        Length width;
        Length height;
        String href;

        Pattern() {
        }

        @Override
        String getNodeName() {
            return "pattern";
        }
    }

    static class Image
    extends SvgPreserveAspectRatioContainer
    implements HasTransform {
        String href;
        Length x;
        Length y;
        Length width;
        Length height;
        Matrix transform;

        Image() {
        }

        @Override
        public void setTransform(Matrix matrix) {
            this.transform = matrix;
        }

        @Override
        String getNodeName() {
            return "image";
        }
    }

    static class View
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        static final String NODE_NAME = "view";

        View() {
        }

        @Override
        String getNodeName() {
            return NODE_NAME;
        }
    }

    static class Mask
    extends SvgConditionalContainer
    implements NotDirectlyRendered {
        Boolean maskUnitsAreUser;
        Boolean maskContentUnitsAreUser;
        Length x;
        Length y;
        Length width;
        Length height;

        Mask() {
        }

        @Override
        String getNodeName() {
            return "mask";
        }
    }

    static class SolidColor
    extends SvgElementBase
    implements SvgContainer {
        SolidColor() {
        }

        @Override
        public List<SvgObject> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public void addChild(SvgObject svgObject) {
        }

        @Override
        String getNodeName() {
            return "solidColor";
        }
    }

    static interface PathInterface {
        public void moveTo(float var1, float var2);

        public void lineTo(float var1, float var2);

        public void cubicTo(float var1, float var2, float var3, float var4, float var5, float var6);

        public void quadTo(float var1, float var2, float var3, float var4);

        public void arcTo(float var1, float var2, float var3, boolean var4, boolean var5, float var6, float var7);

        public void close();
    }

    static class PathDefinition
    implements PathInterface {
        private byte[] commands = new byte[8];
        private int commandsLength = 0;
        private float[] coords = new float[16];
        private int coordsLength = 0;
        private static final byte MOVETO = 0;
        private static final byte LINETO = 1;
        private static final byte CUBICTO = 2;
        private static final byte QUADTO = 3;
        private static final byte ARCTO = 4;
        private static final byte CLOSE = 8;

        PathDefinition() {
        }

        boolean isEmpty() {
            return this.commandsLength == 0;
        }

        private void addCommand(byte by2) {
            if (this.commandsLength == this.commands.length) {
                byte[] byArray = new byte[this.commands.length * 2];
                System.arraycopy(this.commands, 0, byArray, 0, this.commands.length);
                this.commands = byArray;
            }
            this.commands[this.commandsLength++] = by2;
        }

        private void coordsEnsure(int n2) {
            if (this.coords.length < this.coordsLength + n2) {
                float[] fArray = new float[this.coords.length * 2];
                System.arraycopy(this.coords, 0, fArray, 0, this.coords.length);
                this.coords = fArray;
            }
        }

        @Override
        public void moveTo(float f2, float f3) {
            this.addCommand((byte)0);
            this.coordsEnsure(2);
            this.coords[this.coordsLength++] = f2;
            this.coords[this.coordsLength++] = f3;
        }

        @Override
        public void lineTo(float f2, float f3) {
            this.addCommand((byte)1);
            this.coordsEnsure(2);
            this.coords[this.coordsLength++] = f2;
            this.coords[this.coordsLength++] = f3;
        }

        @Override
        public void cubicTo(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.addCommand((byte)2);
            this.coordsEnsure(6);
            this.coords[this.coordsLength++] = f2;
            this.coords[this.coordsLength++] = f3;
            this.coords[this.coordsLength++] = f4;
            this.coords[this.coordsLength++] = f5;
            this.coords[this.coordsLength++] = f6;
            this.coords[this.coordsLength++] = f7;
        }

        @Override
        public void quadTo(float f2, float f3, float f4, float f5) {
            this.addCommand((byte)3);
            this.coordsEnsure(4);
            this.coords[this.coordsLength++] = f2;
            this.coords[this.coordsLength++] = f3;
            this.coords[this.coordsLength++] = f4;
            this.coords[this.coordsLength++] = f5;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void arcTo(float f2, float f3, float f4, boolean bl2, boolean bl3, float f5, float f6) {
            void var7_8;
            void var6_7;
            void var5_6;
            int n2 = 4 | (bl2 ? 2 : 0) | (var5_6 != false ? 1 : 0);
            this.addCommand((byte)n2);
            this.coordsEnsure(5);
            this.coords[this.coordsLength++] = f2;
            this.coords[this.coordsLength++] = f3;
            this.coords[this.coordsLength++] = f4;
            this.coords[this.coordsLength++] = var6_7;
            this.coords[this.coordsLength++] = var7_8;
        }

        @Override
        public void close() {
            this.addCommand((byte)8);
        }

        void enumeratePath(PathInterface pathInterface) {
            int n2 = 0;
            block7: for (int i2 = 0; i2 < this.commandsLength; ++i2) {
                int n3 = this.commands[i2];
                switch (n3) {
                    case 0: {
                        pathInterface.moveTo(this.coords[n2++], this.coords[n2++]);
                        continue block7;
                    }
                    case 1: {
                        pathInterface.lineTo(this.coords[n2++], this.coords[n2++]);
                        continue block7;
                    }
                    case 2: {
                        pathInterface.cubicTo(this.coords[n2++], this.coords[n2++], this.coords[n2++], this.coords[n2++], this.coords[n2++], this.coords[n2++]);
                        continue block7;
                    }
                    case 3: {
                        pathInterface.quadTo(this.coords[n2++], this.coords[n2++], this.coords[n2++], this.coords[n2++]);
                        continue block7;
                    }
                    default: {
                        boolean bl2 = (n3 & 2) != 0;
                        n3 = (n3 & 1) != 0 ? 1 : 0;
                        pathInterface.arcTo(this.coords[n2++], this.coords[n2++], this.coords[n2++], bl2, n3 != 0, this.coords[n2++], this.coords[n2++]);
                        continue block7;
                    }
                    case 8: {
                        pathInterface.close();
                    }
                }
            }
        }
    }
}

