/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.svg;

import com.autonavi.ae.svg.SVGParseException;
import com.autonavi.ae.svg.SVGParser;

public class PreserveAspectRatio {
    private Alignment alignment;
    private Scale scale;
    public static final PreserveAspectRatio UNSCALED = new PreserveAspectRatio(null, null);
    public static final PreserveAspectRatio STRETCH = new PreserveAspectRatio(Alignment.none, null);
    public static final PreserveAspectRatio LETTERBOX = new PreserveAspectRatio(Alignment.xMidYMid, Scale.meet);
    public static final PreserveAspectRatio START = new PreserveAspectRatio(Alignment.xMinYMin, Scale.meet);
    public static final PreserveAspectRatio END = new PreserveAspectRatio(Alignment.xMaxYMax, Scale.meet);
    public static final PreserveAspectRatio TOP = new PreserveAspectRatio(Alignment.xMidYMin, Scale.meet);
    public static final PreserveAspectRatio BOTTOM = new PreserveAspectRatio(Alignment.xMidYMax, Scale.meet);
    public static final PreserveAspectRatio FULLSCREEN = new PreserveAspectRatio(Alignment.xMidYMid, Scale.slice);
    public static final PreserveAspectRatio FULLSCREEN_START = new PreserveAspectRatio(Alignment.xMinYMin, Scale.slice);

    PreserveAspectRatio(Alignment alignment, Scale scale) {
        this.alignment = alignment;
        this.scale = scale;
    }

    public static PreserveAspectRatio of(String string2) {
        try {
            return SVGParser.parsePreserveAspectRatio(string2);
        }
        catch (SVGParseException sVGParseException) {
            throw new IllegalArgumentException(sVGParseException.getMessage());
        }
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public Scale getScale() {
        return this.scale;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (PreserveAspectRatio)object;
        return this.alignment == ((PreserveAspectRatio)object).alignment && this.scale == ((PreserveAspectRatio)object).scale;
    }

    public String toString() {
        return (Object)((Object)this.alignment) + " " + (Object)((Object)this.scale);
    }

    public static enum Alignment {
        none,
        xMinYMin,
        xMidYMin,
        xMaxYMin,
        xMinYMid,
        xMidYMid,
        xMaxYMid,
        xMinYMax,
        xMidYMax,
        xMaxYMax;

    }

    public static enum Scale {
        meet,
        slice;

    }
}

