/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view.nightmode;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.amap.api.navi.R;
import com.amap.api.navi.view.nightmode.NightModeImageView;

public class NightModeRadioImageView
extends NightModeImageView {
    private ColorStateList dayModeTextColor;
    private ColorStateList nightModeTextColor;
    protected Drawable dayModeMarkBackGround;
    protected Drawable nightModeMarkBackGround;
    private CharSequence markText;
    private Paint mTextPaint;
    private Rect markRect;
    private float textSize = 15.0f;
    float wScale = 0.0f;
    float hScale = 0.0f;

    public NightModeRadioImageView(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public NightModeRadioImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet, 0);
    }

    public NightModeRadioImageView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context, attributeSet, n2);
    }

    private void init(Context context, AttributeSet attributeSet, int n2) {
        if (attributeSet != null) {
            context = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.NightMode, n2, 0);
            this.parseAttrs((TypedArray)context);
            context.recycle();
        }
    }

    protected void parseAttrs(TypedArray typedArray) {
        this.nightModeTextColor = typedArray.getColorStateList(2);
        this.dayModeTextColor = typedArray.getColorStateList(3);
        this.markText = typedArray.getText(6);
        if (this.markText != null) {
            this.dayModeMarkBackGround = typedArray.getDrawable(8);
            this.nightModeMarkBackGround = typedArray.getDrawable(7);
            this.textSize = TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.mTextPaint = new Paint(1);
            this.mTextPaint.setTextSize(this.textSize);
            this.mTextPaint.setStyle(Paint.Style.FILL);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.attrProcessor != null) {
            Object object = this.attrProcessor.c() ? this.attrProcessor.b() : this.attrProcessor.a();
            if (object != null) {
                object.draw(canvas);
            }
            if (this.markText != null && this.mTextPaint != null) {
                this.resetMarkBounds();
                object = this.getDrawableState();
                if (this.isSelected()) {
                    if (this.attrProcessor.c() && this.nightModeMarkBackGround != null) {
                        this.nightModeMarkBackGround.setBounds(this.markRect);
                        this.dayModeMarkBackGround.setState((int[])object);
                        this.nightModeMarkBackGround.draw(canvas);
                    } else if (this.dayModeMarkBackGround != null) {
                        this.dayModeMarkBackGround.setBounds(this.markRect);
                        this.dayModeMarkBackGround.setState((int[])object);
                        this.dayModeMarkBackGround.draw(canvas);
                    }
                }
                if (this.attrProcessor.c() && this.nightModeTextColor != null) {
                    int n2 = this.nightModeTextColor.getColorForState((int[])object, 0);
                    this.mTextPaint.setColor(n2);
                } else if (this.dayModeTextColor != null) {
                    int n3 = this.dayModeTextColor.getColorForState((int[])object, 0);
                    this.mTextPaint.setColor(n3);
                }
                Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
                float f2 = (fontMetrics.bottom - fontMetrics.top) / 2.0f - fontMetrics.bottom;
                f2 = (float)this.markRect.centerY() + f2;
                canvas.drawText(this.markText.toString(), (float)this.markRect.left + this.textSize / 2.0f, f2, this.mTextPaint);
            }
        }
    }

    private void resetMarkBounds() {
        float f2 = this.mTextPaint.measureText(this.markText, 0, this.markText.length());
        if (this.markRect == null) {
            this.markRect = new Rect();
        }
        this.markRect.left = (int)((float)this.getWidth() - f2 - this.textSize);
        this.markRect.top = (int)((float)this.getHeight() - this.textSize - this.textSize / 2.0f);
        this.markRect.right = this.getWidth();
        this.markRect.bottom = this.getHeight();
    }

    public void setSelect(boolean bl2) {
        this.setSelected(bl2);
        this.setFocusable(bl2);
    }

    public void setScale(float f2, float f3) {
        this.wScale = f2;
        this.hScale = f3;
        this.requestLayout();
    }

    @Override
    public void processNightMode(boolean bl2) {
        this.attrProcessor.a(bl2);
    }

    protected void onMeasure(int n2, int n3) {
        if (this.wScale > 0.0f && this.hScale > 0.0f) {
            n2 = View.MeasureSpec.getSize((int)n2);
            n3 = (int)((float)n2 * this.hScale / this.wScale);
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000));
            return;
        }
        super.onMeasure(n2, n3);
    }
}

