/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.RemoteException;
import android.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.TileOverlayOptions;
import com.autonavi.base.ae.gmap.bean.TileProviderInner;
import java.lang.ref.WeakReference;

public final class TileOverlay
extends BaseOverlay {
    protected TileOverlayOptions options;
    protected WeakReference<IGlOverlayLayer> glOverlayLayerRef;

    public TileOverlay(IGlOverlayLayer iGlOverlayLayer, TileOverlayOptions object, String string2) {
        super(string2);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = object;
        if (this.options != null && (object = this.options.getTileProviderInner()) != null) {
            ((TileProviderInner)object).init(iGlOverlayLayer, string2);
        }
    }

    public final void remove() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            return;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return;
        }
    }

    public final void clearTileCache() {
        this.callNativeFunction("clearTileCache", null);
    }

    public final String getId() {
        return this.overlayName;
    }

    public final void setZIndex(float f2) {
        this.options.zIndex(f2);
        this.updateOption();
    }

    public final float getZIndex() {
        return this.options.getZIndex();
    }

    public final void setVisible(boolean bl2) {
        this.options.visible(bl2);
        this.updateOption();
    }

    public final boolean isVisible() {
        return this.options.isVisible();
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof TileOverlay)) {
            return false;
        }
        try {
            if (this.options != null) {
                return this.options.equals(((TileOverlay)object).options) && this.overlayName.equals(((TileOverlay)object).overlayName);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public final int hashCode() {
        if (this.options != null) {
            int n2 = 31 + (this.overlayName == null ? 0 : this.overlayName.hashCode());
            return 31 * n2 + this.options.hashCode();
        }
        return super.hashCode();
    }

    protected final Object callNativeFunction(String string2, Object[] objectArray) {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                return iGlOverlayLayer.getNativeProperties(this.overlayName, string2, objectArray);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    protected final void updateOption() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.updateOption(this.overlayName, this.options);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }
}

