/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import android.graphics.Point;
import com.amap.api.col.3nl.am;
import com.amap.api.maps.CameraUpdate;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.VirtualEarthProjection;

public final class CameraUpdateFactory {
    private static final String CLASSNAME = "CameraUpdateFactory";

    public static CameraUpdate zoomIn() {
        return new CameraUpdate(am.a());
    }

    public static CameraUpdate zoomOut() {
        return new CameraUpdate(am.b());
    }

    public static CameraUpdate scrollBy(float f2, float f3) {
        return new CameraUpdate(am.a(f2, f3));
    }

    public static CameraUpdate zoomTo(float f2) {
        return new CameraUpdate(am.a(f2));
    }

    public static CameraUpdate zoomBy(float f2) {
        return new CameraUpdate(am.b(f2));
    }

    public static CameraUpdate zoomBy(float f2, Point point) {
        return new CameraUpdate(am.a(f2, point));
    }

    public static CameraUpdate newCameraPosition(CameraPosition cameraPosition) {
        if (cameraPosition == null) {
            return new CameraUpdate(am.c());
        }
        return new CameraUpdate(am.a(cameraPosition));
    }

    public static CameraUpdate newLatLng(LatLng latLng) {
        if (latLng == null) {
            return new CameraUpdate(am.c());
        }
        return new CameraUpdate(am.a(latLng));
    }

    public static CameraUpdate newLatLngZoom(LatLng latLng, float f2) {
        if (latLng == null) {
            return new CameraUpdate(am.c());
        }
        return new CameraUpdate(am.a(latLng, f2));
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n2) {
        if (latLngBounds == null) {
            return new CameraUpdate(am.c());
        }
        return new CameraUpdate(am.a(latLngBounds, n2));
    }

    public static CameraUpdate changeLatLng(LatLng latLng) {
        if (latLng == null) {
            return new CameraUpdate(am.c());
        }
        latLng = VirtualEarthProjection.latLongToPixels(latLng.latitude, latLng.longitude, 20);
        return new CameraUpdate(am.a((Point)latLng));
    }

    public static CameraUpdate changeBearing(float f2) {
        return new CameraUpdate(am.d(f2 % 360.0f));
    }

    public static CameraUpdate changeBearingGeoCenter(float f2, IPoint iPoint) {
        if (iPoint == null) {
            return new CameraUpdate(am.c());
        }
        return new CameraUpdate(am.b(f2 % 360.0f, new Point(iPoint.x, iPoint.y)));
    }

    public static CameraUpdate changeTilt(float f2) {
        return new CameraUpdate(am.c(f2));
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n2, int n3, int n4) {
        if (latLngBounds == null) {
            return new CameraUpdate(am.c());
        }
        return new CameraUpdate(am.a(latLngBounds, n2, n3, n4));
    }

    public static CameraUpdate newLatLngBoundsRect(LatLngBounds latLngBounds, int n2, int n3, int n4, int n5) {
        if (latLngBounds == null) {
            return new CameraUpdate(am.c());
        }
        return new CameraUpdate(am.a(latLngBounds, n2, n3, n4, n5));
    }
}

