/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.idst.nui;

import android.util.Log;
import com.alibaba.idst.nui.Constants;
import com.alibaba.idst.nui.INativeSpeechTranscriberCallback;

public class NuiSpeechTranscriber {
    private static final String TAG = "SpeechTranscriber_JAVA";
    private boolean mInit = false;
    private long speech_transcriber_handle = 0L;
    private static boolean soLoadedInThisClassLoader = false;
    private INativeSpeechTranscriberCallback callback;

    private synchronized int CheckHandle() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return -9999;
        }
        if (this.speech_transcriber_handle == 0L) {
            this.speech_transcriber_handle = this.native_get_new_speech_transcriber();
        }
        return 0;
    }

    public NuiSpeechTranscriber() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return;
        }
        this.speech_transcriber_handle = this.native_get_new_speech_transcriber();
        new StringBuilder("speech_transcriber_handle = ").append(this.speech_transcriber_handle);
    }

    protected void finalize() {
        this.release();
    }

    public synchronized int initialize(INativeSpeechTranscriberCallback iNativeSpeechTranscriberCallback, String string2, Constants.LogLevel logLevel, boolean bl2) {
        this.callback = iNativeSpeechTranscriberCallback;
        int n2 = this.CheckHandle();
        if (n2 != 0) {
            return n2;
        }
        NuiSpeechTranscriber nuiSpeechTranscriber = this;
        return nuiSpeechTranscriber.native_speech_transcriber_init(nuiSpeechTranscriber.speech_transcriber_handle, string2, Constants.LogLevel.toInt(logLevel), bl2);
    }

    public synchronized int setParams(String string2) {
        this.CheckHandle();
        NuiSpeechTranscriber nuiSpeechTranscriber = this;
        return nuiSpeechTranscriber.native_speech_transcriber_set_params(nuiSpeechTranscriber.speech_transcriber_handle, string2);
    }

    public synchronized int updateAudio(byte[] byArray, int n2) {
        this.CheckHandle();
        NuiSpeechTranscriber nuiSpeechTranscriber = this;
        return nuiSpeechTranscriber.native_speech_transcriber_update_audio(nuiSpeechTranscriber.speech_transcriber_handle, byArray, n2);
    }

    public synchronized int start(String string2) {
        this.CheckHandle();
        NuiSpeechTranscriber nuiSpeechTranscriber = this;
        return nuiSpeechTranscriber.native_speech_transcriber_start(nuiSpeechTranscriber.speech_transcriber_handle, string2);
    }

    public synchronized int stop() {
        this.CheckHandle();
        NuiSpeechTranscriber nuiSpeechTranscriber = this;
        return nuiSpeechTranscriber.native_speech_transcriber_stop(nuiSpeechTranscriber.speech_transcriber_handle);
    }

    public synchronized int cancel() {
        this.CheckHandle();
        NuiSpeechTranscriber nuiSpeechTranscriber = this;
        return nuiSpeechTranscriber.native_speech_transcriber_cancel(nuiSpeechTranscriber.speech_transcriber_handle);
    }

    public synchronized int release() {
        this.CheckHandle();
        NuiSpeechTranscriber nuiSpeechTranscriber = this;
        nuiSpeechTranscriber.native_speech_transcriber_release(nuiSpeechTranscriber.speech_transcriber_handle);
        this.speech_transcriber_handle = 0L;
        return 0;
    }

    private native long native_get_new_speech_transcriber();

    private native int native_speech_transcriber_init(long var1, String var3, int var4, boolean var5);

    private native int native_speech_transcriber_set_params(long var1, String var3);

    private native int native_speech_transcriber_update_audio(long var1, byte[] var3, int var4);

    private native int native_speech_transcriber_start(long var1, String var3);

    private native int native_speech_transcriber_stop(long var1);

    private native int native_speech_transcriber_cancel(long var1);

    private native int native_speech_transcriber_release(long var1);

    private native String native_speech_transcriber_get_version();

    private void onSpeechTranscriberEventCallback_(long l2, int n2, byte[] byArray, int n3) {
        if (l2 != this.speech_transcriber_handle) {
            new StringBuilder("transcriber event callback handle ").append(l2).append(" current obj handle ").append(this.speech_transcriber_handle);
            return;
        }
        new StringBuilder("event = ").append(n2).append(" result = ").append(byArray).append(" errcode = ").append(n3);
        if (this.callback != null) {
            this.callback.onSpeechTranscriberEventCallback(SpeechTranscriberEvent.values()[n2], new String(byArray), n3);
        }
    }

    private int onNuiNeedAudioData_(byte[] byArray, int n2) {
        if (this.callback != null) {
            return this.callback.onNuiNeedAudioData(byArray, n2);
        }
        return -1;
    }

    private void onNuiAudioStateChanged_(int n2) {
        if (this.callback != null) {
            this.callback.onNuiAudioStateChanged(Constants.AudioState.values()[n2]);
        }
    }

    private void onNuiRMSChanged_(float f2) {
        if (this.callback != null) {
            this.callback.onNuiAudioRMSChanged(f2);
        }
    }

    private void onEventTrackerCallback_(long l2, byte[] byArray) {
        if (l2 != this.speech_transcriber_handle) {
            new StringBuilder("event track callback handle ").append(l2).append(" current obj handle ").append(this.speech_transcriber_handle);
            return;
        }
        new StringBuilder("event tracker: ").append(new String(byArray));
        if (this.callback != null) {
            this.callback.onSpeechTranscriberEventTrackerCallback(new String(byArray));
        }
    }

    static {
        try {
            System.loadLibrary("speech_transcriber_jni");
            soLoadedInThisClassLoader = true;
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)"load library failed, ".concat(String.valueOf(throwable)));
        }
    }

    public static enum SpeechTranscriberEvent {
        ST_EVENT_SESSION_START,
        ST_EVENT_SENTENCE_START,
        ST_EVENT_SENTENCE_END,
        ST_EVENT_SENTENCE_SEMANTICS,
        ST_EVENT_TRANSCRIBER_COMPLETE,
        ST_EVENT_PARTIAL_ASR_RESULT,
        ST_EVENT_ASR_ERROR;

    }
}

