/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore;

import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.ImageOptions;
import com.amap.api.maps.model.LatLng;
import com.autonavi.base.ae.gmap.AMapAppRequestParam;
import com.autonavi.base.amap.mapcore.NativeBase;
import com.autonavi.base.amap.mapcore.annotations.ParameterIsClass;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@JBindingInclude
public class AMapNativeGlOverlayLayer
extends NativeBase {
    @JBindingInclude
    protected long mNative = 0L;
    @JBindingInclude
    private int mEngineId = 0;
    private NativeFunCallListener nativeFunCallListener;
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    @Override
    protected long getNative() {
        return this.mNative;
    }

    @JBindingInclude
    public void setEngineId(int n2) {
        this.mEngineId = n2;
    }

    @JBindingInclude
    public int getEngineId() {
        return this.mEngineId;
    }

    public void createOverlay(final String string2, final BaseOptions baseOptions) {
        if (!this.isReady()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AMapNativeGlOverlayLayer.this.createOverlay(string2, baseOptions);
                }
            };
            AMapNativeGlOverlayLayer aMapNativeGlOverlayLayer = this;
            aMapNativeGlOverlayLayer.storeUncallFunction(aMapNativeGlOverlayLayer, runnable, string2, "createOverlay", baseOptions);
            return;
        }
        this.callAllFunction();
        try {
            this.readWriteLock.readLock().lock();
            this.nativeCreateOverlay(string2, baseOptions);
            return;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @ParameterIsClass
    public void removeOverlay(final String string2) {
        if (!this.isReady()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AMapNativeGlOverlayLayer.this.removeOverlay(string2);
                }
            };
            AMapNativeGlOverlayLayer aMapNativeGlOverlayLayer = this;
            aMapNativeGlOverlayLayer.storeUncallFunction(aMapNativeGlOverlayLayer, runnable, string2, "removeOverlay", new Object[0]);
            return;
        }
        this.callAllFunction();
        try {
            this.readWriteLock.readLock().lock();
            this.nativeRemoveOverlay(string2);
            return;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @ParameterIsClass
    public void clear(final String ... stringArray) {
        if (!this.isReady()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AMapNativeGlOverlayLayer.this.clear(stringArray);
                }
            };
            String[] stringArray2 = (String[])stringArray.clone();
            AMapNativeGlOverlayLayer aMapNativeGlOverlayLayer = this;
            aMapNativeGlOverlayLayer.storeUncallFunctionArray(aMapNativeGlOverlayLayer, runnable, stringArray2, "clearOverlay", stringArray);
            return;
        }
        this.callAllFunction();
        try {
            this.readWriteLock.readLock().lock();
            this.nativeClear(stringArray);
            return;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @ParameterIsClass
    public void updateOptions(final String string2, final BaseOptions baseOptions) {
        try {
            if (!this.isReady()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        AMapNativeGlOverlayLayer.this.updateOptions(string2, baseOptions);
                        if (baseOptions != null) {
                            baseOptions.resetUpdateFlags();
                        }
                        AMapNativeGlOverlayLayer.this.setRunLowFrame(false);
                    }
                };
                AMapNativeGlOverlayLayer aMapNativeGlOverlayLayer = this;
                aMapNativeGlOverlayLayer.storeUncallFunction(aMapNativeGlOverlayLayer, runnable, string2, "updateOptions", baseOptions);
                return;
            }
            this.callAllFunction();
            try {
                this.readWriteLock.readLock().lock();
                this.nativeUpdateOptions(string2, baseOptions);
                if (baseOptions != null) {
                    baseOptions.resetUpdateFlags();
                }
                return;
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            new StringBuilder("AMapNativeGlOverlayLayer updateOptions error:").append(throwable2.getMessage());
            return;
        }
    }

    public String contain(LatLng latLng, int n2) {
        String string2 = "";
        if (this.isReady()) {
            this.callAllFunction();
            try {
                this.readWriteLock.readLock().lock();
                string2 = this.nativeContain(latLng, n2);
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        return string2;
    }

    public int getCurrentParticleNum(String string2) {
        int n2 = 0;
        if (this.isReady()) {
            this.callAllFunction();
            try {
                this.readWriteLock.readLock().lock();
                n2 = this.nativeGetCurrentParticleNum(string2);
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        return n2;
    }

    public Object getNativeProperties(String object, String string2, Object[] objectArray) {
        if (!this.isReady() || object == null) {
            Runnable runnable = new Runnable((String)object, string2, objectArray){
                final /* synthetic */ String val$overlayName;
                final /* synthetic */ String val$functionName;
                final /* synthetic */ Object[] val$args;
                {
                    this.val$overlayName = string2;
                    this.val$functionName = string3;
                    this.val$args = objectArray;
                }

                @Override
                public void run() {
                    AMapNativeGlOverlayLayer.this.getNativeProperties(this.val$overlayName, this.val$functionName, this.val$args);
                }
            };
            AMapNativeGlOverlayLayer aMapNativeGlOverlayLayer = this;
            aMapNativeGlOverlayLayer.storeUncallFunction(aMapNativeGlOverlayLayer, runnable, (String)object, string2, objectArray);
            return null;
        }
        try {
            this.readWriteLock.readLock().lock();
            if (this.destroy) {
                return null;
            }
            object = this.nativeGetNativeOverlayProperties((String)object, string2, objectArray);
            return object;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void render(int n2, int n3, boolean bl2) {
        this.callAllFunction();
        try {
            this.readWriteLock.readLock().lock();
            this.nativeRender(n2, n3, bl2);
            return;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void setNativeFunCallListener(NativeFunCallListener nativeFunCallListener) {
        this.nativeFunCallListener = nativeFunCallListener;
    }

    @Override
    public void destroy() {
        try {
            super.destroy();
            this.readWriteLock.writeLock().lock();
            this.nativeDestroy();
            return;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @JBindingInclude
    private void setRunLowFrame(boolean bl2) {
        if (this.nativeFunCallListener != null) {
            this.nativeFunCallListener.onSetRunLowFrame(bl2);
        }
    }

    @JBindingInclude
    private void redrawInfoWindow() {
        if (this.nativeFunCallListener != null) {
            this.nativeFunCallListener.onRedrawInfowindow();
        }
    }

    @JBindingInclude
    private BitmapDescriptor getInfoWindow(String string2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getInfoWindow(string2);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getInfoContents(String string2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getInfoContents(string2);
        }
        return null;
    }

    @JBindingInclude
    private long getInfoWindowUpdateOffsetTime(String string2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getInfoWindowUpdateOffsetTime(string2);
        }
        return 0L;
    }

    @JBindingInclude
    private BitmapDescriptor getInfoWindowClick(String string2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getInfoWindowClick(string2);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getOverturnInfoWindow(String string2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getOverturnInfoWindow(string2);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getOverturnInfoWindowClick(String string2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getOverturnInfoWindowClick(string2);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getBuildInImageData(int n2) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getBuildInImageData(n2);
        }
        return null;
    }

    @JBindingInclude
    private BitmapDescriptor getImagedData(ImageOptions imageOptions) {
        if (this.nativeFunCallListener != null) {
            return this.nativeFunCallListener.getCustomImageData(imageOptions);
        }
        return null;
    }

    @JBindingInclude
    private void getAMapResource(AMapAppRequestParam aMapAppRequestParam) {
        if (this.nativeFunCallListener == null) {
            return;
        }
        this.nativeFunCallListener.getAMapResource(aMapAppRequestParam);
    }

    public void setAMapEngine(long l2) {
        try {
            this.readWriteLock.readLock().lock();
            this.nativeSetAMapEngine(l2);
            return;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public void createNative() {
    }

    public void createNative(long l2) {
        try {
            if (this.mNative == 0L) {
                try {
                    if (this.readWriteLock != null) {
                        this.readWriteLock.writeLock().lock();
                    }
                    this.nativeCreate(l2);
                    if (this.readWriteLock != null) {
                        this.readWriteLock.writeLock().unlock();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    if (this.readWriteLock != null) {
                        this.readWriteLock.writeLock().unlock();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    if (this.readWriteLock != null) {
                        this.readWriteLock.writeLock().unlock();
                    }
                    throw throwable;
                }
            }
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Object[] objectArray = new Object[]{this.getClass().getSimpleName(), "execute error: ", unsatisfiedLinkError.toString()};
            return;
        }
    }

    @Override
    protected void finalizeNative() {
        this.nativeFinalize();
    }

    private native void nativeCreateOverlay(String var1, Object var2);

    private native void nativeRemoveOverlay(String var1);

    private native void nativeUpdateOptions(String var1, Object var2);

    private native void nativeRender(int var1, int var2, boolean var3);

    private native void nativeClear(String[] var1);

    private native String nativeContain(Object var1, int var2);

    private native int nativeGetCurrentParticleNum(String var1);

    private native Object nativeGetNativeOverlayProperties(String var1, String var2, Object[] var3);

    private native void nativeSetAMapEngine(long var1);

    private native void nativeDestroy();

    private native void nativeCreate(long var1);

    private native void nativeFinalize();

    public static interface NativeFunCallListener {
        public void onSetRunLowFrame(boolean var1);

        public void onRedrawInfowindow();

        public BitmapDescriptor getInfoWindow(String var1);

        public BitmapDescriptor getInfoContents(String var1);

        public long getInfoWindowUpdateOffsetTime(String var1);

        public BitmapDescriptor getInfoWindowClick(String var1);

        public BitmapDescriptor getOverturnInfoWindow(String var1);

        public BitmapDescriptor getOverturnInfoWindowClick(String var1);

        public BitmapDescriptor getBuildInImageData(int var1);

        public BitmapDescriptor getCustomImageData(ImageOptions var1);

        public void getAMapResource(AMapAppRequestParam var1);
    }
}

