/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.glanimation;

import android.os.SystemClock;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.base.ae.gmap.GLMapState;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimation;
import com.autonavi.base.ae.gmap.glanimation.AbstractAdglAnimationParam2V;

public class AdglMapAnimFlingP20
extends AbstractAdglAnimation {
    private float velocityScreenX;
    private float velocityScreenY;
    private AbstractAdglAnimationParam2V moveParam = null;
    private boolean hasCheckParams;
    private boolean needMove;

    public AdglMapAnimFlingP20(int n2) {
        this.reset();
        this.duration = n2;
    }

    public void reset() {
        if (this.moveParam != null) {
            this.moveParam.reset();
        }
        this.velocityScreenX = 0.0f;
        this.velocityScreenY = 0.0f;
        this.needMove = false;
        this.hasCheckParams = false;
    }

    public void setPositionAndVelocity(float f2, float f3) {
        this.moveParam = null;
        this.velocityScreenX = f2;
        this.velocityScreenY = f3;
        this.moveParam = new AbstractAdglAnimationParam2V();
        this.moveParam.setInterpolatorType(2, 1.2f);
        this.needMove = false;
        this.hasCheckParams = false;
    }

    public void commitAnimation(Object object) {
        if ((object = (GLMapState)object) == null) {
            return;
        }
        this.hasCheckParams = false;
        this.isOver = true;
        float f2 = this.velocityScreenX * (float)this.duration / 2000.0f;
        float f3 = this.velocityScreenY * (float)this.duration / 2000.0f;
        if (Math.abs(f2) != 0.0f && Math.abs(f3) != 0.0f) {
            this.isOver = false;
            IPoint iPoint = IPoint.obtain();
            ((GLMapState)object).getMapGeoCenter(iPoint);
            this.moveParam.setFromValue(iPoint.x, iPoint.y);
            float f4 = ((GLMapState)object).getMapLenWithWin(1);
            double d2 = (double)((GLMapState)object).getMapAngle() * Math.PI / 180.0;
            double d3 = (double)iPoint.x - (double)f4 * ((double)f2 * Math.cos(d2) - (double)f3 * Math.sin(d2));
            double d4 = (double)iPoint.y - (double)f4 * ((double)f2 * Math.sin(d2) + (double)f3 * Math.cos(d2));
            this.moveParam.setToValue(d3, d4);
            this.needMove = this.moveParam.needToCaculate();
            iPoint.recycle();
        }
        this.hasCheckParams = true;
        this.startTime = SystemClock.uptimeMillis();
    }

    @Override
    public void doAnimation(Object object) {
        float f2;
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        if (!this.hasCheckParams) {
            this.commitAnimation(object);
        }
        if (this.isOver) {
            return;
        }
        long l2 = SystemClock.uptimeMillis();
        this.offsetTime = l2 - this.startTime;
        float f3 = (float)this.offsetTime / (float)this.duration;
        if (f2 > 1.0f) {
            f3 = 1.0f;
            this.isOver = true;
        }
        if (f3 >= 0.0f && f3 <= 1.0f && this.needMove) {
            this.moveParam.setNormalizedTime(f3);
            double d2 = this.moveParam.getCurXValue();
            double d3 = this.moveParam.getCurYValue();
            gLMapState.setMapGeoCenter(d2, d3);
        }
    }
}

