/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.svg;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.os.Build;
import com.autonavi.ae.svg.SVGExternalFileResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;

public class SimpleAssetResolver
extends SVGExternalFileResolver {
    private static final String TAG = "SimpleAssetResolver";
    private AssetManager assetManager;
    private static final Set<String> supportedFormats = new HashSet<String>(8);

    public SimpleAssetResolver(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Override
    public Typeface resolveFont(String string2, int n2, String string3) {
        new StringBuilder("resolveFont(").append(string2).append(",").append(n2).append(",").append(string3).append(")");
        try {
            return Typeface.createFromAsset((AssetManager)this.assetManager, (String)(string2 + ".ttf"));
        }
        catch (RuntimeException runtimeException) {
            try {
                return Typeface.createFromAsset((AssetManager)this.assetManager, (String)(string2 + ".otf"));
            }
            catch (RuntimeException runtimeException2) {
                return null;
            }
        }
    }

    @Override
    public Bitmap resolveImage(String string2) {
        new StringBuilder("resolveImage(").append(string2).append(")");
        try {
            return BitmapFactory.decodeStream((InputStream)this.assetManager.open(string2));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean isFormatSupported(String string2) {
        return supportedFormats.contains(string2);
    }

    @Override
    public String resolveCSSStyleSheet(String string2) {
        new StringBuilder("resolveCSSStyleSheet(").append(string2).append(")");
        return this.getAssetAsString(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getAssetAsString(String object) {
        InputStream inputStream = null;
        try {
            inputStream = this.assetManager.open((String)object);
            object = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
            char[] cArray = new char[4096];
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = ((Reader)object).read(cArray);
            while (n2 > 0) {
                stringBuilder.append(cArray, 0, n2);
                n2 = ((Reader)object).read(cArray);
            }
            object = stringBuilder.toString();
        }
        catch (IOException iOException) {
            try {
                if (inputStream == null) return null;
                inputStream.close();
                return null;
            }
            catch (IOException iOException2) {
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputStream == null) return object;
            inputStream.close();
            return object;
        }
        catch (IOException iOException) {}
        return object;
    }

    static {
        supportedFormats.add("image/svg+xml");
        supportedFormats.add("image/jpeg");
        supportedFormats.add("image/png");
        supportedFormats.add("image/pjpeg");
        supportedFormats.add("image/gif");
        supportedFormats.add("image/bmp");
        supportedFormats.add("image/x-windows-bmp");
        if (Build.VERSION.SDK_INT >= 14) {
            supportedFormats.add("image/webp");
        }
    }
}

