/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.svg;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import com.autonavi.ae.svg.CSSParser;
import com.autonavi.ae.svg.CanvasLegacy;
import com.autonavi.ae.svg.PreserveAspectRatio;
import com.autonavi.ae.svg.RenderOptions;
import com.autonavi.ae.svg.SVG;
import com.autonavi.ae.svg.SVGExternalFileResolver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;

class SVGAndroidRenderer {
    private static final String TAG = "SVGAndroidRenderer";
    private Canvas canvas;
    private float dpi;
    private SVG document;
    private RendererState state;
    private Stack<RendererState> stateStack;
    private Stack<SVG.SvgContainer> parentStack;
    private Stack<Matrix> matrixStack;
    private static final float BEZIER_ARC_FACTOR = 0.5522848f;
    public static final float LUMINANCE_TO_ALPHA_RED = 0.2127f;
    public static final float LUMINANCE_TO_ALPHA_GREEN = 0.7151f;
    public static final float LUMINANCE_TO_ALPHA_BLUE = 0.0722f;
    private static final String DEFAULT_FONT_FAMILY = "serif";
    private static HashSet<String> supportedFeatures = null;
    private CSSParser.RuleMatchContext ruleMatchContext = null;

    private void resetState() {
        this.state = new RendererState();
        this.stateStack = new Stack();
        SVGAndroidRenderer sVGAndroidRenderer = this;
        sVGAndroidRenderer.updateStyle(sVGAndroidRenderer.state, SVG.Style.getDefaultStyle());
        this.state.viewPort = null;
        this.state.spacePreserve = false;
        SVGAndroidRenderer sVGAndroidRenderer2 = this;
        this.stateStack.push(sVGAndroidRenderer2.new RendererState(sVGAndroidRenderer2.state));
        this.matrixStack = new Stack();
        this.parentStack = new Stack();
    }

    SVGAndroidRenderer(Canvas canvas, float f2) {
        this.canvas = canvas;
        this.dpi = f2;
    }

    float getDPI() {
        return this.dpi;
    }

    float getCurrentFontSize() {
        return this.state.fillPaint.getTextSize();
    }

    float getCurrentFontXHeight() {
        return this.state.fillPaint.getTextSize() / 2.0f;
    }

    SVG.Box getCurrentViewPortInUserUnits() {
        if (this.state.viewBox != null) {
            return this.state.viewBox;
        }
        return this.state.viewPort;
    }

    void renderDocument(SVG sVG, RenderOptions renderOptions) {
        Object object;
        SVG.Box box;
        Object object2;
        Object object3;
        if (renderOptions == null) {
            throw new NullPointerException("renderOptions shouldn't be null");
        }
        this.document = sVG;
        SVG.Svg svg = sVG.getRootElement();
        if (svg == null) {
            SVGAndroidRenderer.warn("Nothing to render. Document is empty.", new Object[0]);
            return;
        }
        if (renderOptions.hasView()) {
            object3 = this.document.getElementById(renderOptions.viewId);
            if (object3 == null || !(object3 instanceof SVG.View)) {
                String.format("View element with id \"%s\" not found.", renderOptions.viewId);
                return;
            }
            object2 = (SVG.View)object3;
            if (((SVG.View)object2).viewBox == null) {
                String.format("View element with id \"%s\" is missing a viewBox attribute.", renderOptions.viewId);
                return;
            }
            box = ((SVG.View)object2).viewBox;
            object = ((SVG.View)object2).preserveAspectRatio;
        } else {
            box = renderOptions.hasViewBox() ? renderOptions.viewBox : svg.viewBox;
            object = object2 = renderOptions.hasPreserveAspectRatio() ? renderOptions.preserveAspectRatio : svg.preserveAspectRatio;
        }
        if (renderOptions.hasCss()) {
            sVG.addCSSRules(renderOptions.css);
        }
        if (renderOptions.hasTarget()) {
            this.ruleMatchContext = new CSSParser.RuleMatchContext();
            this.ruleMatchContext.targetElement = sVG.getElementById(renderOptions.targetId);
        }
        this.resetState();
        this.checkXMLSpaceAttribute(svg);
        this.statePush();
        object3 = new SVG.Box(renderOptions.viewPort);
        if (svg.width != null) {
            ((SVG.Box)object3).width = svg.width.floatValue(this, ((SVG.Box)object3).width);
        }
        if (svg.height != null) {
            ((SVG.Box)object3).height = svg.height.floatValue(this, ((SVG.Box)object3).height);
        }
        this.render(svg, (SVG.Box)object3, box, (PreserveAspectRatio)object2);
        this.statePop();
        if (renderOptions.hasCss()) {
            sVG.clearRenderCSSRules();
        }
    }

    private void render(SVG.SvgObject svgObject) {
        if (!(svgObject instanceof SVG.NotDirectlyRendered)) {
            this.statePush();
            this.checkXMLSpaceAttribute(svgObject);
            if (svgObject instanceof SVG.Svg) {
                this.render((SVG.Svg)svgObject);
            } else if (svgObject instanceof SVG.Use) {
                this.render((SVG.Use)svgObject);
            } else if (svgObject instanceof SVG.Switch) {
                this.render((SVG.Switch)svgObject);
            } else if (svgObject instanceof SVG.Group) {
                this.render((SVG.Group)svgObject);
            } else if (svgObject instanceof SVG.Image) {
                this.render((SVG.Image)svgObject);
            } else if (svgObject instanceof SVG.Path) {
                this.render((SVG.Path)svgObject);
            } else if (svgObject instanceof SVG.Rect) {
                this.render((SVG.Rect)svgObject);
            } else if (svgObject instanceof SVG.Circle) {
                this.render((SVG.Circle)svgObject);
            } else if (svgObject instanceof SVG.Ellipse) {
                this.render((SVG.Ellipse)svgObject);
            } else if (svgObject instanceof SVG.Line) {
                this.render((SVG.Line)svgObject);
            } else if (svgObject instanceof SVG.Polygon) {
                this.render((SVG.Polygon)svgObject);
            } else if (svgObject instanceof SVG.PolyLine) {
                this.render((SVG.PolyLine)svgObject);
            } else if (svgObject instanceof SVG.Text) {
                this.render((SVG.Text)svgObject);
            }
            this.statePop();
        }
    }

    private void renderChildren(SVG.SvgContainer object, boolean bl2) {
        if (bl2) {
            this.parentPush((SVG.SvgContainer)object);
        }
        for (SVG.SvgObject svgObject : object.getChildren()) {
            this.render(svgObject);
        }
        if (bl2) {
            this.parentPop();
        }
    }

    private void statePush() {
        this.canvas.save();
        this.stateStack.push(this.state);
        SVGAndroidRenderer sVGAndroidRenderer = this;
        this.state = sVGAndroidRenderer.new RendererState(sVGAndroidRenderer.state);
    }

    private void statePop() {
        this.canvas.restore();
        this.state = this.stateStack.pop();
    }

    private void parentPush(SVG.SvgContainer svgContainer) {
        this.parentStack.push(svgContainer);
        this.matrixStack.push(this.canvas.getMatrix());
    }

    private void parentPop() {
        this.parentStack.pop();
        this.matrixStack.pop();
    }

    private void updateStyleForElement(RendererState rendererState, SVG.SvgElementBase svgElementBase) {
        boolean bl2 = svgElementBase.parent == null;
        rendererState.style.resetNonInheritingProperties(bl2);
        if (svgElementBase.baseStyle != null) {
            this.updateStyle(rendererState, svgElementBase.baseStyle);
        }
        if (this.document.hasCSSRules()) {
            for (CSSParser.Rule rule : this.document.getCSSRules()) {
                if (!CSSParser.ruleMatch(this.ruleMatchContext, rule.selector, svgElementBase)) continue;
                this.updateStyle(rendererState, rule.style);
            }
        }
        if (svgElementBase.style != null) {
            this.updateStyle(rendererState, svgElementBase.style);
        }
    }

    private void checkXMLSpaceAttribute(SVG.SvgObject svgObject) {
        if (svgObject instanceof SVG.SvgElementBase) {
            svgObject = (SVG.SvgElementBase)svgObject;
            if (((SVG.SvgElementBase)svgObject).spacePreserve != null) {
                this.state.spacePreserve = ((SVG.SvgElementBase)svgObject).spacePreserve;
            }
        }
    }

    private void doFilledPath(SVG.SvgElement svgElement, Path path) {
        SVG.SvgObject svgObject;
        if (this.state.style.fill instanceof SVG.PaintReference && (svgObject = this.document.resolveIRI(((SVG.PaintReference)this.state.style.fill).href)) instanceof SVG.Pattern) {
            svgObject = (SVG.Pattern)svgObject;
            this.fillWithPattern(svgElement, path, (SVG.Pattern)svgObject);
            return;
        }
        this.canvas.drawPath(path, this.state.fillPaint);
    }

    private void doStroke(Path path) {
        if (this.state.style.vectorEffect == SVG.Style.VectorEffect.NonScalingStroke) {
            Matrix matrix = this.canvas.getMatrix();
            Path path2 = new Path();
            path.transform(matrix, path2);
            this.canvas.setMatrix(new Matrix());
            path = this.state.strokePaint.getShader();
            Matrix matrix2 = new Matrix();
            if (path != null) {
                path.getLocalMatrix(matrix2);
                Matrix matrix3 = new Matrix(matrix2);
                matrix3.postConcat(matrix);
                path.setLocalMatrix(matrix3);
            }
            this.canvas.drawPath(path2, this.state.strokePaint);
            this.canvas.setMatrix(matrix);
            if (path != null) {
                path.setLocalMatrix(matrix2);
            }
            return;
        }
        this.canvas.drawPath(path, this.state.strokePaint);
    }

    private static void warn(String string2, Object ... objectArray) {
        String.format(string2, objectArray);
    }

    private static void error(String string2, Object ... objectArray) {
        Log.e((String)TAG, (String)String.format(string2, objectArray));
    }

    private static void debug(String string2, Object ... objectArray) {
    }

    private void render(SVG.Svg svg) {
        SVG.Box box = this.makeViewPort(svg.x, svg.y, svg.width, svg.height);
        this.render(svg, box, svg.viewBox, svg.preserveAspectRatio);
    }

    private void render(SVG.Svg svg, SVG.Box box) {
        this.render(svg, box, svg.viewBox, svg.preserveAspectRatio);
    }

    private void render(SVG.Svg svg, SVG.Box box, SVG.Box box2, PreserveAspectRatio preserveAspectRatio) {
        SVGAndroidRenderer.debug("Svg render", new Object[0]);
        if (box.width != 0.0f && box.height != 0.0f) {
            if (preserveAspectRatio == null) {
                preserveAspectRatio = svg.preserveAspectRatio != null ? svg.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
            }
            SVGAndroidRenderer sVGAndroidRenderer = this;
            sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, svg);
            if (this.display()) {
                this.state.viewPort = box;
                if (!this.state.style.overflow.booleanValue()) {
                    SVGAndroidRenderer sVGAndroidRenderer2 = this;
                    sVGAndroidRenderer2.setClipRect(sVGAndroidRenderer2.state.viewPort.minX, this.state.viewPort.minY, this.state.viewPort.width, this.state.viewPort.height);
                }
                this.checkForClipPath(svg, this.state.viewPort);
                if (box2 != null) {
                    SVGAndroidRenderer sVGAndroidRenderer3 = this;
                    this.canvas.concat(sVGAndroidRenderer3.calculateViewBoxTransform(sVGAndroidRenderer3.state.viewPort, box2, preserveAspectRatio));
                    this.state.viewBox = svg.viewBox;
                } else {
                    this.canvas.translate(this.state.viewPort.minX, this.state.viewPort.minY);
                }
                boolean bl2 = this.pushLayer();
                this.viewportFill();
                this.renderChildren(svg, true);
                if (bl2) {
                    this.popLayer(svg);
                }
                this.updateParentBoundingBox(svg);
            }
        }
    }

    private SVG.Box makeViewPort(SVG.Length length, SVG.Length length2, SVG.Length length3, SVG.Length length4) {
        float f2 = length != null ? length.floatValueX(this) : 0.0f;
        float f3 = length2 != null ? length2.floatValueY(this) : 0.0f;
        SVG.Box box = this.getCurrentViewPortInUserUnits();
        float f4 = length3 != null ? length3.floatValueX(this) : box.width;
        float f5 = length4 != null ? length4.floatValueY(this) : box.height;
        return new SVG.Box(f2, f3, f4, f5);
    }

    private void render(SVG.Group group) {
        SVGAndroidRenderer.debug("Group render", new Object[0]);
        SVGAndroidRenderer sVGAndroidRenderer = this;
        sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, group);
        if (this.display()) {
            if (group.transform != null) {
                this.canvas.concat(group.transform);
            }
            this.checkForClipPath(group);
            boolean bl2 = this.pushLayer();
            this.renderChildren(group, true);
            if (bl2) {
                this.popLayer(group);
            }
            this.updateParentBoundingBox(group);
        }
    }

    private void updateParentBoundingBox(SVG.SvgElement object) {
        if (((SVG.SvgElement)object).parent != null && ((SVG.SvgElement)object).boundingBox != null) {
            Matrix matrix = new Matrix();
            if (this.matrixStack.peek().invert(matrix)) {
                object = new float[]{((SVG.SvgElement)object).boundingBox.minX, ((SVG.SvgElement)object).boundingBox.minY, ((SVG.SvgElement)object).boundingBox.maxX(), ((SVG.SvgElement)object).boundingBox.minY, ((SVG.SvgElement)object).boundingBox.maxX(), ((SVG.SvgElement)object).boundingBox.maxY(), ((SVG.SvgElement)object).boundingBox.minX, ((SVG.SvgElement)object).boundingBox.maxY()};
                matrix.preConcat(this.canvas.getMatrix());
                matrix.mapPoints((float[])object);
                matrix = new RectF((float)object[0], (float)object[1], (float)object[0], (float)object[1]);
                for (int i2 = 2; i2 <= 6; i2 += 2) {
                    if (object[i2] < matrix.left) {
                        matrix.left = (float)object[i2];
                    }
                    if (object[i2] > matrix.right) {
                        matrix.right = (float)object[i2];
                    }
                    if (object[i2 + 1] < matrix.top) {
                        matrix.top = (float)object[i2 + 1];
                    }
                    if (!(object[i2 + 1] > matrix.bottom)) continue;
                    matrix.bottom = (float)object[i2 + 1];
                }
                SVG.SvgElement svgElement = (SVG.SvgElement)((Object)this.parentStack.peek());
                if (svgElement.boundingBox == null) {
                    svgElement.boundingBox = SVG.Box.fromLimits(matrix.left, matrix.top, matrix.right, matrix.bottom);
                    return;
                }
                svgElement.boundingBox.union(SVG.Box.fromLimits(matrix.left, matrix.top, matrix.right, matrix.bottom));
            }
        }
    }

    private boolean pushLayer() {
        SVG.SvgObject svgObject;
        if (!this.requiresCompositing()) {
            return false;
        }
        this.canvas.saveLayerAlpha(null, SVGAndroidRenderer.clamp255(this.state.style.opacity.floatValue()), 31);
        this.stateStack.push(this.state);
        SVGAndroidRenderer sVGAndroidRenderer = this;
        this.state = sVGAndroidRenderer.new RendererState(sVGAndroidRenderer.state);
        if (!(this.state.style.mask == null || (svgObject = this.document.resolveIRI(this.state.style.mask)) != null && svgObject instanceof SVG.Mask)) {
            SVGAndroidRenderer.error("Mask reference '%s' not found", this.state.style.mask);
            this.state.style.mask = null;
            return true;
        }
        return true;
    }

    private void popLayer(SVG.SvgElement svgElement) {
        SVG.SvgElement svgElement2 = svgElement;
        this.popLayer(svgElement2, svgElement2.boundingBox);
    }

    private void popLayer(SVG.SvgElement svgElement, SVG.Box box) {
        if (this.state.style.mask != null) {
            Object object = new Paint();
            object.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
            this.canvas.saveLayer(null, object, 31);
            object = new Paint();
            ColorMatrix colorMatrix = new ColorMatrix(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.2127f, 0.7151f, 0.0722f, 0.0f, 0.0f});
            object.setColorFilter((ColorFilter)new ColorMatrixColorFilter(colorMatrix));
            this.canvas.saveLayer(null, object, 31);
            object = this.document.resolveIRI(this.state.style.mask);
            this.renderMask((SVG.Mask)object, svgElement, box);
            this.canvas.restore();
            colorMatrix = new Paint();
            colorMatrix.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
            this.canvas.saveLayer(null, (Paint)colorMatrix, 31);
            this.renderMask((SVG.Mask)object, svgElement, box);
            this.canvas.restore();
            this.canvas.restore();
        }
        this.statePop();
    }

    private boolean requiresCompositing() {
        return this.state.style.opacity.floatValue() < 1.0f || this.state.style.mask != null;
    }

    private void render(SVG.Switch switch_) {
        SVGAndroidRenderer.debug("Switch render", new Object[0]);
        SVGAndroidRenderer sVGAndroidRenderer = this;
        sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, switch_);
        if (this.display()) {
            if (switch_.transform != null) {
                this.canvas.concat(switch_.transform);
            }
            this.checkForClipPath(switch_);
            boolean bl2 = this.pushLayer();
            this.renderSwitchChild(switch_);
            if (bl2) {
                this.popLayer(switch_);
            }
            this.updateParentBoundingBox(switch_);
        }
    }

    private void renderSwitchChild(SVG.Switch object) {
        String string2 = Locale.getDefault().getLanguage();
        SVGExternalFileResolver sVGExternalFileResolver = SVG.getFileResolver();
        block0: for (SVG.SvgObject svgObject : ((SVG.SvgConditionalContainer)((Object)object)).getChildren()) {
            Set<String> set;
            SVG.SvgConditional svgConditional;
            if (!(svgObject instanceof SVG.SvgConditional) || (svgConditional = (SVG.SvgConditional)((Object)svgObject)).getRequiredExtensions() != null || (set = svgConditional.getSystemLanguage()) != null && (set.isEmpty() || !set.contains(string2))) continue;
            set = svgConditional.getRequiredFeatures();
            if (set != null) {
                if (supportedFeatures == null) {
                    SVGAndroidRenderer.initialiseSupportedFeaturesMap();
                }
                if (set.isEmpty() || !supportedFeatures.containsAll(set)) continue;
            }
            if ((set = svgConditional.getRequiredFormats()) != null) {
                if (set.isEmpty() || sVGExternalFileResolver == null) continue;
                set = set.iterator();
                while (set.hasNext()) {
                    String string3 = (String)set.next();
                    if (!sVGExternalFileResolver.isFormatSupported(string3)) continue block0;
                }
            }
            if ((set = svgConditional.getRequiredFonts()) != null) {
                if (set.isEmpty() || sVGExternalFileResolver == null) continue;
                for (String string4 : set) {
                    if (sVGExternalFileResolver.resolveFont(string4, this.state.style.fontWeight, String.valueOf((Object)this.state.style.fontStyle)) == null) continue block0;
                }
            }
            this.render(svgObject);
            return;
        }
    }

    private static synchronized void initialiseSupportedFeaturesMap() {
        supportedFeatures = new HashSet<String>();
        supportedFeatures.add("Structure");
        supportedFeatures.add("BasicStructure");
        supportedFeatures.add("ConditionalProcessing");
        supportedFeatures.add("Image");
        supportedFeatures.add("Style");
        supportedFeatures.add("ViewportAttribute");
        supportedFeatures.add("Shape");
        supportedFeatures.add("BasicText");
        supportedFeatures.add("PaintAttribute");
        supportedFeatures.add("BasicPaintAttribute");
        supportedFeatures.add("OpacityAttribute");
        supportedFeatures.add("BasicGraphicsAttribute");
        supportedFeatures.add("Marker");
        supportedFeatures.add("Gradient");
        supportedFeatures.add("Pattern");
        supportedFeatures.add("Clip");
        supportedFeatures.add("BasicClip");
        supportedFeatures.add("Mask");
        supportedFeatures.add("View");
    }

    private void render(SVG.Use use) {
        SVGAndroidRenderer.debug("Use render", new Object[0]);
        if (!(use.width != null && use.width.isZero() || use.height != null && use.height.isZero())) {
            SVGAndroidRenderer sVGAndroidRenderer = this;
            sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, use);
            if (this.display()) {
                SVG.SvgObject svgObject = use.document.resolveIRI(use.href);
                if (svgObject == null) {
                    SVGAndroidRenderer.error("Use reference '%s' not found", use.href);
                    return;
                }
                if (use.transform != null) {
                    this.canvas.concat(use.transform);
                }
                float f2 = use.x != null ? use.x.floatValueX(this) : 0.0f;
                float f3 = use.y != null ? use.y.floatValueY(this) : 0.0f;
                this.canvas.translate(f2, f3);
                this.checkForClipPath(use);
                boolean bl2 = this.pushLayer();
                this.parentPush(use);
                if (svgObject instanceof SVG.Svg) {
                    SVG.Svg svg = (SVG.Svg)svgObject;
                    SVG.Box box = this.makeViewPort(null, null, use.width, use.height);
                    this.statePush();
                    this.render(svg, box);
                    this.statePop();
                } else if (svgObject instanceof SVG.Symbol) {
                    Object object = use.width != null ? use.width : new SVG.Length(100.0f, SVG.Unit.percent);
                    SVG.Length length = use.height != null ? use.height : new SVG.Length(100.0f, SVG.Unit.percent);
                    object = this.makeViewPort(null, null, (SVG.Length)object, length);
                    this.statePush();
                    this.render((SVG.Symbol)svgObject, (SVG.Box)object);
                    this.statePop();
                } else {
                    this.render(svgObject);
                }
                this.parentPop();
                if (bl2) {
                    this.popLayer(use);
                }
                this.updateParentBoundingBox(use);
            }
        }
    }

    private void render(SVG.Path path) {
        SVGAndroidRenderer.debug("Path render", new Object[0]);
        if (path.d != null) {
            SVGAndroidRenderer sVGAndroidRenderer = this;
            sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, path);
            if (this.display() && this.visible() && (this.state.hasStroke || this.state.hasFill)) {
                if (path.transform != null) {
                    this.canvas.concat(path.transform);
                }
                Path path2 = new PathConverter(path.d).getPath();
                if (path.boundingBox == null) {
                    path.boundingBox = this.calculatePathBounds(path2);
                }
                this.updateParentBoundingBox(path);
                this.checkForGradientsAndPatterns(path);
                this.checkForClipPath(path);
                boolean bl2 = this.pushLayer();
                if (this.state.hasFill) {
                    path2.setFillType(this.getFillTypeFromState());
                    this.doFilledPath(path, path2);
                }
                if (this.state.hasStroke) {
                    this.doStroke(path2);
                }
                this.renderMarkers(path);
                if (bl2) {
                    this.popLayer(path);
                }
            }
        }
    }

    private SVG.Box calculatePathBounds(Path path) {
        RectF rectF = new RectF();
        path.computeBounds(rectF, true);
        return new SVG.Box(rectF.left, rectF.top, rectF.width(), rectF.height());
    }

    private void render(SVG.Rect rect) {
        SVGAndroidRenderer.debug("Rect render", new Object[0]);
        if (rect.width != null && rect.height != null && !rect.width.isZero() && !rect.height.isZero()) {
            SVGAndroidRenderer sVGAndroidRenderer = this;
            sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, rect);
            if (this.display() && this.visible()) {
                if (rect.transform != null) {
                    this.canvas.concat(rect.transform);
                }
                Path path = this.makePathAndBoundingBox(rect);
                this.updateParentBoundingBox(rect);
                this.checkForGradientsAndPatterns(rect);
                this.checkForClipPath(rect);
                boolean bl2 = this.pushLayer();
                if (this.state.hasFill) {
                    this.doFilledPath(rect, path);
                }
                if (this.state.hasStroke) {
                    this.doStroke(path);
                }
                if (bl2) {
                    this.popLayer(rect);
                }
            }
        }
    }

    private void render(SVG.Circle circle) {
        SVGAndroidRenderer.debug("Circle render", new Object[0]);
        if (circle.r != null && !circle.r.isZero()) {
            SVGAndroidRenderer sVGAndroidRenderer = this;
            sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, circle);
            if (this.display() && this.visible()) {
                if (circle.transform != null) {
                    this.canvas.concat(circle.transform);
                }
                Path path = this.makePathAndBoundingBox(circle);
                this.updateParentBoundingBox(circle);
                this.checkForGradientsAndPatterns(circle);
                this.checkForClipPath(circle);
                boolean bl2 = this.pushLayer();
                if (this.state.hasFill) {
                    this.doFilledPath(circle, path);
                }
                if (this.state.hasStroke) {
                    this.doStroke(path);
                }
                if (bl2) {
                    this.popLayer(circle);
                }
            }
        }
    }

    private void render(SVG.Ellipse ellipse) {
        SVGAndroidRenderer.debug("Ellipse render", new Object[0]);
        if (ellipse.rx != null && ellipse.ry != null && !ellipse.rx.isZero() && !ellipse.ry.isZero()) {
            SVGAndroidRenderer sVGAndroidRenderer = this;
            sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, ellipse);
            if (this.display() && this.visible()) {
                if (ellipse.transform != null) {
                    this.canvas.concat(ellipse.transform);
                }
                Path path = this.makePathAndBoundingBox(ellipse);
                this.updateParentBoundingBox(ellipse);
                this.checkForGradientsAndPatterns(ellipse);
                this.checkForClipPath(ellipse);
                boolean bl2 = this.pushLayer();
                if (this.state.hasFill) {
                    this.doFilledPath(ellipse, path);
                }
                if (this.state.hasStroke) {
                    this.doStroke(path);
                }
                if (bl2) {
                    this.popLayer(ellipse);
                }
            }
        }
    }

    private void render(SVG.Line line) {
        SVGAndroidRenderer.debug("Line render", new Object[0]);
        SVGAndroidRenderer sVGAndroidRenderer = this;
        sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, line);
        if (this.display() && this.visible() && this.state.hasStroke) {
            if (line.transform != null) {
                this.canvas.concat(line.transform);
            }
            Path path = this.makePathAndBoundingBox(line);
            this.updateParentBoundingBox(line);
            this.checkForGradientsAndPatterns(line);
            this.checkForClipPath(line);
            boolean bl2 = this.pushLayer();
            this.doStroke(path);
            this.renderMarkers(line);
            if (bl2) {
                this.popLayer(line);
            }
        }
    }

    private List<MarkerVector> calculateMarkerPositions(SVG.Line line) {
        float f2 = line.x1 != null ? line.x1.floatValueX(this) : 0.0f;
        float f3 = line.y1 != null ? line.y1.floatValueY(this) : 0.0f;
        float f4 = line.x2 != null ? line.x2.floatValueX(this) : 0.0f;
        float f5 = line.y2 != null ? line.y2.floatValueY(this) : 0.0f;
        ArrayList<MarkerVector> arrayList = new ArrayList<MarkerVector>(2);
        arrayList.add(new MarkerVector(f2, f3, f4 - f2, f5 - f3));
        arrayList.add(new MarkerVector(f4, f5, f4 - f2, f5 - f3));
        return arrayList;
    }

    private void render(SVG.PolyLine polyLine) {
        SVGAndroidRenderer.debug("PolyLine render", new Object[0]);
        SVGAndroidRenderer sVGAndroidRenderer = this;
        sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, polyLine);
        if (this.display() && this.visible() && (this.state.hasStroke || this.state.hasFill)) {
            if (polyLine.transform != null) {
                this.canvas.concat(polyLine.transform);
            }
            if (polyLine.points.length >= 2) {
                Path path = this.makePathAndBoundingBox(polyLine);
                this.updateParentBoundingBox(polyLine);
                path.setFillType(this.getFillTypeFromState());
                this.checkForGradientsAndPatterns(polyLine);
                this.checkForClipPath(polyLine);
                boolean bl2 = this.pushLayer();
                if (this.state.hasFill) {
                    this.doFilledPath(polyLine, path);
                }
                if (this.state.hasStroke) {
                    this.doStroke(path);
                }
                this.renderMarkers(polyLine);
                if (bl2) {
                    this.popLayer(polyLine);
                }
            }
        }
    }

    private List<MarkerVector> calculateMarkerPositions(SVG.PolyLine polyLine) {
        int n2 = polyLine.points.length;
        if (n2 < 2) {
            return null;
        }
        ArrayList<MarkerVector> arrayList = new ArrayList<MarkerVector>();
        MarkerVector markerVector = new MarkerVector(polyLine.points[0], polyLine.points[1], 0.0f, 0.0f);
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 2; i2 < n2; i2 += 2) {
            f2 = polyLine.points[i2];
            f3 = polyLine.points[i2 + 1];
            markerVector.add(f2, f3);
            arrayList.add(markerVector);
            markerVector = new MarkerVector(f2, f3, f2 - markerVector.x, f3 - markerVector.y);
        }
        if (polyLine instanceof SVG.Polygon) {
            if (f2 != polyLine.points[0] && f3 != polyLine.points[1]) {
                f2 = polyLine.points[0];
                f3 = polyLine.points[1];
                markerVector.add(f2, f3);
                arrayList.add(markerVector);
                MarkerVector markerVector2 = new MarkerVector(f2, f3, f2 - markerVector.x, f3 - markerVector.y);
                markerVector2.add((MarkerVector)arrayList.get(0));
                arrayList.add(markerVector2);
                arrayList.set(0, markerVector2);
            }
        } else {
            arrayList.add(markerVector);
        }
        return arrayList;
    }

    private void render(SVG.Polygon polygon) {
        SVGAndroidRenderer.debug("Polygon render", new Object[0]);
        SVGAndroidRenderer sVGAndroidRenderer = this;
        sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, polygon);
        if (this.display() && this.visible() && (this.state.hasStroke || this.state.hasFill)) {
            if (polygon.transform != null) {
                this.canvas.concat(polygon.transform);
            }
            if (polygon.points.length >= 2) {
                Path path = this.makePathAndBoundingBox(polygon);
                this.updateParentBoundingBox(polygon);
                this.checkForGradientsAndPatterns(polygon);
                this.checkForClipPath(polygon);
                boolean bl2 = this.pushLayer();
                if (this.state.hasFill) {
                    this.doFilledPath(polygon, path);
                }
                if (this.state.hasStroke) {
                    this.doStroke(path);
                }
                this.renderMarkers(polygon);
                if (bl2) {
                    this.popLayer(polygon);
                }
            }
        }
    }

    private void render(SVG.Text text) {
        SVGAndroidRenderer.debug("Text render", new Object[0]);
        SVGAndroidRenderer sVGAndroidRenderer = this;
        sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, text);
        if (this.display()) {
            if (text.transform != null) {
                this.canvas.concat(text.transform);
            }
            float f2 = text.x != null && text.x.size() != 0 ? ((SVG.Length)text.x.get(0)).floatValueX(this) : 0.0f;
            float f3 = text.y != null && text.y.size() != 0 ? ((SVG.Length)text.y.get(0)).floatValueY(this) : 0.0f;
            float f4 = text.dx != null && text.dx.size() != 0 ? ((SVG.Length)text.dx.get(0)).floatValueX(this) : 0.0f;
            float f5 = text.dy != null && text.dy.size() != 0 ? ((SVG.Length)text.dy.get(0)).floatValueY(this) : 0.0f;
            SVG.Style.TextAnchor textAnchor = this.getAnchorPosition();
            if (textAnchor != SVG.Style.TextAnchor.Start) {
                float f6 = this.calculateTextWidth(text);
                f2 = textAnchor == SVG.Style.TextAnchor.Middle ? (f2 -= f6 / 2.0f) : (f2 -= f6);
            }
            if (text.boundingBox == null) {
                TextBoundsCalculator textBoundsCalculator = new TextBoundsCalculator(f2, f3);
                this.enumerateTextSpans(text, textBoundsCalculator);
                text.boundingBox = new SVG.Box(textBoundsCalculator.bbox.left, textBoundsCalculator.bbox.top, textBoundsCalculator.bbox.width(), textBoundsCalculator.bbox.height());
            }
            this.updateParentBoundingBox(text);
            this.checkForGradientsAndPatterns(text);
            this.checkForClipPath(text);
            boolean bl2 = this.pushLayer();
            this.enumerateTextSpans(text, new PlainTextDrawer(f2 + f4, f3 + f5));
            if (bl2) {
                this.popLayer(text);
            }
        }
    }

    private SVG.Style.TextAnchor getAnchorPosition() {
        if (this.state.style.direction != SVG.Style.TextDirection.LTR && this.state.style.textAnchor != SVG.Style.TextAnchor.Middle) {
            if (this.state.style.textAnchor == SVG.Style.TextAnchor.Start) {
                return SVG.Style.TextAnchor.End;
            }
            return SVG.Style.TextAnchor.Start;
        }
        return this.state.style.textAnchor;
    }

    private void enumerateTextSpans(SVG.TextContainer object, TextProcessor textProcessor) {
        if (this.display()) {
            object = ((SVG.TextContainer)object).children.iterator();
            boolean bl2 = true;
            while (object.hasNext()) {
                SVG.SvgObject svgObject = (SVG.SvgObject)object.next();
                if (svgObject instanceof SVG.TextSequence) {
                    textProcessor.processText(this.textXMLSpaceTransform(((SVG.TextSequence)svgObject).text, bl2, !object.hasNext()));
                } else {
                    this.processTextChild(svgObject, textProcessor);
                }
                bl2 = false;
            }
        }
    }

    private void processTextChild(SVG.SvgObject svgObject, TextProcessor textProcessor) {
        block13: {
            block15: {
                block14: {
                    if (!textProcessor.doTextContainer((SVG.TextContainer)svgObject)) break block13;
                    if (!(svgObject instanceof SVG.TextPath)) break block14;
                    this.statePush();
                    this.renderTextPath((SVG.TextPath)svgObject);
                    break block15;
                }
                if (svgObject instanceof SVG.TSpan) {
                    SVGAndroidRenderer.debug("TSpan render", new Object[0]);
                    this.statePush();
                    SVG.TSpan tSpan = (SVG.TSpan)svgObject;
                    SVGAndroidRenderer sVGAndroidRenderer = this;
                    sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, tSpan);
                    if (this.display()) {
                        SVG.Style.TextAnchor textAnchor;
                        boolean bl2;
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        float f4 = 0.0f;
                        float f5 = 0.0f;
                        boolean bl3 = bl2 = tSpan.x != null && tSpan.x.size() > 0;
                        if (textProcessor instanceof PlainTextDrawer) {
                            f2 = !bl2 ? ((PlainTextDrawer)textProcessor).x : ((SVG.Length)tSpan.x.get(0)).floatValueX(this);
                            f3 = tSpan.y != null && tSpan.y.size() != 0 ? ((SVG.Length)tSpan.y.get(0)).floatValueY(this) : ((PlainTextDrawer)textProcessor).y;
                            f4 = tSpan.dx != null && tSpan.dx.size() != 0 ? ((SVG.Length)tSpan.dx.get(0)).floatValueX(this) : 0.0f;
                            float f6 = f5 = tSpan.dy != null && tSpan.dy.size() != 0 ? ((SVG.Length)tSpan.dy.get(0)).floatValueY(this) : 0.0f;
                        }
                        if (bl2 && (textAnchor = this.getAnchorPosition()) != SVG.Style.TextAnchor.Start) {
                            float f7 = this.calculateTextWidth(tSpan);
                            f2 = textAnchor == SVG.Style.TextAnchor.Middle ? (f2 -= f7 / 2.0f) : (f2 -= f7);
                        }
                        this.checkForGradientsAndPatterns((SVG.SvgElement)((Object)tSpan.getTextRoot()));
                        if (textProcessor instanceof PlainTextDrawer) {
                            ((PlainTextDrawer)textProcessor).x = f2 + f4;
                            ((PlainTextDrawer)textProcessor).y = f3 + f5;
                        }
                        bl2 = this.pushLayer();
                        this.enumerateTextSpans(tSpan, textProcessor);
                        if (bl2) {
                            this.popLayer(tSpan);
                        }
                    }
                    this.statePop();
                    return;
                }
                if (!(svgObject instanceof SVG.TRef)) break block13;
                this.statePush();
                SVG.TRef tRef = (SVG.TRef)svgObject;
                SVGAndroidRenderer sVGAndroidRenderer = this;
                sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, tRef);
                if (this.display()) {
                    this.checkForGradientsAndPatterns((SVG.SvgElement)((Object)tRef.getTextRoot()));
                    svgObject = svgObject.document.resolveIRI(tRef.href);
                    if (svgObject != null && svgObject instanceof SVG.TextContainer) {
                        StringBuilder stringBuilder = new StringBuilder();
                        this.extractRawText((SVG.TextContainer)svgObject, stringBuilder);
                        if (stringBuilder.length() > 0) {
                            textProcessor.processText(stringBuilder.toString());
                        }
                    } else {
                        SVGAndroidRenderer.error("Tref reference '%s' not found", tRef.href);
                    }
                }
            }
            this.statePop();
        }
    }

    private void renderTextPath(SVG.TextPath textPath) {
        SVGAndroidRenderer.debug("TextPath render", new Object[0]);
        SVGAndroidRenderer sVGAndroidRenderer = this;
        sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, textPath);
        if (this.display() && this.visible()) {
            SVG.SvgObject svgObject = textPath.document.resolveIRI(textPath.href);
            if (svgObject == null) {
                SVGAndroidRenderer.error("TextPath reference '%s' not found", textPath.href);
                return;
            }
            svgObject = (SVG.Path)svgObject;
            Path path = new PathConverter(((SVG.Path)svgObject).d).getPath();
            if (((SVG.Path)svgObject).transform != null) {
                path.transform(((SVG.Path)svgObject).transform);
            }
            svgObject = new PathMeasure(path, false);
            float f2 = textPath.startOffset != null ? textPath.startOffset.floatValue(this, svgObject.getLength()) : 0.0f;
            SVG.Style.TextAnchor textAnchor = this.getAnchorPosition();
            if (textAnchor != SVG.Style.TextAnchor.Start) {
                float f3 = this.calculateTextWidth(textPath);
                f2 = textAnchor == SVG.Style.TextAnchor.Middle ? (f2 -= f3 / 2.0f) : (f2 -= f3);
            }
            this.checkForGradientsAndPatterns((SVG.SvgElement)((Object)textPath.getTextRoot()));
            boolean bl2 = this.pushLayer();
            this.enumerateTextSpans(textPath, new PathTextDrawer(path, f2, 0.0f));
            if (bl2) {
                this.popLayer(textPath);
            }
        }
    }

    private float calculateTextWidth(SVG.TextContainer textContainer) {
        TextWidthCalculator textWidthCalculator = new TextWidthCalculator();
        this.enumerateTextSpans(textContainer, textWidthCalculator);
        return textWidthCalculator.x;
    }

    private void extractRawText(SVG.TextContainer object, StringBuilder stringBuilder) {
        object = ((SVG.TextContainer)object).children.iterator();
        boolean bl2 = true;
        while (object.hasNext()) {
            SVG.SvgObject svgObject = (SVG.SvgObject)object.next();
            if (svgObject instanceof SVG.TextContainer) {
                this.extractRawText((SVG.TextContainer)svgObject, stringBuilder);
            } else if (svgObject instanceof SVG.TextSequence) {
                stringBuilder.append(this.textXMLSpaceTransform(((SVG.TextSequence)svgObject).text, bl2, !object.hasNext()));
            }
            bl2 = false;
        }
    }

    private String textXMLSpaceTransform(String string2, boolean bl2, boolean bl3) {
        if (this.state.spacePreserve) {
            return string2.replaceAll("[\\n\\t]", " ");
        }
        string2 = string2.replaceAll("\\n", "").replaceAll("\\t", " ");
        if (bl2) {
            string2 = string2.replaceAll("^\\s+", "");
        }
        if (bl3) {
            string2 = string2.replaceAll("\\s+$", "");
        }
        return string2.replaceAll("\\s{2,}", " ");
    }

    private void render(SVG.Symbol symbol, SVG.Box box) {
        SVGAndroidRenderer.debug("Symbol render", new Object[0]);
        if (box.width != 0.0f && box.height != 0.0f) {
            PreserveAspectRatio preserveAspectRatio = symbol.preserveAspectRatio != null ? symbol.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
            SVGAndroidRenderer sVGAndroidRenderer = this;
            sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, symbol);
            this.state.viewPort = box;
            if (!this.state.style.overflow.booleanValue()) {
                SVGAndroidRenderer sVGAndroidRenderer2 = this;
                sVGAndroidRenderer2.setClipRect(sVGAndroidRenderer2.state.viewPort.minX, this.state.viewPort.minY, this.state.viewPort.width, this.state.viewPort.height);
            }
            if (symbol.viewBox != null) {
                SVGAndroidRenderer sVGAndroidRenderer3 = this;
                this.canvas.concat(sVGAndroidRenderer3.calculateViewBoxTransform(sVGAndroidRenderer3.state.viewPort, symbol.viewBox, preserveAspectRatio));
                this.state.viewBox = symbol.viewBox;
            } else {
                this.canvas.translate(this.state.viewPort.minX, this.state.viewPort.minY);
            }
            boolean bl2 = this.pushLayer();
            this.renderChildren(symbol, true);
            if (bl2) {
                this.popLayer(symbol);
            }
            this.updateParentBoundingBox(symbol);
        }
    }

    private void render(SVG.Image image) {
        SVGAndroidRenderer.debug("Image render", new Object[0]);
        if (image.width != null && !image.width.isZero() && image.height != null && !image.height.isZero() && image.href != null) {
            Object object;
            PreserveAspectRatio preserveAspectRatio = image.preserveAspectRatio != null ? image.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
            Bitmap bitmap = this.checkForImageDataURL(image.href);
            if (bitmap == null) {
                object = SVG.getFileResolver();
                if (object == null) {
                    return;
                }
                bitmap = ((SVGExternalFileResolver)object).resolveImage(image.href);
            }
            if (bitmap == null) {
                SVGAndroidRenderer.error("Could not locate image '%s'", image.href);
                return;
            }
            object = new SVG.Box(0.0f, 0.0f, bitmap.getWidth(), bitmap.getHeight());
            SVGAndroidRenderer sVGAndroidRenderer = this;
            sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, image);
            if (this.display() && this.visible()) {
                if (image.transform != null) {
                    this.canvas.concat(image.transform);
                }
                float f2 = image.x != null ? image.x.floatValueX(this) : 0.0f;
                float f3 = image.y != null ? image.y.floatValueY(this) : 0.0f;
                float f4 = image.width.floatValueX(this);
                float f5 = image.height.floatValueX(this);
                this.state.viewPort = new SVG.Box(f2, f3, f4, f5);
                if (!this.state.style.overflow.booleanValue()) {
                    SVGAndroidRenderer sVGAndroidRenderer2 = this;
                    sVGAndroidRenderer2.setClipRect(sVGAndroidRenderer2.state.viewPort.minX, this.state.viewPort.minY, this.state.viewPort.width, this.state.viewPort.height);
                }
                image.boundingBox = this.state.viewPort;
                this.updateParentBoundingBox(image);
                this.checkForClipPath(image);
                boolean bl2 = this.pushLayer();
                this.viewportFill();
                this.canvas.save();
                SVGAndroidRenderer sVGAndroidRenderer3 = this;
                this.canvas.concat(sVGAndroidRenderer3.calculateViewBoxTransform(sVGAndroidRenderer3.state.viewPort, (SVG.Box)object, preserveAspectRatio));
                preserveAspectRatio = new Paint(this.state.style.imageRendering == SVG.Style.RenderQuality.optimizeSpeed ? 0 : 2);
                this.canvas.drawBitmap(bitmap, 0.0f, 0.0f, (Paint)preserveAspectRatio);
                this.canvas.restore();
                if (bl2) {
                    this.popLayer(image);
                }
            }
        }
    }

    private Bitmap checkForImageDataURL(String object) {
        if (!((String)object).startsWith("data:")) {
            return null;
        }
        if (((String)object).length() < 14) {
            return null;
        }
        int n2 = ((String)object).indexOf(44);
        if (n2 < 12) {
            return null;
        }
        if (!";base64".equals(((String)object).substring(n2 - 7, n2))) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)((String)object).substring(n2 + 1), (int)0);
            object = byArray;
            return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)((Object)object).length);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Could not decode bad Data URL", (Throwable)exception);
            return null;
        }
    }

    private boolean display() {
        if (this.state.style.display != null) {
            return this.state.style.display;
        }
        return true;
    }

    private boolean visible() {
        if (this.state.style.visibility != null) {
            return this.state.style.visibility;
        }
        return true;
    }

    private Matrix calculateViewBoxTransform(SVG.Box box, SVG.Box box2, PreserveAspectRatio preserveAspectRatio) {
        Matrix matrix = new Matrix();
        if (preserveAspectRatio != null && preserveAspectRatio.getAlignment() != null) {
            float f2 = box.width / box2.width;
            float f3 = box.height / box2.height;
            float f4 = -box2.minX;
            float f5 = -box2.minY;
            if (preserveAspectRatio.equals(PreserveAspectRatio.STRETCH)) {
                matrix.preTranslate(box.minX, box.minY);
                matrix.preScale(f2, f3);
                matrix.preTranslate(f4, f5);
                return matrix;
            }
            f2 = preserveAspectRatio.getScale() == PreserveAspectRatio.Scale.slice ? Math.max(f2, f3) : Math.min(f2, f3);
            f3 = box.width / f2;
            float f6 = box.height / f2;
            switch (preserveAspectRatio.getAlignment()) {
                case xMidYMin: 
                case xMidYMid: 
                case xMidYMax: {
                    f4 -= (box2.width - f3) / 2.0f;
                    break;
                }
                case xMaxYMin: 
                case xMaxYMid: 
                case xMaxYMax: {
                    f4 -= box2.width - f3;
                }
            }
            switch (preserveAspectRatio.getAlignment()) {
                case xMidYMid: 
                case xMaxYMid: 
                case xMinYMid: {
                    f5 -= (box2.height - f6) / 2.0f;
                    break;
                }
                case xMidYMax: 
                case xMaxYMax: 
                case xMinYMax: {
                    f5 -= box2.height - f6;
                }
            }
            matrix.preTranslate(box.minX, box.minY);
            float f7 = f2;
            matrix.preScale(f7, f7);
            matrix.preTranslate(f4, f5);
            return matrix;
        }
        return matrix;
    }

    private boolean isSpecified(SVG.Style style2, long l2) {
        return (style2.specifiedFlags & l2) != 0L;
    }

    private void updateStyle(RendererState rendererState, SVG.Style style2) {
        Object object;
        float f2;
        if (this.isSpecified(style2, 4096L)) {
            rendererState.style.color = style2.color;
        }
        if (this.isSpecified(style2, 2048L)) {
            rendererState.style.opacity = style2.opacity;
        }
        if (this.isSpecified(style2, 1L)) {
            rendererState.style.fill = style2.fill;
            boolean bl2 = rendererState.hasFill = style2.fill != null && style2.fill != SVG.Colour.TRANSPARENT;
        }
        if (this.isSpecified(style2, 4L)) {
            rendererState.style.fillOpacity = style2.fillOpacity;
        }
        if (this.isSpecified(style2, 6149L)) {
            this.setPaintColour(rendererState, true, rendererState.style.fill);
        }
        if (this.isSpecified(style2, 2L)) {
            rendererState.style.fillRule = style2.fillRule;
        }
        if (this.isSpecified(style2, 8L)) {
            rendererState.style.stroke = style2.stroke;
            boolean bl3 = rendererState.hasStroke = style2.stroke != null && style2.stroke != SVG.Colour.TRANSPARENT;
        }
        if (this.isSpecified(style2, 16L)) {
            rendererState.style.strokeOpacity = style2.strokeOpacity;
        }
        if (this.isSpecified(style2, 6168L)) {
            this.setPaintColour(rendererState, false, rendererState.style.stroke);
        }
        if (this.isSpecified(style2, 0x800000000L)) {
            rendererState.style.vectorEffect = style2.vectorEffect;
        }
        if (this.isSpecified(style2, 32L)) {
            rendererState.style.strokeWidth = style2.strokeWidth;
            rendererState.strokePaint.setStrokeWidth(rendererState.style.strokeWidth.floatValue(this));
        }
        if (this.isSpecified(style2, 64L)) {
            rendererState.style.strokeLineCap = style2.strokeLineCap;
            switch (style2.strokeLineCap) {
                case Butt: {
                    rendererState.strokePaint.setStrokeCap(Paint.Cap.BUTT);
                    break;
                }
                case Round: {
                    rendererState.strokePaint.setStrokeCap(Paint.Cap.ROUND);
                    break;
                }
                case Square: {
                    rendererState.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
                }
            }
        }
        if (this.isSpecified(style2, 128L)) {
            rendererState.style.strokeLineJoin = style2.strokeLineJoin;
            switch (style2.strokeLineJoin) {
                case Miter: {
                    rendererState.strokePaint.setStrokeJoin(Paint.Join.MITER);
                    break;
                }
                case Round: {
                    rendererState.strokePaint.setStrokeJoin(Paint.Join.ROUND);
                    break;
                }
                case Bevel: {
                    rendererState.strokePaint.setStrokeJoin(Paint.Join.BEVEL);
                }
            }
        }
        if (this.isSpecified(style2, 256L)) {
            rendererState.style.strokeMiterLimit = style2.strokeMiterLimit;
            rendererState.strokePaint.setStrokeMiter(style2.strokeMiterLimit.floatValue());
        }
        if (this.isSpecified(style2, 512L)) {
            rendererState.style.strokeDashArray = style2.strokeDashArray;
        }
        if (this.isSpecified(style2, 1024L)) {
            rendererState.style.strokeDashOffset = style2.strokeDashOffset;
        }
        if (this.isSpecified(style2, 1536L)) {
            if (rendererState.style.strokeDashArray == null) {
                rendererState.strokePaint.setPathEffect(null);
            } else {
                f2 = 0.0f;
                int n2 = rendererState.style.strokeDashArray.length;
                int n3 = n2 % 2 == 0 ? n2 : n2 * 2;
                object = new float[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    object[i2] = rendererState.style.strokeDashArray[i2 % n2].floatValue(this);
                    f2 += object[i2];
                }
                if (f2 == 0.0f) {
                    rendererState.strokePaint.setPathEffect(null);
                } else {
                    float f3;
                    float f4 = rendererState.style.strokeDashOffset.floatValue(this);
                    if (f3 < 0.0f) {
                        f4 = f2 + f4 % f2;
                    }
                    rendererState.strokePaint.setPathEffect((PathEffect)new DashPathEffect((float[])object, f4));
                }
            }
        }
        if (this.isSpecified(style2, 16384L)) {
            f2 = this.getCurrentFontSize();
            rendererState.style.fontSize = style2.fontSize;
            rendererState.fillPaint.setTextSize(style2.fontSize.floatValue(this, f2));
            rendererState.strokePaint.setTextSize(style2.fontSize.floatValue(this, f2));
        }
        if (this.isSpecified(style2, 8192L)) {
            rendererState.style.fontFamily = style2.fontFamily;
        }
        if (this.isSpecified(style2, 32768L)) {
            rendererState.style.fontWeight = style2.fontWeight == -1 && rendererState.style.fontWeight > 100 ? Integer.valueOf(rendererState.style.fontWeight - 100) : (style2.fontWeight == 1 && rendererState.style.fontWeight < 900 ? Integer.valueOf(rendererState.style.fontWeight + 100) : style2.fontWeight);
        }
        if (this.isSpecified(style2, 65536L)) {
            rendererState.style.fontStyle = style2.fontStyle;
        }
        if (this.isSpecified(style2, 106496L)) {
            Typeface typeface = null;
            if (rendererState.style.fontFamily != null && this.document != null) {
                SVGExternalFileResolver sVGExternalFileResolver = SVG.getFileResolver();
                object = rendererState.style.fontFamily.iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    typeface = this.checkGenericFont(string2, rendererState.style.fontWeight, rendererState.style.fontStyle);
                    if (typeface == null && sVGExternalFileResolver != null) {
                        typeface = sVGExternalFileResolver.resolveFont(string2, rendererState.style.fontWeight, String.valueOf((Object)rendererState.style.fontStyle));
                    }
                    if (typeface == null) continue;
                }
            }
            if (typeface == null) {
                typeface = this.checkGenericFont(DEFAULT_FONT_FAMILY, rendererState.style.fontWeight, rendererState.style.fontStyle);
            }
            rendererState.fillPaint.setTypeface(typeface);
            rendererState.strokePaint.setTypeface(typeface);
        }
        if (this.isSpecified(style2, 131072L)) {
            rendererState.style.textDecoration = style2.textDecoration;
            rendererState.fillPaint.setStrikeThruText(style2.textDecoration == SVG.Style.TextDecoration.LineThrough);
            rendererState.fillPaint.setUnderlineText(style2.textDecoration == SVG.Style.TextDecoration.Underline);
            if (Build.VERSION.SDK_INT >= 17) {
                rendererState.strokePaint.setStrikeThruText(style2.textDecoration == SVG.Style.TextDecoration.LineThrough);
                rendererState.strokePaint.setUnderlineText(style2.textDecoration == SVG.Style.TextDecoration.Underline);
            }
        }
        if (this.isSpecified(style2, 0x1000000000L)) {
            rendererState.style.direction = style2.direction;
        }
        if (this.isSpecified(style2, 262144L)) {
            rendererState.style.textAnchor = style2.textAnchor;
        }
        if (this.isSpecified(style2, 524288L)) {
            rendererState.style.overflow = style2.overflow;
        }
        if (this.isSpecified(style2, 0x200000L)) {
            rendererState.style.markerStart = style2.markerStart;
        }
        if (this.isSpecified(style2, 0x400000L)) {
            rendererState.style.markerMid = style2.markerMid;
        }
        if (this.isSpecified(style2, 0x800000L)) {
            rendererState.style.markerEnd = style2.markerEnd;
        }
        if (this.isSpecified(style2, 0x1000000L)) {
            rendererState.style.display = style2.display;
        }
        if (this.isSpecified(style2, 0x2000000L)) {
            rendererState.style.visibility = style2.visibility;
        }
        if (this.isSpecified(style2, 0x100000L)) {
            rendererState.style.clip = style2.clip;
        }
        if (this.isSpecified(style2, 0x10000000L)) {
            rendererState.style.clipPath = style2.clipPath;
        }
        if (this.isSpecified(style2, 0x20000000L)) {
            rendererState.style.clipRule = style2.clipRule;
        }
        if (this.isSpecified(style2, 0x40000000L)) {
            rendererState.style.mask = style2.mask;
        }
        if (this.isSpecified(style2, 0x4000000L)) {
            rendererState.style.stopColor = style2.stopColor;
        }
        if (this.isSpecified(style2, 0x8000000L)) {
            rendererState.style.stopOpacity = style2.stopOpacity;
        }
        if (this.isSpecified(style2, 0x200000000L)) {
            rendererState.style.viewportFill = style2.viewportFill;
        }
        if (this.isSpecified(style2, 0x400000000L)) {
            rendererState.style.viewportFillOpacity = style2.viewportFillOpacity;
        }
        if (this.isSpecified(style2, 0x2000000000L)) {
            rendererState.style.imageRendering = style2.imageRendering;
        }
    }

    private void setPaintColour(RendererState rendererState, boolean bl2, SVG.SvgPaint svgPaint) {
        int n2;
        float f2 = (bl2 ? rendererState.style.fillOpacity : rendererState.style.strokeOpacity).floatValue();
        if (svgPaint instanceof SVG.Colour) {
            n2 = ((SVG.Colour)svgPaint).colour;
        } else {
            if (!(svgPaint instanceof SVG.CurrentColor)) {
                return;
            }
            n2 = rendererState.style.color.colour;
        }
        n2 = SVGAndroidRenderer.colourWithOpacity(n2, f2);
        if (bl2) {
            rendererState.fillPaint.setColor(n2);
            return;
        }
        rendererState.strokePaint.setColor(n2);
    }

    @SuppressLint(value={"WrongConstant"})
    private Typeface checkGenericFont(String string2, Integer n2, SVG.Style.FontStyle fontStyle) {
        int n3;
        Typeface typeface = null;
        int n4 = n3 = fontStyle == SVG.Style.FontStyle.Italic ? 1 : 0;
        int n5 = n2 > 500 ? (n3 != 0 ? 3 : 1) : (n3 != 0 ? 2 : 0);
        n3 = -1;
        switch (string2.hashCode()) {
            case -1536685117: {
                if (!string2.equals("sans-serif")) break;
                n3 = 1;
                break;
            }
            case -1431958525: {
                if (!string2.equals("monospace")) break;
                n3 = 2;
                break;
            }
            case -1081737434: {
                if (!string2.equals("fantasy")) break;
                n3 = 4;
                break;
            }
            case 109326717: {
                if (!string2.equals(DEFAULT_FONT_FAMILY)) break;
                n3 = 0;
                break;
            }
            case 1126973893: {
                if (!string2.equals("cursive")) break;
                n3 = 3;
            }
        }
        switch (n3) {
            case 0: {
                typeface = Typeface.create((Typeface)Typeface.SERIF, (int)n5);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                typeface = Typeface.create((Typeface)Typeface.SANS_SERIF, (int)n5);
                break;
            }
            case 2: {
                typeface = Typeface.create((Typeface)Typeface.MONOSPACE, (int)n5);
            }
        }
        return typeface;
    }

    private static int clamp255(float f2) {
        int n2 = (int)(f2 * 256.0f);
        if (n2 < 0) {
            return 0;
        }
        if (n2 > 255) {
            return 255;
        }
        return n2;
    }

    private static int colourWithOpacity(int n2, float f2) {
        int n3 = Math.round((float)(n2 >> 24 & 0xFF) * f2);
        return (n3 < 0 ? 0 : (n3 > 255 ? 255 : n3)) << 24 | n2 & 0xFFFFFF;
    }

    private Path.FillType getFillTypeFromState() {
        if (this.state.style.fillRule != null && this.state.style.fillRule == SVG.Style.FillRule.EvenOdd) {
            return Path.FillType.EVEN_ODD;
        }
        return Path.FillType.WINDING;
    }

    private void setClipRect(float f2, float f3, float f4, float f5) {
        float f6 = f2;
        float f7 = f3;
        f4 = f2 + f4;
        f5 = f3 + f5;
        if (this.state.style.clip != null) {
            f6 = f2 + this.state.style.clip.left.floatValueX(this);
            f7 = f3 + this.state.style.clip.top.floatValueY(this);
            f4 -= this.state.style.clip.right.floatValueX(this);
            f5 -= this.state.style.clip.bottom.floatValueY(this);
        }
        this.canvas.clipRect(f6, f7, f4, f5);
    }

    private void viewportFill() {
        int n2;
        if (this.state.style.viewportFill instanceof SVG.Colour) {
            n2 = ((SVG.Colour)this.state.style.viewportFill).colour;
        } else {
            if (!(this.state.style.viewportFill instanceof SVG.CurrentColor)) {
                return;
            }
            n2 = this.state.style.color.colour;
        }
        if (this.state.style.viewportFillOpacity != null) {
            n2 = SVGAndroidRenderer.colourWithOpacity(n2, this.state.style.viewportFillOpacity.floatValue());
        }
        this.canvas.drawColor(n2);
    }

    private static void arcTo(float f2, float f3, float f4, float f5, float f6, boolean bl2, boolean bl3, float f7, float f8, SVG.PathInterface pathInterface) {
        if (f2 != f7 || f3 != f8) {
            if (f4 != 0.0f && f5 != 0.0f) {
                double d2;
                double d3;
                double d4;
                f4 = Math.abs(f4);
                f5 = Math.abs(f5);
                double d5 = Math.toRadians((double)f6 % 360.0);
                double d6 = Math.cos(d5);
                double d7 = Math.sin(d5);
                double d8 = (double)(f2 - f7) / 2.0;
                double d9 = (double)(f3 - f8) / 2.0;
                double d10 = d6 * d8 + d7 * d9;
                double d11 = -d7 * d8 + d6 * d9;
                float f9 = f4;
                double d12 = f9 * f9;
                float f10 = f5;
                double d13 = f10 * f10;
                double d14 = d10;
                double d15 = d14 * d14;
                double d16 = d11;
                double d17 = d16 * d16;
                double d18 = d15 / d12 + d17 / d13;
                if (d4 > 0.99999) {
                    d3 = Math.sqrt(d18) * 1.00001;
                    f4 = (float)(d3 * (double)f4);
                    f5 = (float)(d3 * (double)f5);
                    float f11 = f4;
                    d12 = f11 * f11;
                    float f12 = f5;
                    d13 = f12 * f12;
                }
                d3 = bl2 == bl3 ? -1.0 : 1.0;
                double d19 = (d12 * d13 - d12 * d17 - d13 * d15) / (d12 * d17 + d13 * d15);
                d19 = d2 < 0.0 ? 0.0 : d19;
                double d20 = d3 * Math.sqrt(d19);
                double d21 = d20 * ((double)f4 * d11 / (double)f5);
                double d22 = d20 * -((double)f5 * d10 / (double)f4);
                double d23 = (double)(f2 + f7) / 2.0;
                double d24 = (double)(f3 + f8) / 2.0;
                double d25 = d23 + (d6 * d21 - d7 * d22);
                double d26 = d24 + d7 * d21 + d6 * d22;
                double d27 = (d10 - d21) / (double)f4;
                double d28 = (d11 - d22) / (double)f5;
                double d29 = (-d10 - d21) / (double)f4;
                double d30 = (-d11 - d22) / (double)f5;
                double d31 = d27;
                double d32 = d28;
                double d33 = Math.sqrt(d31 * d31 + d32 * d32);
                double d34 = (d28 < 0.0 ? -1.0 : 1.0) * Math.acos(d27 / d33);
                double d35 = d27;
                double d36 = d28;
                double d37 = d29;
                double d38 = d30;
                d33 = Math.sqrt((d35 * d35 + d36 * d36) * (d37 * d37 + d38 * d38));
                double d39 = d27 * d29 + d28 * d30;
                double d40 = (d27 * d30 - d28 * d29 < 0.0 ? -1.0 : 1.0) * SVGAndroidRenderer.checkedArcCos(d39 / d33);
                if (!bl3 && d40 > 0.0) {
                    d40 -= Math.PI * 2;
                } else if (bl3 && d40 < 0.0) {
                    d40 += Math.PI * 2;
                }
                float[] fArray = SVGAndroidRenderer.arcToBeziers(d34 % (Math.PI * 2), d40 %= Math.PI * 2);
                Matrix matrix = new Matrix();
                matrix.postScale(f4, f5);
                matrix.postRotate(f6);
                matrix.postTranslate((float)d25, (float)d26);
                matrix.mapPoints(fArray);
                fArray[fArray.length - 2] = f7;
                fArray[fArray.length - 1] = f8;
                for (int i2 = 0; i2 < fArray.length; i2 += 6) {
                    pathInterface.cubicTo(fArray[i2], fArray[i2 + 1], fArray[i2 + 2], fArray[i2 + 3], fArray[i2 + 4], fArray[i2 + 5]);
                }
                return;
            }
            pathInterface.lineTo(f7, f8);
        }
    }

    private static double checkedArcCos(double d2) {
        if (d2 < -1.0) {
            return Math.PI;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        return Math.acos(d2);
    }

    private static float[] arcToBeziers(double d2, double d3) {
        int n2 = (int)Math.ceil(Math.abs(d3) * 2.0 / Math.PI);
        double d4 = d3 / (double)n2;
        double d5 = 1.3333333333333333 * Math.sin(d4 / 2.0) / (1.0 + Math.cos(d4 / 2.0));
        float[] fArray = new float[n2 * 6];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d6 = d2 + (double)i2 * d4;
            double d7 = Math.cos(d6);
            double d8 = Math.sin(d6);
            fArray[n3++] = (float)(d7 - d5 * d8);
            fArray[n3++] = (float)(d8 + d5 * d7);
            d7 = Math.cos(d6 += d4);
            d8 = Math.sin(d6);
            fArray[n3++] = (float)(d7 + d5 * d8);
            fArray[n3++] = (float)(d8 - d5 * d7);
            fArray[n3++] = (float)d7;
            fArray[n3++] = (float)d8;
        }
        return fArray;
    }

    private void renderMarkers(SVG.GraphicsElement list) {
        if (this.state.style.markerStart != null || this.state.style.markerMid != null || this.state.style.markerEnd != null) {
            int n2;
            SVG.SvgObject svgObject;
            Object object = null;
            SVG.Marker marker = null;
            SVG.Marker marker2 = null;
            if (this.state.style.markerStart != null) {
                svgObject = ((SVG.GraphicsElement)((Object)list)).document.resolveIRI(this.state.style.markerStart);
                if (svgObject != null) {
                    object = (SVG.Marker)svgObject;
                } else {
                    SVGAndroidRenderer.error("Marker reference '%s' not found", this.state.style.markerStart);
                }
            }
            if (this.state.style.markerMid != null) {
                svgObject = ((SVG.GraphicsElement)((Object)list)).document.resolveIRI(this.state.style.markerMid);
                if (svgObject != null) {
                    marker = (SVG.Marker)svgObject;
                } else {
                    SVGAndroidRenderer.error("Marker reference '%s' not found", this.state.style.markerMid);
                }
            }
            if (this.state.style.markerEnd != null) {
                svgObject = ((SVG.GraphicsElement)((Object)list)).document.resolveIRI(this.state.style.markerEnd);
                if (svgObject != null) {
                    marker2 = (SVG.Marker)svgObject;
                } else {
                    SVGAndroidRenderer.error("Marker reference '%s' not found", this.state.style.markerEnd);
                }
            }
            if ((list = list instanceof SVG.Path ? new MarkerPositionCalculator(((SVG.Path)((Object)list)).d).getMarkers() : (list instanceof SVG.Line ? this.calculateMarkerPositions((SVG.Line)((Object)list)) : this.calculateMarkerPositions((SVG.PolyLine)((Object)list)))) != null && (n2 = list.size()) != 0) {
                this.state.style.markerEnd = null;
                this.state.style.markerMid = null;
                this.state.style.markerStart = null;
                if (object != null) {
                    this.renderMarker((SVG.Marker)object, list.get(0));
                }
                if (marker != null && list.size() > 2) {
                    object = list.get(0);
                    MarkerVector markerVector = list.get(1);
                    for (int i2 = 1; i2 < n2 - 1; ++i2) {
                        MarkerVector markerVector2 = list.get(i2 + 1);
                        if (markerVector.isAmbiguous) {
                            markerVector = this.realignMarkerMid((MarkerVector)object, markerVector, markerVector2);
                        }
                        this.renderMarker(marker, markerVector);
                        object = markerVector;
                        markerVector = markerVector2;
                    }
                }
                if (marker2 != null) {
                    this.renderMarker(marker2, list.get(n2 - 1));
                }
            }
        }
    }

    private MarkerVector realignMarkerMid(MarkerVector markerVector, MarkerVector markerVector2, MarkerVector markerVector3) {
        float f2 = this.dotProduct(markerVector2.dx, markerVector2.dy, markerVector2.x - markerVector.x, markerVector2.y - markerVector.y);
        if (f2 == 0.0f) {
            f2 = this.dotProduct(markerVector2.dx, markerVector2.dy, markerVector3.x - markerVector2.x, markerVector3.y - markerVector2.y);
        }
        if (f2 > 0.0f) {
            return markerVector2;
        }
        if (f2 != 0.0f || !(markerVector2.dx > 0.0f) && !(markerVector2.dy >= 0.0f)) {
            markerVector2.dx = -markerVector2.dx;
            markerVector2.dy = -markerVector2.dy;
            return markerVector2;
        }
        return markerVector2;
    }

    private float dotProduct(float f2, float f3, float f4, float f5) {
        return f2 * f4 + f3 * f5;
    }

    private void renderMarker(SVG.Marker marker, MarkerVector markerVector) {
        float f2;
        float f3 = 0.0f;
        this.statePush();
        if (marker.orient != null) {
            if (Float.isNaN(marker.orient.floatValue())) {
                if (markerVector.dx != 0.0f || markerVector.dy != 0.0f) {
                    f3 = (float)Math.toDegrees(Math.atan2(markerVector.dy, markerVector.dx));
                }
            } else {
                f3 = marker.orient.floatValue();
            }
        }
        float f4 = marker.markerUnitsAreUser ? 1.0f : this.state.style.strokeWidth.floatValue(this.dpi);
        this.state = this.findInheritFromAncestorState(marker);
        Matrix matrix = new Matrix();
        matrix.preTranslate(markerVector.x, markerVector.y);
        matrix.preRotate(f3);
        float f5 = f4;
        matrix.preScale(f5, f5);
        float f6 = marker.refX != null ? marker.refX.floatValueX(this) : 0.0f;
        f3 = marker.refY != null ? marker.refY.floatValueY(this) : 0.0f;
        f4 = marker.markerWidth != null ? marker.markerWidth.floatValueX(this) : 3.0f;
        float f7 = f2 = marker.markerHeight != null ? marker.markerHeight.floatValueY(this) : 3.0f;
        if (marker.viewBox != null) {
            float f8;
            float f9 = f4 / marker.viewBox.width;
            float f10 = f2 / marker.viewBox.height;
            PreserveAspectRatio preserveAspectRatio = marker.preserveAspectRatio != null ? marker.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
            if (!preserveAspectRatio.equals(PreserveAspectRatio.STRETCH)) {
                f8 = preserveAspectRatio.getScale() == PreserveAspectRatio.Scale.slice ? Math.max(f9, f10) : Math.min(f9, f10);
                f10 = f8;
                f9 = f8;
            }
            matrix.preTranslate(-f6 * f9, -f3 * f10);
            this.canvas.concat(matrix);
            f8 = marker.viewBox.width * f9;
            f6 = marker.viewBox.height * f10;
            f3 = 0.0f;
            float f11 = 0.0f;
            switch (preserveAspectRatio.getAlignment()) {
                case xMidYMin: 
                case xMidYMid: 
                case xMidYMax: {
                    f3 = 0.0f - (f4 - f8) / 2.0f;
                    break;
                }
                case xMaxYMin: 
                case xMaxYMid: 
                case xMaxYMax: {
                    f3 = 0.0f - (f4 - f8);
                }
            }
            switch (preserveAspectRatio.getAlignment()) {
                case xMidYMid: 
                case xMaxYMid: 
                case xMinYMid: {
                    f11 = 0.0f - (f2 - f6) / 2.0f;
                    break;
                }
                case xMidYMax: 
                case xMaxYMax: 
                case xMinYMax: {
                    f11 = 0.0f - (f2 - f6);
                }
            }
            if (!this.state.style.overflow.booleanValue()) {
                this.setClipRect(f3, f11, f4, f2);
            }
            matrix.reset();
            matrix.preScale(f9, f10);
            this.canvas.concat(matrix);
        } else {
            matrix.preTranslate(-f6, -f3);
            this.canvas.concat(matrix);
            if (!this.state.style.overflow.booleanValue()) {
                this.setClipRect(0.0f, 0.0f, f4, f2);
            }
        }
        boolean bl2 = this.pushLayer();
        this.renderChildren(marker, false);
        if (bl2) {
            this.popLayer(marker);
        }
        this.statePop();
    }

    private RendererState findInheritFromAncestorState(SVG.SvgObject svgObject) {
        RendererState rendererState = new RendererState();
        this.updateStyle(rendererState, SVG.Style.getDefaultStyle());
        return this.findInheritFromAncestorState(svgObject, rendererState);
    }

    private RendererState findInheritFromAncestorState(SVG.SvgObject object, RendererState rendererState) {
        Object object2 = new ArrayList<SVG.SvgElementBase>();
        while (true) {
            if (object instanceof SVG.SvgElementBase) {
                ((ArrayList)object2).add(0, (SVG.SvgElementBase)object);
            }
            if (((SVG.SvgObject)object).parent == null) {
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    object2 = (SVG.SvgElementBase)object.next();
                    this.updateStyleForElement(rendererState, (SVG.SvgElementBase)object2);
                }
                rendererState.viewBox = this.state.viewBox;
                rendererState.viewPort = this.state.viewPort;
                return rendererState;
            }
            object = (SVG.SvgObject)((Object)((SVG.SvgObject)object).parent);
        }
    }

    private void checkForGradientsAndPatterns(SVG.SvgElement svgElement) {
        if (this.state.style.fill instanceof SVG.PaintReference) {
            this.decodePaintReference(true, svgElement.boundingBox, (SVG.PaintReference)this.state.style.fill);
        }
        if (this.state.style.stroke instanceof SVG.PaintReference) {
            this.decodePaintReference(false, svgElement.boundingBox, (SVG.PaintReference)this.state.style.stroke);
        }
    }

    private void decodePaintReference(boolean bl2, SVG.Box box, SVG.PaintReference paintReference) {
        SVG.SvgObject svgObject = this.document.resolveIRI(paintReference.href);
        if (svgObject == null) {
            SVGAndroidRenderer.error("%s reference '%s' not found", bl2 ? "Fill" : "Stroke", paintReference.href);
            if (paintReference.fallback != null) {
                SVGAndroidRenderer sVGAndroidRenderer = this;
                sVGAndroidRenderer.setPaintColour(sVGAndroidRenderer.state, bl2, paintReference.fallback);
                return;
            }
            if (bl2) {
                this.state.hasFill = false;
                return;
            }
            this.state.hasStroke = false;
            return;
        }
        if (svgObject instanceof SVG.SvgLinearGradient) {
            this.makeLinearGradient(bl2, box, (SVG.SvgLinearGradient)svgObject);
            return;
        }
        if (svgObject instanceof SVG.SvgRadialGradient) {
            this.makeRadialGradient(bl2, box, (SVG.SvgRadialGradient)svgObject);
            return;
        }
        if (svgObject instanceof SVG.SolidColor) {
            this.setSolidColor(bl2, (SVG.SolidColor)svgObject);
        }
    }

    private void makeLinearGradient(boolean bl2, SVG.Box box, SVG.SvgLinearGradient svgLinearGradient) {
        Object object;
        int n2;
        float f2;
        float f3;
        float f4;
        float f5;
        SVG.Box box2;
        Paint paint;
        if (svgLinearGradient.href != null) {
            SVG.SvgLinearGradient svgLinearGradient2 = svgLinearGradient;
            this.fillInChainedGradientFields((SVG.GradientElement)svgLinearGradient2, svgLinearGradient2.href);
        }
        boolean bl3 = svgLinearGradient.gradientUnitsAreUser != null && svgLinearGradient.gradientUnitsAreUser != false;
        Paint paint2 = paint = bl2 ? this.state.fillPaint : this.state.strokePaint;
        if (bl3) {
            box2 = this.getCurrentViewPortInUserUnits();
            f5 = svgLinearGradient.x1 != null ? svgLinearGradient.x1.floatValueX(this) : 0.0f;
            f4 = svgLinearGradient.y1 != null ? svgLinearGradient.y1.floatValueY(this) : 0.0f;
            f3 = svgLinearGradient.x2 != null ? svgLinearGradient.x2.floatValueX(this) : box2.width;
            f2 = svgLinearGradient.y2 != null ? svgLinearGradient.y2.floatValueY(this) : 0.0f;
        } else {
            f5 = svgLinearGradient.x1 != null ? svgLinearGradient.x1.floatValue(this, 1.0f) : 0.0f;
            f4 = svgLinearGradient.y1 != null ? svgLinearGradient.y1.floatValue(this, 1.0f) : 0.0f;
            f3 = svgLinearGradient.x2 != null ? svgLinearGradient.x2.floatValue(this, 1.0f) : 1.0f;
            f2 = svgLinearGradient.y2 != null ? svgLinearGradient.y2.floatValue(this, 1.0f) : 0.0f;
        }
        this.statePush();
        this.state = this.findInheritFromAncestorState(svgLinearGradient);
        box2 = new Matrix();
        if (!bl3) {
            box2.preTranslate(box.minX, box.minY);
            box2.preScale(box.width, box.height);
        }
        if (svgLinearGradient.gradientTransform != null) {
            box2.preConcat(svgLinearGradient.gradientTransform);
        }
        if ((n2 = svgLinearGradient.children.size()) == 0) {
            this.statePop();
            if (bl2) {
                this.state.hasFill = false;
                return;
            }
            this.state.hasStroke = false;
            return;
        }
        int[] nArray = new int[n2];
        float[] fArray = new float[n2];
        int n3 = 0;
        float f6 = -1.0f;
        Iterator iterator = svgLinearGradient.children.iterator();
        while (iterator.hasNext()) {
            float f7;
            object = (SVG.Stop)((SVG.SvgObject)iterator.next());
            float f8 = f7 = ((SVG.Stop)object).offset != null ? ((SVG.Stop)object).offset.floatValue() : 0.0f;
            if (n3 != 0 && !(f7 >= f6)) {
                fArray[n3] = f6;
            } else {
                fArray[n3] = f7;
                f6 = f7;
            }
            this.statePush();
            SVGAndroidRenderer sVGAndroidRenderer = this;
            sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, (SVG.SvgElementBase)object);
            object = (SVG.Colour)this.state.style.stopColor;
            if (object == null) {
                object = SVG.Colour.BLACK;
            }
            nArray[n3] = SVGAndroidRenderer.colourWithOpacity(((SVG.Colour)object).colour, this.state.style.stopOpacity.floatValue());
            ++n3;
            this.statePop();
        }
        if ((f5 != f3 || f4 != f2) && n2 != 1) {
            object = Shader.TileMode.CLAMP;
            if (svgLinearGradient.spreadMethod != null) {
                if (svgLinearGradient.spreadMethod == SVG.GradientSpread.reflect) {
                    object = Shader.TileMode.MIRROR;
                } else if (svgLinearGradient.spreadMethod == SVG.GradientSpread.repeat) {
                    object = Shader.TileMode.REPEAT;
                }
            }
            this.statePop();
            object = new LinearGradient(f5, f4, f3, f2, nArray, fArray, (Shader.TileMode)object);
            object.setLocalMatrix((Matrix)box2);
            paint.setShader((Shader)object);
            paint.setAlpha(SVGAndroidRenderer.clamp255(this.state.style.fillOpacity.floatValue()));
            return;
        }
        this.statePop();
        paint.setColor(nArray[n2 - 1]);
    }

    private void makeRadialGradient(boolean bl2, SVG.Box box, SVG.SvgRadialGradient svgRadialGradient) {
        Object object;
        int n2;
        float f2;
        float f3;
        float f4;
        SVG.Length length;
        Paint paint;
        if (svgRadialGradient.href != null) {
            SVG.SvgRadialGradient svgRadialGradient2 = svgRadialGradient;
            this.fillInChainedGradientFields((SVG.GradientElement)svgRadialGradient2, svgRadialGradient2.href);
        }
        boolean bl3 = svgRadialGradient.gradientUnitsAreUser != null && svgRadialGradient.gradientUnitsAreUser != false;
        Paint paint2 = paint = bl2 ? this.state.fillPaint : this.state.strokePaint;
        if (bl3) {
            length = new SVG.Length(50.0f, SVG.Unit.percent);
            f4 = svgRadialGradient.cx != null ? svgRadialGradient.cx.floatValueX(this) : length.floatValueX(this);
            f3 = svgRadialGradient.cy != null ? svgRadialGradient.cy.floatValueY(this) : length.floatValueY(this);
            f2 = svgRadialGradient.r != null ? svgRadialGradient.r.floatValue(this) : length.floatValue(this);
        } else {
            f4 = svgRadialGradient.cx != null ? svgRadialGradient.cx.floatValue(this, 1.0f) : 0.5f;
            f3 = svgRadialGradient.cy != null ? svgRadialGradient.cy.floatValue(this, 1.0f) : 0.5f;
            f2 = svgRadialGradient.r != null ? svgRadialGradient.r.floatValue(this, 1.0f) : 0.5f;
        }
        this.statePush();
        this.state = this.findInheritFromAncestorState(svgRadialGradient);
        length = new Matrix();
        if (!bl3) {
            length.preTranslate(box.minX, box.minY);
            length.preScale(box.width, box.height);
        }
        if (svgRadialGradient.gradientTransform != null) {
            length.preConcat(svgRadialGradient.gradientTransform);
        }
        if ((n2 = svgRadialGradient.children.size()) == 0) {
            this.statePop();
            if (bl2) {
                this.state.hasFill = false;
                return;
            }
            this.state.hasStroke = false;
            return;
        }
        int[] nArray = new int[n2];
        float[] fArray = new float[n2];
        int n3 = 0;
        float f5 = -1.0f;
        Iterator iterator = svgRadialGradient.children.iterator();
        while (iterator.hasNext()) {
            float f6;
            object = (SVG.Stop)((SVG.SvgObject)iterator.next());
            float f7 = f6 = ((SVG.Stop)object).offset != null ? ((SVG.Stop)object).offset.floatValue() : 0.0f;
            if (n3 != 0 && !(f6 >= f5)) {
                fArray[n3] = f5;
            } else {
                fArray[n3] = f6;
                f5 = f6;
            }
            this.statePush();
            SVGAndroidRenderer sVGAndroidRenderer = this;
            sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, (SVG.SvgElementBase)object);
            object = (SVG.Colour)this.state.style.stopColor;
            if (object == null) {
                object = SVG.Colour.BLACK;
            }
            nArray[n3] = SVGAndroidRenderer.colourWithOpacity(((SVG.Colour)object).colour, this.state.style.stopOpacity.floatValue());
            ++n3;
            this.statePop();
        }
        if (f2 != 0.0f && n2 != 1) {
            object = Shader.TileMode.CLAMP;
            if (svgRadialGradient.spreadMethod != null) {
                if (svgRadialGradient.spreadMethod == SVG.GradientSpread.reflect) {
                    object = Shader.TileMode.MIRROR;
                } else if (svgRadialGradient.spreadMethod == SVG.GradientSpread.repeat) {
                    object = Shader.TileMode.REPEAT;
                }
            }
            this.statePop();
            object = new RadialGradient(f4, f3, f2, nArray, fArray, (Shader.TileMode)object);
            object.setLocalMatrix((Matrix)length);
            paint.setShader((Shader)object);
            paint.setAlpha(SVGAndroidRenderer.clamp255(this.state.style.fillOpacity.floatValue()));
            return;
        }
        this.statePop();
        paint.setColor(nArray[n2 - 1]);
    }

    private void fillInChainedGradientFields(SVG.GradientElement gradientElement, String object) {
        SVG.SvgObject svgObject = gradientElement.document.resolveIRI((String)object);
        if (svgObject == null) {
            SVGAndroidRenderer.warn("Gradient reference '%s' not found", object);
            return;
        }
        if (!(svgObject instanceof SVG.GradientElement)) {
            SVGAndroidRenderer.error("Gradient href attributes must point to other gradient elements", new Object[0]);
            return;
        }
        if (svgObject == gradientElement) {
            SVGAndroidRenderer.error("Circular reference in gradient href attribute '%s'", object);
            return;
        }
        object = (SVG.GradientElement)svgObject;
        if (gradientElement.gradientUnitsAreUser == null) {
            gradientElement.gradientUnitsAreUser = ((SVG.GradientElement)object).gradientUnitsAreUser;
        }
        if (gradientElement.gradientTransform == null) {
            gradientElement.gradientTransform = ((SVG.GradientElement)object).gradientTransform;
        }
        if (gradientElement.spreadMethod == null) {
            gradientElement.spreadMethod = ((SVG.GradientElement)object).spreadMethod;
        }
        if (gradientElement.children.isEmpty()) {
            gradientElement.children = ((SVG.GradientElement)object).children;
        }
        try {
            if (gradientElement instanceof SVG.SvgLinearGradient) {
                this.fillInChainedGradientFields((SVG.SvgLinearGradient)gradientElement, (SVG.SvgLinearGradient)svgObject);
            } else {
                this.fillInChainedGradientFields((SVG.SvgRadialGradient)gradientElement, (SVG.SvgRadialGradient)svgObject);
            }
        }
        catch (ClassCastException classCastException) {}
        if (((SVG.GradientElement)object).href != null) {
            this.fillInChainedGradientFields(gradientElement, ((SVG.GradientElement)object).href);
        }
    }

    private void fillInChainedGradientFields(SVG.SvgLinearGradient svgLinearGradient, SVG.SvgLinearGradient svgLinearGradient2) {
        if (svgLinearGradient.x1 == null) {
            svgLinearGradient.x1 = svgLinearGradient2.x1;
        }
        if (svgLinearGradient.y1 == null) {
            svgLinearGradient.y1 = svgLinearGradient2.y1;
        }
        if (svgLinearGradient.x2 == null) {
            svgLinearGradient.x2 = svgLinearGradient2.x2;
        }
        if (svgLinearGradient.y2 == null) {
            svgLinearGradient.y2 = svgLinearGradient2.y2;
        }
    }

    private void fillInChainedGradientFields(SVG.SvgRadialGradient svgRadialGradient, SVG.SvgRadialGradient svgRadialGradient2) {
        if (svgRadialGradient.cx == null) {
            svgRadialGradient.cx = svgRadialGradient2.cx;
        }
        if (svgRadialGradient.cy == null) {
            svgRadialGradient.cy = svgRadialGradient2.cy;
        }
        if (svgRadialGradient.r == null) {
            svgRadialGradient.r = svgRadialGradient2.r;
        }
        if (svgRadialGradient.fx == null) {
            svgRadialGradient.fx = svgRadialGradient2.fx;
        }
        if (svgRadialGradient.fy == null) {
            svgRadialGradient.fy = svgRadialGradient2.fy;
        }
    }

    private void setSolidColor(boolean bl2, SVG.SolidColor solidColor) {
        if (bl2) {
            if (this.isSpecified(solidColor.baseStyle, 0x80000000L)) {
                this.state.style.fill = solidColor.baseStyle.solidColor;
                boolean bl3 = this.state.hasFill = solidColor.baseStyle.solidColor != null;
            }
            if (this.isSpecified(solidColor.baseStyle, 0x100000000L)) {
                this.state.style.fillOpacity = solidColor.baseStyle.solidOpacity;
            }
            if (this.isSpecified(solidColor.baseStyle, 0x180000000L)) {
                SVGAndroidRenderer sVGAndroidRenderer = this;
                sVGAndroidRenderer.setPaintColour(sVGAndroidRenderer.state, bl2, this.state.style.fill);
                return;
            }
        } else {
            if (this.isSpecified(solidColor.baseStyle, 0x80000000L)) {
                this.state.style.stroke = solidColor.baseStyle.solidColor;
                boolean bl4 = this.state.hasStroke = solidColor.baseStyle.solidColor != null;
            }
            if (this.isSpecified(solidColor.baseStyle, 0x100000000L)) {
                this.state.style.strokeOpacity = solidColor.baseStyle.solidOpacity;
            }
            if (this.isSpecified(solidColor.baseStyle, 0x180000000L)) {
                SVGAndroidRenderer sVGAndroidRenderer = this;
                sVGAndroidRenderer.setPaintColour(sVGAndroidRenderer.state, bl2, this.state.style.stroke);
            }
        }
    }

    private void checkForClipPath(SVG.SvgElement svgElement) {
        SVG.SvgElement svgElement2 = svgElement;
        this.checkForClipPath(svgElement2, svgElement2.boundingBox);
    }

    private void checkForClipPath(SVG.SvgElement svgElement, SVG.Box box) {
        if (this.state.style.clipPath != null) {
            if (Build.VERSION.SDK_INT >= 19) {
                if ((svgElement = this.calculateClipPath(svgElement, box)) != null) {
                    this.canvas.clipPath((Path)svgElement);
                }
                return;
            }
            this.checkForClipPath_OldStyle(svgElement, box);
        }
    }

    @TargetApi(value=19)
    private Path calculateClipPath(SVG.SvgElement svgObject, SVG.Box box) {
        svgObject = svgObject.document.resolveIRI(this.state.style.clipPath);
        if (svgObject == null) {
            SVGAndroidRenderer.error("ClipPath reference '%s' not found", this.state.style.clipPath);
            return null;
        }
        svgObject = (SVG.ClipPath)svgObject;
        this.stateStack.push(this.state);
        this.state = this.findInheritFromAncestorState(svgObject);
        boolean bl2 = ((SVG.ClipPath)svgObject).clipPathUnitsAreUser == null || ((SVG.ClipPath)svgObject).clipPathUnitsAreUser != false;
        Matrix matrix = new Matrix();
        if (!bl2) {
            matrix.preTranslate(box.minX, box.minY);
            matrix.preScale(box.width, box.height);
        }
        if (((SVG.ClipPath)svgObject).transform != null) {
            matrix.preConcat(((SVG.ClipPath)svgObject).transform);
        }
        box = new Path();
        for (SVG.SvgObject svgObject2 : ((SVG.ClipPath)svgObject).children) {
            if (!(svgObject2 instanceof SVG.SvgElement) || (svgObject2 = this.objectToPath((SVG.SvgElement)svgObject2, true)) == null) continue;
            box.op((Path)svgObject2, Path.Op.UNION);
        }
        if (this.state.style.clipPath != null) {
            SVG.SvgObject svgObject2;
            if (((SVG.ClipPath)svgObject).boundingBox == null) {
                ((SVG.ClipPath)svgObject).boundingBox = this.calculatePathBounds((Path)box);
            }
            SVG.SvgObject svgObject3 = svgObject;
            svgObject2 = this.calculateClipPath((SVG.SvgElement)svgObject3, ((SVG.ClipPath)svgObject3).boundingBox);
            if (svgObject2 != null) {
                box.op((Path)svgObject2, Path.Op.INTERSECT);
            }
        }
        box.transform(matrix);
        this.state = this.stateStack.pop();
        return box;
    }

    @TargetApi(value=19)
    private Path objectToPath(SVG.SvgElement svgElement, boolean bl2) {
        this.stateStack.push(this.state);
        SVGAndroidRenderer sVGAndroidRenderer = this;
        this.state = sVGAndroidRenderer.new RendererState(sVGAndroidRenderer.state);
        SVGAndroidRenderer sVGAndroidRenderer2 = this;
        sVGAndroidRenderer2.updateStyleForElement(sVGAndroidRenderer2.state, svgElement);
        if (this.display() && this.visible()) {
            SVG.SvgElement svgElement2;
            SVG.SvgObject svgObject = null;
            if (svgElement instanceof SVG.Use) {
                if (!bl2) {
                    SVGAndroidRenderer.error("<use> elements inside a <clipPath> cannot reference another <use>", new Object[0]);
                }
                svgElement2 = (SVG.Use)svgElement;
                svgObject = svgElement.document.resolveIRI(svgElement2.href);
                if (svgObject == null) {
                    SVGAndroidRenderer.error("Use reference '%s' not found", svgElement2.href);
                    this.state = this.stateStack.pop();
                    return null;
                }
                if (!(svgObject instanceof SVG.SvgElement)) {
                    this.state = this.stateStack.pop();
                    return null;
                }
                if ((svgObject = this.objectToPath((SVG.SvgElement)svgObject, false)) == null) {
                    return null;
                }
                if (svgElement2.boundingBox == null) {
                    svgElement2.boundingBox = this.calculatePathBounds((Path)svgObject);
                }
                if (svgElement2.transform != null) {
                    svgObject.transform(svgElement2.transform);
                }
            } else if (svgElement instanceof SVG.GraphicsElement) {
                svgElement2 = (SVG.GraphicsElement)svgElement;
                if (svgElement instanceof SVG.Path) {
                    svgObject = (SVG.Path)svgElement;
                    svgObject = new PathConverter(((SVG.Path)svgObject).d).getPath();
                    if (svgElement.boundingBox == null) {
                        svgElement.boundingBox = this.calculatePathBounds((Path)svgObject);
                    }
                } else if (svgElement instanceof SVG.Rect) {
                    svgObject = this.makePathAndBoundingBox((SVG.Rect)svgElement);
                } else if (svgElement instanceof SVG.Circle) {
                    svgObject = this.makePathAndBoundingBox((SVG.Circle)svgElement);
                } else if (svgElement instanceof SVG.Ellipse) {
                    svgObject = this.makePathAndBoundingBox((SVG.Ellipse)svgElement);
                } else if (svgElement instanceof SVG.PolyLine) {
                    svgObject = this.makePathAndBoundingBox((SVG.PolyLine)svgElement);
                }
                if (svgObject == null) {
                    return null;
                }
                if (((SVG.GraphicsElement)svgElement2).boundingBox == null) {
                    ((SVG.GraphicsElement)svgElement2).boundingBox = this.calculatePathBounds((Path)svgObject);
                }
                if (((SVG.GraphicsElement)svgElement2).transform != null) {
                    svgObject.transform(((SVG.GraphicsElement)svgElement2).transform);
                }
                svgObject.setFillType(this.getClipRuleFromState());
            } else {
                if (!(svgElement instanceof SVG.Text)) {
                    SVGAndroidRenderer.error("Invalid %s element found in clipPath definition", svgElement.getNodeName());
                    return null;
                }
                svgElement2 = (SVG.Text)svgElement;
                svgObject = this.makePathAndBoundingBox((SVG.Text)svgElement2);
                if (svgObject == null) {
                    return null;
                }
                if (((SVG.Text)svgElement2).transform != null) {
                    svgObject.transform(((SVG.Text)svgElement2).transform);
                }
                svgObject.setFillType(this.getClipRuleFromState());
            }
            if (this.state.style.clipPath != null) {
                SVG.SvgElement svgElement3 = svgElement;
                svgElement2 = this.calculateClipPath(svgElement3, svgElement3.boundingBox);
                if (svgElement2 != null) {
                    svgObject.op((Path)svgElement2, Path.Op.INTERSECT);
                }
            }
            this.state = this.stateStack.pop();
            return svgObject;
        }
        this.state = this.stateStack.pop();
        return null;
    }

    private void checkForClipPath_OldStyle(SVG.SvgElement svgElement, SVG.Box object) {
        boolean bl2;
        SVG.SvgObject svgObject2 = svgElement.document.resolveIRI(this.state.style.clipPath);
        if (svgObject2 == null) {
            SVGAndroidRenderer.error("ClipPath reference '%s' not found", this.state.style.clipPath);
            return;
        }
        svgObject2 = (SVG.ClipPath)svgObject2;
        if (((SVG.ClipPath)svgObject2).children.isEmpty()) {
            this.canvas.clipRect(0, 0, 0, 0);
            return;
        }
        boolean bl3 = bl2 = ((SVG.ClipPath)svgObject2).clipPathUnitsAreUser == null || ((SVG.ClipPath)svgObject2).clipPathUnitsAreUser != false;
        if (svgElement instanceof SVG.Group && !bl2) {
            SVGAndroidRenderer.warn("<clipPath clipPathUnits=\"objectBoundingBox\"> is not supported when referenced from container elements (like %s)", svgElement.getNodeName());
            return;
        }
        this.clipStatePush();
        if (!bl2) {
            svgElement = new Matrix();
            svgElement.preTranslate(((SVG.Box)object).minX, ((SVG.Box)object).minY);
            svgElement.preScale(((SVG.Box)object).width, ((SVG.Box)object).height);
            this.canvas.concat((Matrix)svgElement);
        }
        if (((SVG.ClipPath)svgObject2).transform != null) {
            this.canvas.concat(((SVG.ClipPath)svgObject2).transform);
        }
        this.state = this.findInheritFromAncestorState(svgObject2);
        this.checkForClipPath((SVG.SvgElement)svgObject2);
        svgElement = new Path();
        for (SVG.SvgObject svgObject2 : ((SVG.ClipPath)svgObject2).children) {
            this.addObjectToClip(svgObject2, true, (Path)svgElement, new Matrix());
        }
        this.canvas.clipPath((Path)svgElement);
        this.clipStatePop();
    }

    private void addObjectToClip(SVG.SvgObject svgObject, boolean bl2, Path path, Matrix matrix) {
        if (this.display()) {
            this.clipStatePush();
            if (svgObject instanceof SVG.Use) {
                if (bl2) {
                    this.addObjectToClip((SVG.Use)svgObject, path, matrix);
                } else {
                    SVGAndroidRenderer.error("<use> elements inside a <clipPath> cannot reference another <use>", new Object[0]);
                }
            } else if (svgObject instanceof SVG.Path) {
                this.addObjectToClip((SVG.Path)svgObject, path, matrix);
            } else if (svgObject instanceof SVG.Text) {
                this.addObjectToClip((SVG.Text)svgObject, path, matrix);
            } else if (svgObject instanceof SVG.GraphicsElement) {
                this.addObjectToClip((SVG.GraphicsElement)svgObject, path, matrix);
            } else {
                SVGAndroidRenderer.error("Invalid %s element found in clipPath definition", svgObject.toString());
            }
            this.clipStatePop();
        }
    }

    private void clipStatePush() {
        CanvasLegacy.save(this.canvas, CanvasLegacy.MATRIX_SAVE_FLAG);
        this.stateStack.push(this.state);
        SVGAndroidRenderer sVGAndroidRenderer = this;
        this.state = sVGAndroidRenderer.new RendererState(sVGAndroidRenderer.state);
    }

    private void clipStatePop() {
        this.canvas.restore();
        this.state = this.stateStack.pop();
    }

    private Path.FillType getClipRuleFromState() {
        if (this.state.style.clipRule != null && this.state.style.clipRule == SVG.Style.FillRule.EvenOdd) {
            return Path.FillType.EVEN_ODD;
        }
        return Path.FillType.WINDING;
    }

    private void addObjectToClip(SVG.Path path, Path path2, Matrix matrix) {
        SVGAndroidRenderer sVGAndroidRenderer = this;
        sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, path);
        if (this.display() && this.visible()) {
            if (path.transform != null) {
                matrix.preConcat(path.transform);
            }
            Path path3 = new PathConverter(path.d).getPath();
            if (path.boundingBox == null) {
                path.boundingBox = this.calculatePathBounds(path3);
            }
            this.checkForClipPath(path);
            path2.setFillType(this.getClipRuleFromState());
            path2.addPath(path3, matrix);
        }
    }

    private void addObjectToClip(SVG.GraphicsElement graphicsElement, Path path, Matrix matrix) {
        SVGAndroidRenderer sVGAndroidRenderer = this;
        sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, graphicsElement);
        if (this.display() && this.visible()) {
            Path path2;
            if (graphicsElement.transform != null) {
                matrix.preConcat(graphicsElement.transform);
            }
            if (graphicsElement instanceof SVG.Rect) {
                path2 = this.makePathAndBoundingBox((SVG.Rect)graphicsElement);
            } else if (graphicsElement instanceof SVG.Circle) {
                path2 = this.makePathAndBoundingBox((SVG.Circle)graphicsElement);
            } else if (graphicsElement instanceof SVG.Ellipse) {
                path2 = this.makePathAndBoundingBox((SVG.Ellipse)graphicsElement);
            } else {
                if (!(graphicsElement instanceof SVG.PolyLine)) {
                    return;
                }
                path2 = this.makePathAndBoundingBox((SVG.PolyLine)graphicsElement);
            }
            this.checkForClipPath(graphicsElement);
            path.setFillType(this.getClipRuleFromState());
            path.addPath(path2, matrix);
        }
    }

    private void addObjectToClip(SVG.Use use, Path path, Matrix matrix) {
        SVGAndroidRenderer sVGAndroidRenderer = this;
        sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, use);
        if (this.display() && this.visible()) {
            SVG.SvgObject svgObject;
            if (use.transform != null) {
                matrix.preConcat(use.transform);
            }
            if ((svgObject = use.document.resolveIRI(use.href)) == null) {
                SVGAndroidRenderer.error("Use reference '%s' not found", use.href);
                return;
            }
            this.checkForClipPath(use);
            this.addObjectToClip(svgObject, false, path, matrix);
        }
    }

    private void addObjectToClip(SVG.Text text, Path path, Matrix matrix) {
        SVGAndroidRenderer sVGAndroidRenderer = this;
        sVGAndroidRenderer.updateStyleForElement(sVGAndroidRenderer.state, text);
        if (this.display()) {
            float f2;
            if (text.transform != null) {
                matrix.preConcat(text.transform);
            }
            float f3 = text.x != null && text.x.size() != 0 ? ((SVG.Length)text.x.get(0)).floatValueX(this) : 0.0f;
            float f4 = text.y != null && text.y.size() != 0 ? ((SVG.Length)text.y.get(0)).floatValueY(this) : 0.0f;
            float f5 = text.dx != null && text.dx.size() != 0 ? ((SVG.Length)text.dx.get(0)).floatValueX(this) : 0.0f;
            float f6 = f2 = text.dy != null && text.dy.size() != 0 ? ((SVG.Length)text.dy.get(0)).floatValueY(this) : 0.0f;
            if (this.state.style.textAnchor != SVG.Style.TextAnchor.Start) {
                float f7 = this.calculateTextWidth(text);
                f3 = this.state.style.textAnchor == SVG.Style.TextAnchor.Middle ? (f3 -= f7 / 2.0f) : (f3 -= f7);
            }
            if (text.boundingBox == null) {
                TextBoundsCalculator textBoundsCalculator = new TextBoundsCalculator(f3, f4);
                this.enumerateTextSpans(text, textBoundsCalculator);
                text.boundingBox = new SVG.Box(textBoundsCalculator.bbox.left, textBoundsCalculator.bbox.top, textBoundsCalculator.bbox.width(), textBoundsCalculator.bbox.height());
            }
            this.checkForClipPath(text);
            Path path2 = new Path();
            this.enumerateTextSpans(text, new PlainTextToPath(f3 + f5, f4 + f2, path2));
            path.setFillType(this.getClipRuleFromState());
            path.addPath(path2, matrix);
        }
    }

    private Path makePathAndBoundingBox(SVG.Line line) {
        float f2;
        float f3 = line.x1 == null ? 0.0f : line.x1.floatValueX(this);
        float f4 = line.y1 == null ? 0.0f : line.y1.floatValueY(this);
        float f5 = line.x2 == null ? 0.0f : line.x2.floatValueX(this);
        float f6 = f2 = line.y2 == null ? 0.0f : line.y2.floatValueY(this);
        if (line.boundingBox == null) {
            line.boundingBox = new SVG.Box(Math.min(f3, f5), Math.min(f4, f2), Math.abs(f5 - f3), Math.abs(f2 - f4));
        }
        line = new Path();
        line.moveTo(f3, f4);
        line.lineTo(f5, f2);
        return line;
    }

    private Path makePathAndBoundingBox(SVG.Rect rect) {
        float f2;
        float f3;
        if (rect.rx == null && rect.ry == null) {
            f3 = 0.0f;
            f2 = 0.0f;
        } else if (rect.rx == null) {
            f3 = f2 = rect.ry.floatValueY(this);
        } else if (rect.ry == null) {
            f3 = f2 = rect.rx.floatValueX(this);
        } else {
            f3 = rect.rx.floatValueX(this);
            f2 = rect.ry.floatValueY(this);
        }
        f3 = Math.min(f3, rect.width.floatValueX(this) / 2.0f);
        f2 = Math.min(f2, rect.height.floatValueY(this) / 2.0f);
        float f4 = rect.x != null ? rect.x.floatValueX(this) : 0.0f;
        float f5 = rect.y != null ? rect.y.floatValueY(this) : 0.0f;
        float f6 = rect.width.floatValueX(this);
        float f7 = rect.height.floatValueY(this);
        if (rect.boundingBox == null) {
            rect.boundingBox = new SVG.Box(f4, f5, f6, f7);
        }
        float f8 = f4 + f6;
        f6 = f5 + f7;
        Path path = new Path();
        if (f3 != 0.0f && f2 != 0.0f) {
            float f9 = f3 * 0.5522848f;
            float f10 = f2 * 0.5522848f;
            path.moveTo(f4, f5 + f2);
            path.cubicTo(f4, f5 + f2 - f10, f4 + f3 - f9, f5, f4 + f3, f5);
            path.lineTo(f8 - f3, f5);
            path.cubicTo(f8 - f3 + f9, f5, f8, f5 + f2 - f10, f8, f5 + f2);
            path.lineTo(f8, f6 - f2);
            path.cubicTo(f8, f6 - f2 + f10, f8 - f3 + f9, f6, f8 - f3, f6);
            path.lineTo(f4 + f3, f6);
            path.cubicTo(f4 + f3 - f9, f6, f4, f6 - f2 + f10, f4, f6 - f2);
            path.lineTo(f4, f5 + f2);
        } else {
            path.moveTo(f4, f5);
            path.lineTo(f8, f5);
            path.lineTo(f8, f6);
            path.lineTo(f4, f6);
            path.lineTo(f4, f5);
        }
        path.close();
        return path;
    }

    private Path makePathAndBoundingBox(SVG.Circle circle) {
        float f2 = circle.cx != null ? circle.cx.floatValueX(this) : 0.0f;
        float f3 = circle.cy != null ? circle.cy.floatValueY(this) : 0.0f;
        float f4 = circle.r.floatValue(this);
        float f5 = f2 - f4;
        float f6 = f3 - f4;
        float f7 = f2 + f4;
        float f8 = f3 + f4;
        if (circle.boundingBox == null) {
            circle.boundingBox = new SVG.Box(f5, f6, f4 * 2.0f, f4 * 2.0f);
        }
        float f9 = f4 * 0.5522848f;
        Path path = new Path();
        path.moveTo(f2, f6);
        path.cubicTo(f2 + f9, f6, f7, f3 - f9, f7, f3);
        path.cubicTo(f7, f3 + f9, f2 + f9, f8, f2, f8);
        path.cubicTo(f2 - f9, f8, f5, f3 + f9, f5, f3);
        path.cubicTo(f5, f3 - f9, f2 - f9, f6, f2, f6);
        path.close();
        return path;
    }

    private Path makePathAndBoundingBox(SVG.Ellipse ellipse) {
        float f2 = ellipse.cx != null ? ellipse.cx.floatValueX(this) : 0.0f;
        float f3 = ellipse.cy != null ? ellipse.cy.floatValueY(this) : 0.0f;
        float f4 = ellipse.rx.floatValueX(this);
        float f5 = ellipse.ry.floatValueY(this);
        float f6 = f2 - f4;
        float f7 = f3 - f5;
        float f8 = f2 + f4;
        float f9 = f3 + f5;
        if (ellipse.boundingBox == null) {
            ellipse.boundingBox = new SVG.Box(f6, f7, f4 * 2.0f, f5 * 2.0f);
        }
        float f10 = f4 * 0.5522848f;
        f4 = f5 * 0.5522848f;
        Path path = new Path();
        path.moveTo(f2, f7);
        path.cubicTo(f2 + f10, f7, f8, f3 - f4, f8, f3);
        path.cubicTo(f8, f3 + f4, f2 + f10, f9, f2, f9);
        path.cubicTo(f2 - f10, f9, f6, f3 + f4, f6, f3);
        path.cubicTo(f6, f3 - f4, f2 - f10, f7, f2, f7);
        path.close();
        return path;
    }

    private Path makePathAndBoundingBox(SVG.PolyLine polyLine) {
        Path path = new Path();
        path.moveTo(polyLine.points[0], polyLine.points[1]);
        for (int i2 = 2; i2 < polyLine.points.length; i2 += 2) {
            path.lineTo(polyLine.points[i2], polyLine.points[i2 + 1]);
        }
        if (polyLine instanceof SVG.Polygon) {
            path.close();
        }
        if (polyLine.boundingBox == null) {
            polyLine.boundingBox = this.calculatePathBounds(path);
        }
        return path;
    }

    private Path makePathAndBoundingBox(SVG.Text text) {
        float f2;
        float f3 = text.x != null && text.x.size() != 0 ? ((SVG.Length)text.x.get(0)).floatValueX(this) : 0.0f;
        float f4 = text.y != null && text.y.size() != 0 ? ((SVG.Length)text.y.get(0)).floatValueY(this) : 0.0f;
        float f5 = text.dx != null && text.dx.size() != 0 ? ((SVG.Length)text.dx.get(0)).floatValueX(this) : 0.0f;
        float f6 = f2 = text.dy != null && text.dy.size() != 0 ? ((SVG.Length)text.dy.get(0)).floatValueY(this) : 0.0f;
        if (this.state.style.textAnchor != SVG.Style.TextAnchor.Start) {
            float f7 = this.calculateTextWidth(text);
            f3 = this.state.style.textAnchor == SVG.Style.TextAnchor.Middle ? (f3 -= f7 / 2.0f) : (f3 -= f7);
        }
        if (text.boundingBox == null) {
            TextBoundsCalculator textBoundsCalculator = new TextBoundsCalculator(f3, f4);
            this.enumerateTextSpans(text, textBoundsCalculator);
            text.boundingBox = new SVG.Box(textBoundsCalculator.bbox.left, textBoundsCalculator.bbox.top, textBoundsCalculator.bbox.width(), textBoundsCalculator.bbox.height());
        }
        Path path = new Path();
        this.enumerateTextSpans(text, new PlainTextToPath(f3 + f5, f4 + f2, path));
        return path;
    }

    private void fillWithPattern(SVG.SvgElement svgElement, Path object, SVG.Pattern pattern) {
        float f2;
        float f3;
        float f4;
        float f5;
        boolean bl2;
        boolean bl3 = bl2 = pattern.patternUnitsAreUser != null && pattern.patternUnitsAreUser != false;
        if (pattern.href != null) {
            SVG.Pattern pattern2 = pattern;
            this.fillInChainedPatternFields(pattern2, pattern2.href);
        }
        if (bl2) {
            f5 = pattern.x != null ? pattern.x.floatValueX(this) : 0.0f;
            f4 = pattern.y != null ? pattern.y.floatValueY(this) : 0.0f;
            f3 = pattern.width != null ? pattern.width.floatValueX(this) : 0.0f;
            f2 = pattern.height != null ? pattern.height.floatValueY(this) : 0.0f;
        } else {
            f5 = pattern.x != null ? pattern.x.floatValue(this, 1.0f) : 0.0f;
            f4 = pattern.y != null ? pattern.y.floatValue(this, 1.0f) : 0.0f;
            f3 = pattern.width != null ? pattern.width.floatValue(this, 1.0f) : 0.0f;
            f2 = pattern.height != null ? pattern.height.floatValue(this, 1.0f) : 0.0f;
            f5 = svgElement.boundingBox.minX + f5 * svgElement.boundingBox.width;
            f4 = svgElement.boundingBox.minY + f4 * svgElement.boundingBox.height;
            f3 *= svgElement.boundingBox.width;
            f2 *= svgElement.boundingBox.height;
        }
        if (f3 != 0.0f && f2 != 0.0f) {
            PreserveAspectRatio preserveAspectRatio = pattern.preserveAspectRatio != null ? pattern.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
            this.statePush();
            this.canvas.clipPath((Path)object);
            object = new RendererState();
            this.updateStyle((RendererState)object, SVG.Style.getDefaultStyle());
            ((RendererState)object).style.overflow = Boolean.FALSE;
            this.state = this.findInheritFromAncestorState(pattern, (RendererState)object);
            object = svgElement.boundingBox;
            if (pattern.patternTransform != null) {
                this.canvas.concat(pattern.patternTransform);
                Matrix matrix = new Matrix();
                if (pattern.patternTransform.invert(matrix)) {
                    float[] fArray = new float[]{svgElement.boundingBox.minX, svgElement.boundingBox.minY, svgElement.boundingBox.maxX(), svgElement.boundingBox.minY, svgElement.boundingBox.maxX(), svgElement.boundingBox.maxY(), svgElement.boundingBox.minX, svgElement.boundingBox.maxY()};
                    matrix.mapPoints(fArray);
                    RectF rectF = new RectF(fArray[0], fArray[1], fArray[0], fArray[1]);
                    for (int i2 = 2; i2 <= 6; i2 += 2) {
                        if (fArray[i2] < rectF.left) {
                            rectF.left = fArray[i2];
                        }
                        if (fArray[i2] > rectF.right) {
                            rectF.right = fArray[i2];
                        }
                        if (fArray[i2 + 1] < rectF.top) {
                            rectF.top = fArray[i2 + 1];
                        }
                        if (!(fArray[i2 + 1] > rectF.bottom)) continue;
                        rectF.bottom = fArray[i2 + 1];
                    }
                    object = new SVG.Box(rectF.left, rectF.top, rectF.right - rectF.left, rectF.bottom - rectF.top);
                }
            }
            float f6 = f5 + (float)Math.floor((((SVG.Box)object).minX - f5) / f3) * f3;
            float f7 = ((SVG.Box)object).maxX();
            float f8 = ((SVG.Box)object).maxY();
            SVG.Box box = new SVG.Box(0.0f, 0.0f, f3, f2);
            boolean bl4 = this.pushLayer();
            for (float f9 = f4 + (float)Math.floor((((SVG.Box)object).minY - f4) / f2) * f2; f9 < f8; f9 += f2) {
                for (float f10 = f6; f10 < f7; f10 += f3) {
                    box.minX = f10;
                    box.minY = f9;
                    this.statePush();
                    if (!this.state.style.overflow.booleanValue()) {
                        this.setClipRect(box.minX, box.minY, box.width, box.height);
                    }
                    if (pattern.viewBox != null) {
                        this.canvas.concat(this.calculateViewBoxTransform(box, pattern.viewBox, preserveAspectRatio));
                    } else {
                        boolean bl5 = pattern.patternContentUnitsAreUser == null || pattern.patternContentUnitsAreUser != false;
                        this.canvas.translate(f10, f9);
                        if (!bl5) {
                            this.canvas.scale(svgElement.boundingBox.width, svgElement.boundingBox.height);
                        }
                    }
                    for (SVG.SvgObject svgObject : pattern.children) {
                        this.render(svgObject);
                    }
                    this.statePop();
                }
            }
            if (bl4) {
                this.popLayer(pattern);
            }
            this.statePop();
        }
    }

    private void fillInChainedPatternFields(SVG.Pattern pattern, String object) {
        SVG.SvgObject svgObject = pattern.document.resolveIRI((String)object);
        if (svgObject == null) {
            SVGAndroidRenderer.warn("Pattern reference '%s' not found", object);
            return;
        }
        if (!(svgObject instanceof SVG.Pattern)) {
            SVGAndroidRenderer.error("Pattern href attributes must point to other pattern elements", new Object[0]);
            return;
        }
        if (svgObject == pattern) {
            SVGAndroidRenderer.error("Circular reference in pattern href attribute '%s'", object);
            return;
        }
        object = (SVG.Pattern)svgObject;
        if (pattern.patternUnitsAreUser == null) {
            pattern.patternUnitsAreUser = ((SVG.Pattern)object).patternUnitsAreUser;
        }
        if (pattern.patternContentUnitsAreUser == null) {
            pattern.patternContentUnitsAreUser = ((SVG.Pattern)object).patternContentUnitsAreUser;
        }
        if (pattern.patternTransform == null) {
            pattern.patternTransform = ((SVG.Pattern)object).patternTransform;
        }
        if (pattern.x == null) {
            pattern.x = ((SVG.Pattern)object).x;
        }
        if (pattern.y == null) {
            pattern.y = ((SVG.Pattern)object).y;
        }
        if (pattern.width == null) {
            pattern.width = ((SVG.Pattern)object).width;
        }
        if (pattern.height == null) {
            pattern.height = ((SVG.Pattern)object).height;
        }
        if (pattern.children.isEmpty()) {
            pattern.children = ((SVG.Pattern)object).children;
        }
        if (pattern.viewBox == null) {
            pattern.viewBox = ((SVG.Pattern)object).viewBox;
        }
        if (pattern.preserveAspectRatio == null) {
            pattern.preserveAspectRatio = ((SVG.Pattern)object).preserveAspectRatio;
        }
        if (((SVG.Pattern)object).href != null) {
            this.fillInChainedPatternFields(pattern, ((SVG.Pattern)object).href);
        }
    }

    private void renderMask(SVG.Mask mask, SVG.SvgElement svgElement, SVG.Box box) {
        float f2;
        float f3;
        SVGAndroidRenderer.debug("Mask render", new Object[0]);
        if (mask.maskUnitsAreUser != null && mask.maskUnitsAreUser != false) {
            f3 = mask.width != null ? mask.width.floatValueX(this) : box.width;
            f2 = mask.height != null ? mask.height.floatValueY(this) : box.height;
        } else {
            f3 = mask.width != null ? mask.width.floatValue(this, 1.0f) : 1.2f;
            f2 = mask.height != null ? mask.height.floatValue(this, 1.0f) : 1.2f;
            f3 *= box.width;
            f2 *= box.height;
        }
        if (f3 != 0.0f && f2 != 0.0f) {
            this.statePush();
            this.state = this.findInheritFromAncestorState(mask);
            this.state.style.opacity = Float.valueOf(1.0f);
            boolean bl2 = this.pushLayer();
            this.canvas.save();
            if (!(mask.maskContentUnitsAreUser == null || mask.maskContentUnitsAreUser != false)) {
                this.canvas.translate(box.minX, box.minY);
                this.canvas.scale(box.width, box.height);
            }
            this.renderChildren(mask, false);
            this.canvas.restore();
            if (bl2) {
                this.popLayer(svgElement, box);
            }
            this.statePop();
        }
    }

    private class RendererState {
        SVG.Style style;
        boolean hasFill;
        boolean hasStroke;
        Paint fillPaint;
        Paint strokePaint;
        SVG.Box viewPort;
        SVG.Box viewBox;
        boolean spacePreserve;

        RendererState() {
            this.fillPaint = new Paint();
            this.fillPaint.setFlags(193);
            if (Build.VERSION.SDK_INT >= 14) {
                this.fillPaint.setHinting(0);
            }
            this.fillPaint.setStyle(Paint.Style.FILL);
            this.fillPaint.setTypeface(Typeface.DEFAULT);
            this.strokePaint = new Paint();
            this.strokePaint.setFlags(193);
            if (Build.VERSION.SDK_INT >= 14) {
                this.strokePaint.setHinting(0);
            }
            this.strokePaint.setStyle(Paint.Style.STROKE);
            this.strokePaint.setTypeface(Typeface.DEFAULT);
            this.style = SVG.Style.getDefaultStyle();
        }

        RendererState(RendererState rendererState) {
            this.hasFill = rendererState.hasFill;
            this.hasStroke = rendererState.hasStroke;
            this.fillPaint = new Paint(rendererState.fillPaint);
            this.strokePaint = new Paint(rendererState.strokePaint);
            if (rendererState.viewPort != null) {
                this.viewPort = new SVG.Box(rendererState.viewPort);
            }
            if (rendererState.viewBox != null) {
                this.viewBox = new SVG.Box(rendererState.viewBox);
            }
            this.spacePreserve = rendererState.spacePreserve;
            try {
                this.style = (SVG.Style)rendererState.style.clone();
                return;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Log.e((String)SVGAndroidRenderer.TAG, (String)"Unexpected clone error", (Throwable)cloneNotSupportedException);
                this.style = SVG.Style.getDefaultStyle();
                return;
            }
        }
    }

    private class PlainTextDrawer
    extends TextProcessor {
        float x;
        float y;

        PlainTextDrawer(float f2, float f3) {
            this.x = f2;
            this.y = f3;
        }

        @Override
        public void processText(String string2) {
            SVGAndroidRenderer.debug("TextSequence render", new Object[0]);
            if (SVGAndroidRenderer.this.visible()) {
                if (((SVGAndroidRenderer)SVGAndroidRenderer.this).state.hasFill) {
                    SVGAndroidRenderer.this.canvas.drawText(string2, this.x, this.y, ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint);
                }
                if (((SVGAndroidRenderer)SVGAndroidRenderer.this).state.hasStroke) {
                    SVGAndroidRenderer.this.canvas.drawText(string2, this.x, this.y, ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.strokePaint);
                }
            }
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(string2);
        }
    }

    private abstract class TextProcessor {
        private TextProcessor() {
        }

        public boolean doTextContainer(SVG.TextContainer textContainer) {
            return true;
        }

        public abstract void processText(String var1);
    }

    private class PathTextDrawer
    extends PlainTextDrawer {
        private Path path;

        PathTextDrawer(Path path, float f2, float f3) {
            super(f2, f3);
            this.path = path;
        }

        @Override
        public void processText(String string2) {
            if (SVGAndroidRenderer.this.visible()) {
                if (((SVGAndroidRenderer)SVGAndroidRenderer.this).state.hasFill) {
                    SVGAndroidRenderer.this.canvas.drawTextOnPath(string2, this.path, this.x, this.y, ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint);
                }
                if (((SVGAndroidRenderer)SVGAndroidRenderer.this).state.hasStroke) {
                    SVGAndroidRenderer.this.canvas.drawTextOnPath(string2, this.path, this.x, this.y, ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.strokePaint);
                }
            }
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(string2);
        }
    }

    private class TextWidthCalculator
    extends TextProcessor {
        float x = 0.0f;

        private TextWidthCalculator() {
        }

        @Override
        public void processText(String string2) {
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(string2);
        }
    }

    private class TextBoundsCalculator
    extends TextProcessor {
        float x;
        float y;
        RectF bbox = new RectF();

        TextBoundsCalculator(float f2, float f3) {
            this.x = f2;
            this.y = f3;
        }

        @Override
        public boolean doTextContainer(SVG.TextContainer svgObject) {
            if (svgObject instanceof SVG.TextPath) {
                SVG.TextPath textPath = (SVG.TextPath)svgObject;
                svgObject = svgObject.document.resolveIRI(textPath.href);
                if (svgObject == null) {
                    SVGAndroidRenderer.error("TextPath path reference '%s' not found", new Object[]{textPath.href});
                    return false;
                }
                svgObject = (SVG.Path)svgObject;
                SVGAndroidRenderer sVGAndroidRenderer = SVGAndroidRenderer.this;
                sVGAndroidRenderer.getClass();
                textPath = sVGAndroidRenderer.new PathConverter(((SVG.Path)svgObject).d).getPath();
                if (((SVG.Path)svgObject).transform != null) {
                    textPath.transform(((SVG.Path)svgObject).transform);
                }
                svgObject = new RectF();
                textPath.computeBounds((RectF)svgObject, true);
                this.bbox.union((RectF)svgObject);
                return false;
            }
            return true;
        }

        @Override
        public void processText(String string2) {
            if (SVGAndroidRenderer.this.visible()) {
                Rect rect = new Rect();
                ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.getTextBounds(string2, 0, string2.length(), rect);
                rect = new RectF(rect);
                rect.offset(this.x, this.y);
                this.bbox.union((RectF)rect);
            }
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(string2);
        }
    }

    private class PathConverter
    implements SVG.PathInterface {
        Path path = new Path();
        float lastX;
        float lastY;

        PathConverter(SVG.PathDefinition pathDefinition) {
            if (pathDefinition != null) {
                pathDefinition.enumeratePath(this);
            }
        }

        Path getPath() {
            return this.path;
        }

        @Override
        public void moveTo(float f2, float f3) {
            this.path.moveTo(f2, f3);
            this.lastX = f2;
            this.lastY = f3;
        }

        @Override
        public void lineTo(float f2, float f3) {
            this.path.lineTo(f2, f3);
            this.lastX = f2;
            this.lastY = f3;
        }

        @Override
        public void cubicTo(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.path.cubicTo(f2, f3, f4, f5, f6, f7);
            this.lastX = f6;
            this.lastY = f7;
        }

        @Override
        public void quadTo(float f2, float f3, float f4, float f5) {
            this.path.quadTo(f2, f3, f4, f5);
            this.lastX = f4;
            this.lastY = f5;
        }

        @Override
        public void arcTo(float f2, float f3, float f4, boolean bl2, boolean bl3, float f5, float f6) {
            SVGAndroidRenderer.arcTo(this.lastX, this.lastY, f2, f3, f4, bl2, bl3, f5, f6, this);
            this.lastX = f5;
            this.lastY = f6;
        }

        @Override
        public void close() {
            this.path.close();
        }
    }

    private class MarkerVector {
        float x;
        float y;
        float dx = 0.0f;
        float dy = 0.0f;
        boolean isAmbiguous = false;

        MarkerVector(float f2, float f3, float f4, float f5) {
            this.x = f2;
            this.y = f3;
            float f6 = f4;
            float f7 = f5;
            double d2 = Math.sqrt(f6 * f6 + f7 * f7);
            if (d2 != 0.0) {
                this.dx = (float)((double)f4 / d2);
                this.dy = (float)((double)f5 / d2);
            }
        }

        void add(float f2, float f3) {
            float f4 = f2 -= this.x;
            float f5 = f3 -= this.y;
            double d2 = Math.sqrt(f4 * f4 + f5 * f5);
            if (d2 != 0.0) {
                f2 = (float)((double)f2 / d2);
                f3 = (float)((double)f3 / d2);
            }
            if (f2 == -this.dx && f3 == -this.dy) {
                this.isAmbiguous = true;
                this.dx = -f3;
                this.dy = f2;
                return;
            }
            this.dx += f2;
            this.dy += f3;
        }

        void add(MarkerVector markerVector) {
            if (markerVector.dx == -this.dx && markerVector.dy == -this.dy) {
                this.isAmbiguous = true;
                this.dx = -markerVector.dy;
                this.dy = markerVector.dx;
                return;
            }
            this.dx += markerVector.dx;
            this.dy += markerVector.dy;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + " " + this.dx + "," + this.dy + ")";
        }
    }

    private class MarkerPositionCalculator
    implements SVG.PathInterface {
        private List<MarkerVector> markers = new ArrayList<MarkerVector>();
        private float startX;
        private float startY;
        private MarkerVector lastPos = null;
        private boolean startArc = false;
        private boolean normalCubic = true;
        private int subpathStartIndex = -1;
        private boolean closepathReAdjustPending;

        MarkerPositionCalculator(SVG.PathDefinition pathDefinition) {
            if (pathDefinition != null) {
                pathDefinition.enumeratePath(this);
                if (this.closepathReAdjustPending) {
                    this.lastPos.add(this.markers.get(this.subpathStartIndex));
                    this.markers.set(this.subpathStartIndex, this.lastPos);
                    this.closepathReAdjustPending = false;
                }
                if (this.lastPos != null) {
                    this.markers.add(this.lastPos);
                }
            }
        }

        List<MarkerVector> getMarkers() {
            return this.markers;
        }

        @Override
        public void moveTo(float f2, float f3) {
            if (this.closepathReAdjustPending) {
                this.lastPos.add(this.markers.get(this.subpathStartIndex));
                this.markers.set(this.subpathStartIndex, this.lastPos);
                this.closepathReAdjustPending = false;
            }
            if (this.lastPos != null) {
                this.markers.add(this.lastPos);
            }
            this.startX = f2;
            this.startY = f3;
            SVGAndroidRenderer sVGAndroidRenderer = SVGAndroidRenderer.this;
            sVGAndroidRenderer.getClass();
            this.lastPos = sVGAndroidRenderer.new MarkerVector(f2, f3, 0.0f, 0.0f);
            this.subpathStartIndex = this.markers.size();
        }

        @Override
        public void lineTo(float f2, float f3) {
            this.lastPos.add(f2, f3);
            this.markers.add(this.lastPos);
            SVGAndroidRenderer sVGAndroidRenderer = SVGAndroidRenderer.this;
            sVGAndroidRenderer.getClass();
            this.lastPos = sVGAndroidRenderer.new MarkerVector(f2, f3, f2 - this.lastPos.x, f3 - this.lastPos.y);
            this.closepathReAdjustPending = false;
        }

        @Override
        public void cubicTo(float f2, float f3, float f4, float f5, float f6, float f7) {
            if (this.normalCubic || this.startArc) {
                this.lastPos.add(f2, f3);
                this.markers.add(this.lastPos);
                this.startArc = false;
            }
            SVGAndroidRenderer sVGAndroidRenderer = SVGAndroidRenderer.this;
            sVGAndroidRenderer.getClass();
            this.lastPos = sVGAndroidRenderer.new MarkerVector(f6, f7, f6 - f4, f7 - f5);
            this.closepathReAdjustPending = false;
        }

        @Override
        public void quadTo(float f2, float f3, float f4, float f5) {
            this.lastPos.add(f2, f3);
            this.markers.add(this.lastPos);
            SVGAndroidRenderer sVGAndroidRenderer = SVGAndroidRenderer.this;
            sVGAndroidRenderer.getClass();
            this.lastPos = sVGAndroidRenderer.new MarkerVector(f4, f5, f4 - f2, f5 - f3);
            this.closepathReAdjustPending = false;
        }

        @Override
        public void arcTo(float f2, float f3, float f4, boolean bl2, boolean bl3, float f5, float f6) {
            this.startArc = true;
            this.normalCubic = false;
            SVGAndroidRenderer.arcTo(this.lastPos.x, this.lastPos.y, f2, f3, f4, bl2, bl3, f5, f6, this);
            this.normalCubic = true;
            this.closepathReAdjustPending = false;
        }

        @Override
        public void close() {
            this.markers.add(this.lastPos);
            MarkerPositionCalculator markerPositionCalculator = this;
            markerPositionCalculator.lineTo(markerPositionCalculator.startX, this.startY);
            this.closepathReAdjustPending = true;
        }
    }

    private class PlainTextToPath
    extends TextProcessor {
        float x;
        float y;
        Path textAsPath;

        PlainTextToPath(float f2, float f3, Path path) {
            this.x = f2;
            this.y = f3;
            this.textAsPath = path;
        }

        @Override
        public boolean doTextContainer(SVG.TextContainer textContainer) {
            if (textContainer instanceof SVG.TextPath) {
                SVGAndroidRenderer.warn("Using <textPath> elements in a clip path is not supported.", new Object[0]);
                return false;
            }
            return true;
        }

        @Override
        public void processText(String string2) {
            if (SVGAndroidRenderer.this.visible()) {
                Path path = new Path();
                ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.getTextPath(string2, 0, string2.length(), this.x, this.y, path);
                this.textAsPath.addPath(path);
            }
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(string2);
        }
    }
}

