/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.svg;

import android.util.Log;
import com.autonavi.ae.svg.CSSParseException;
import com.autonavi.ae.svg.IntegerParser;
import com.autonavi.ae.svg.SVG;
import com.autonavi.ae.svg.SVGParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class CSSParser {
    private static final String TAG = "CSSParser";
    static final String CSS_MIME_TYPE = "text/css";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final int SPECIFICITY_ID_ATTRIBUTE = 1000000;
    private static final int SPECIFICITY_ATTRIBUTE_OR_PSEUDOCLASS = 1000;
    private static final int SPECIFICITY_ELEMENT_OR_PSEUDOELEMENT = 1;
    private MediaType deviceMediaType = null;
    private Source source = null;
    private boolean inMediaRule = false;

    CSSParser() {
        this(MediaType.screen, Source.Document);
    }

    CSSParser(Source source) {
        this(MediaType.screen, source);
    }

    CSSParser(MediaType mediaType, Source source) {
        this.deviceMediaType = mediaType;
        this.source = source;
    }

    Ruleset parse(String object) {
        object = new CSSTextScanner((String)object);
        ((SVGParser.TextScanner)object).skipWhitespace();
        return this.parseRuleset((CSSTextScanner)object);
    }

    static boolean mediaMatches(String object, MediaType mediaType) {
        object = new CSSTextScanner((String)object);
        ((SVGParser.TextScanner)object).skipWhitespace();
        return CSSParser.mediaMatches(CSSParser.parseMediaList((CSSTextScanner)object), mediaType);
    }

    private static void warn(String string2, Object ... objectArray) {
        String.format(string2, objectArray);
    }

    private static boolean mediaMatches(List<MediaType> object, MediaType mediaType) {
        MediaType mediaType2;
        object = object.iterator();
        do {
            if (object.hasNext()) continue;
            return false;
        } while ((mediaType2 = (MediaType)((Object)object.next())) != MediaType.all && mediaType2 != mediaType);
        return true;
    }

    private static List<MediaType> parseMediaList(CSSTextScanner cSSTextScanner) {
        String string2;
        ArrayList<MediaType> arrayList = new ArrayList<MediaType>();
        while (!cSSTextScanner.empty() && (string2 = cSSTextScanner.nextWord()) != null) {
            try {
                arrayList.add(MediaType.valueOf(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (cSSTextScanner.skipCommaWhitespace()) continue;
        }
        return arrayList;
    }

    private void parseAtRule(Ruleset ruleset, CSSTextScanner cSSTextScanner) throws CSSParseException {
        Object object = cSSTextScanner.nextIdentifier();
        cSSTextScanner.skipWhitespace();
        if (object == null) {
            throw new CSSParseException("Invalid '@' rule");
        }
        if (!this.inMediaRule && ((String)object).equals("media")) {
            object = CSSParser.parseMediaList(cSSTextScanner);
            if (!cSSTextScanner.consume('{')) {
                throw new CSSParseException("Invalid @media rule: missing rule set");
            }
            cSSTextScanner.skipWhitespace();
            if (CSSParser.mediaMatches((List<MediaType>)object, this.deviceMediaType)) {
                this.inMediaRule = true;
                ruleset.addAll(this.parseRuleset(cSSTextScanner));
                this.inMediaRule = false;
            } else {
                this.parseRuleset(cSSTextScanner);
            }
            if (!cSSTextScanner.empty() && !cSSTextScanner.consume('}')) {
                throw new CSSParseException("Invalid @media rule: expected '}' at end of rule set");
            }
        } else if (!this.inMediaRule && ((String)object).equals("import")) {
            object = cSSTextScanner.nextURL();
            if (object == null) {
                object = cSSTextScanner.nextCSSString();
            }
            if (object == null) {
                throw new CSSParseException("Invalid @import rule: expected string or url()");
            }
            cSSTextScanner.skipWhitespace();
            List<MediaType> list = CSSParser.parseMediaList(cSSTextScanner);
            if (!cSSTextScanner.empty() && !cSSTextScanner.consume(';')) {
                throw new CSSParseException("Invalid @media rule: expected '}' at end of rule set");
            }
            if (SVG.getFileResolver() != null && CSSParser.mediaMatches(list, this.deviceMediaType)) {
                object = SVG.getFileResolver().resolveCSSStyleSheet((String)object);
                if (object == null) {
                    return;
                }
                ruleset.addAll(this.parse((String)object));
            }
        } else {
            CSSParser.warn("Ignoring @%s rule", object);
            this.skipAtRule(cSSTextScanner);
        }
        cSSTextScanner.skipWhitespace();
    }

    private void skipAtRule(CSSTextScanner cSSTextScanner) {
        int n2 = 0;
        while (!cSSTextScanner.empty()) {
            int n3 = cSSTextScanner.nextChar();
            if (n3 == 59 && n2 == 0) {
                return;
            }
            if (n3 == 123) {
                ++n2;
                continue;
            }
            if (n3 != 125 || n2 <= 0 || --n2 != 0) continue;
            return;
        }
    }

    private Ruleset parseRuleset(CSSTextScanner cSSTextScanner) {
        Ruleset ruleset = new Ruleset();
        try {
            while (!cSSTextScanner.empty()) {
                if (cSSTextScanner.consume("<!--") || cSSTextScanner.consume("-->")) continue;
                if (cSSTextScanner.consume('@')) {
                    this.parseAtRule(ruleset, cSSTextScanner);
                    continue;
                }
                if (this.parseRule(ruleset, cSSTextScanner)) continue;
                break;
            }
        }
        catch (CSSParseException cSSParseException) {
            Log.e((String)TAG, (String)("CSS parser terminated early due to error: " + cSSParseException.getMessage()));
        }
        return ruleset;
    }

    private boolean parseRule(Ruleset ruleset, CSSTextScanner object) throws CSSParseException {
        Object object2 = ((CSSTextScanner)object).nextSelectorGroup();
        if (object2 != null && !object2.isEmpty()) {
            if (!((SVGParser.TextScanner)object).consume('{')) {
                throw new CSSParseException("Malformed rule block: expected '{'");
            }
            ((SVGParser.TextScanner)object).skipWhitespace();
            SVG.Style style2 = this.parseDeclarations((CSSTextScanner)object);
            ((SVGParser.TextScanner)object).skipWhitespace();
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (Selector)object.next();
                ruleset.add(new Rule((Selector)object2, style2, this.source));
            }
            return true;
        }
        return false;
    }

    private SVG.Style parseDeclarations(CSSTextScanner cSSTextScanner) throws CSSParseException {
        SVG.Style style2 = new SVG.Style();
        do {
            String string2 = cSSTextScanner.nextIdentifier();
            cSSTextScanner.skipWhitespace();
            if (!cSSTextScanner.consume(':')) {
                throw new CSSParseException("Expected ':'");
            }
            cSSTextScanner.skipWhitespace();
            String string3 = cSSTextScanner.nextPropertyValue();
            if (string3 == null) {
                throw new CSSParseException("Expected property value");
            }
            cSSTextScanner.skipWhitespace();
            if (cSSTextScanner.consume('!')) {
                cSSTextScanner.skipWhitespace();
                if (!cSSTextScanner.consume("important")) {
                    throw new CSSParseException("Malformed rule set: found unexpected '!'");
                }
                cSSTextScanner.skipWhitespace();
            }
            cSSTextScanner.consume(';');
            SVGParser.processStyleProperty(style2, string2, string3);
            cSSTextScanner.skipWhitespace();
        } while (!cSSTextScanner.empty() && !cSSTextScanner.consume('}'));
        return style2;
    }

    public static List<String> parseClassAttribute(String object) {
        object = new CSSTextScanner((String)object);
        ArrayList<String> arrayList = null;
        while (!((SVGParser.TextScanner)object).empty()) {
            String string2 = ((SVGParser.TextScanner)object).nextToken();
            if (string2 == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string2);
            ((SVGParser.TextScanner)object).skipWhitespace();
        }
        return arrayList;
    }

    static boolean ruleMatch(RuleMatchContext ruleMatchContext, Selector selector, SVG.SvgElementBase svgElementBase) {
        ArrayList<SVG.SvgContainer> arrayList = new ArrayList<SVG.SvgContainer>();
        SVG.SvgContainer svgContainer = svgElementBase.parent;
        while (svgContainer != null) {
            arrayList.add(0, svgContainer);
            svgContainer = ((SVG.SvgObject)((Object)svgContainer)).parent;
        }
        int n2 = arrayList.size() - 1;
        if (selector.size() == 1) {
            return CSSParser.selectorMatch(ruleMatchContext, selector.get(0), arrayList, n2, svgElementBase);
        }
        Selector selector2 = selector;
        return CSSParser.ruleMatch(ruleMatchContext, selector2, selector2.size() - 1, arrayList, n2, svgElementBase);
    }

    private static boolean ruleMatch(RuleMatchContext ruleMatchContext, Selector selector, int n2, List<SVG.SvgContainer> list, int n3, SVG.SvgElementBase svgElementBase) {
        SimpleSelector simpleSelector = selector.get(n2);
        if (!CSSParser.selectorMatch(ruleMatchContext, simpleSelector, list, n3, svgElementBase)) {
            return false;
        }
        if (simpleSelector.combinator == Combinator.DESCENDANT) {
            if (n2 == 0) {
                return true;
            }
            while (n3 >= 0) {
                if (CSSParser.ruleMatchOnAncestors(ruleMatchContext, selector, n2 - 1, list, n3)) {
                    return true;
                }
                --n3;
            }
            return false;
        }
        if (simpleSelector.combinator == Combinator.CHILD) {
            return CSSParser.ruleMatchOnAncestors(ruleMatchContext, selector, n2 - 1, list, n3);
        }
        int n4 = CSSParser.getChildPosition(list, n3, svgElementBase);
        if (n4 <= 0) {
            return false;
        }
        svgElementBase = (SVG.SvgElementBase)svgElementBase.parent.getChildren().get(n4 - 1);
        return CSSParser.ruleMatch(ruleMatchContext, selector, n2 - 1, list, n3, svgElementBase);
    }

    private static boolean ruleMatchOnAncestors(RuleMatchContext ruleMatchContext, Selector selector, int n2, List<SVG.SvgContainer> list, int n3) {
        SVG.SvgElementBase svgElementBase;
        SimpleSelector simpleSelector = selector.get(n2);
        if (!CSSParser.selectorMatch(ruleMatchContext, simpleSelector, list, n3, svgElementBase = (SVG.SvgElementBase)((Object)list.get(n3)))) {
            return false;
        }
        if (simpleSelector.combinator == Combinator.DESCENDANT) {
            int n4;
            if (n2 == 0) {
                return true;
            }
            do {
                if (n3 > 0) continue;
                return false;
            } while (!CSSParser.ruleMatchOnAncestors(ruleMatchContext, selector, n4 = n2 - 1, list, --n3));
            return true;
        }
        if (simpleSelector.combinator == Combinator.CHILD) {
            return CSSParser.ruleMatchOnAncestors(ruleMatchContext, selector, n2 - 1, list, n3 - 1);
        }
        int n5 = CSSParser.getChildPosition(list, n3, svgElementBase);
        if (n5 <= 0) {
            return false;
        }
        SVG.SvgElementBase svgElementBase2 = (SVG.SvgElementBase)svgElementBase.parent.getChildren().get(n5 - 1);
        return CSSParser.ruleMatch(ruleMatchContext, selector, n2 - 1, list, n3, svgElementBase2);
    }

    private static int getChildPosition(List<SVG.SvgContainer> list, int n2, SVG.SvgElementBase svgElementBase) {
        if (n2 < 0) {
            return 0;
        }
        if (list.get(n2) != svgElementBase.parent) {
            return -1;
        }
        int n3 = 0;
        Iterator<SVG.SvgObject> iterator = svgElementBase.parent.getChildren().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() == svgElementBase) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static boolean selectorMatch(RuleMatchContext ruleMatchContext, SimpleSelector simpleSelector, List<SVG.SvgContainer> iterator, int n2, SVG.SvgElementBase svgElementBase) {
        if (simpleSelector.tag != null && !simpleSelector.tag.equals(svgElementBase.getNodeName().toLowerCase(Locale.US))) {
            return false;
        }
        if (simpleSelector.attribs != null) {
            block8: for (Attrib attrib : simpleSelector.attribs) {
                String string2 = attrib.name;
                int n3 = -1;
                switch (string2.hashCode()) {
                    case 3355: {
                        if (!string2.equals(ID)) break;
                        n3 = 0;
                        break;
                    }
                    case 94742904: {
                        if (!string2.equals(CLASS)) break;
                        n3 = 1;
                    }
                }
                switch (n3) {
                    case 0: {
                        if (attrib.value.equals(svgElementBase.id)) continue block8;
                        return false;
                    }
                    case 1: {
                        if (svgElementBase.classNames == null) {
                            return false;
                        }
                        if (svgElementBase.classNames.contains(attrib.value)) continue block8;
                        return false;
                    }
                }
                return false;
            }
        }
        if (simpleSelector.pseudos != null) {
            iterator = simpleSelector.pseudos.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().matches(ruleMatchContext, svgElementBase)) continue;
                return false;
            }
        }
        return true;
    }

    static enum MediaType {
        all,
        aural,
        braille,
        embossed,
        handheld,
        print,
        projection,
        screen,
        speech,
        tty,
        tv;

    }

    private static enum Combinator {
        DESCENDANT,
        CHILD,
        FOLLOWS;

    }

    private static enum AttribOp {
        EXISTS,
        EQUALS,
        INCLUDES,
        DASHMATCH;

    }

    private static enum PseudoClassIdents {
        target,
        root,
        nth_child,
        nth_last_child,
        nth_of_type,
        nth_last_of_type,
        first_child,
        last_child,
        first_of_type,
        last_of_type,
        only_child,
        only_of_type,
        empty,
        not,
        lang,
        link,
        visited,
        hover,
        active,
        focus,
        enabled,
        disabled,
        checked,
        indeterminate,
        UNSUPPORTED;

        private static final Map<String, PseudoClassIdents> cache;

        public static PseudoClassIdents fromString(String object) {
            if ((object = cache.get(object)) != null) {
                return object;
            }
            return UNSUPPORTED;
        }

        static {
            cache = new HashMap<String, PseudoClassIdents>();
            for (PseudoClassIdents pseudoClassIdents : PseudoClassIdents.values()) {
                if (pseudoClassIdents == UNSUPPORTED) continue;
                String string2 = pseudoClassIdents.name().replace('_', '-');
                cache.put(string2, pseudoClassIdents);
            }
        }
    }

    private static class Attrib {
        public final String name;
        final AttribOp operation;
        public final String value;

        Attrib(String string2, AttribOp attribOp, String string3) {
            this.name = string2;
            this.operation = attribOp;
            this.value = string3;
        }
    }

    private static class SimpleSelector {
        Combinator combinator = null;
        String tag = null;
        List<Attrib> attribs = null;
        List<PseudoClass> pseudos = null;

        SimpleSelector(Combinator combinator, String string2) {
            this.combinator = combinator != null ? combinator : Combinator.DESCENDANT;
            this.tag = string2;
        }

        void addAttrib(String string2, AttribOp attribOp, String string3) {
            if (this.attribs == null) {
                this.attribs = new ArrayList<Attrib>();
            }
            this.attribs.add(new Attrib(string2, attribOp, string3));
        }

        void addPseudo(PseudoClass pseudoClass) {
            if (this.pseudos == null) {
                this.pseudos = new ArrayList<PseudoClass>();
            }
            this.pseudos.add(pseudoClass);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.combinator == Combinator.CHILD) {
                stringBuilder.append("> ");
            } else if (this.combinator == Combinator.FOLLOWS) {
                stringBuilder.append("+ ");
            }
            stringBuilder.append(this.tag == null ? "*" : this.tag);
            if (this.attribs != null) {
                for (Attrib object : this.attribs) {
                    stringBuilder.append('[').append(object.name);
                    switch (object.operation) {
                        case EQUALS: {
                            stringBuilder.append('=').append(object.value);
                            break;
                        }
                        case INCLUDES: {
                            stringBuilder.append("~=").append(object.value);
                            break;
                        }
                        case DASHMATCH: {
                            stringBuilder.append("|=").append(object.value);
                        }
                    }
                    stringBuilder.append(']');
                }
            }
            if (this.pseudos != null) {
                for (PseudoClass pseudoClass : this.pseudos) {
                    stringBuilder.append(':').append(pseudoClass);
                }
            }
            return stringBuilder.toString();
        }
    }

    static class Ruleset {
        private List<Rule> rules = null;

        Ruleset() {
        }

        void add(Rule rule) {
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>();
            }
            for (int i2 = 0; i2 < this.rules.size(); ++i2) {
                if (this.rules.get((int)i2).selector.specificity <= rule.selector.specificity) continue;
                this.rules.add(i2, rule);
                return;
            }
            this.rules.add(rule);
        }

        void addAll(Ruleset object) {
            if (((Ruleset)object).rules != null) {
                if (this.rules == null) {
                    this.rules = new ArrayList<Rule>(((Ruleset)object).rules.size());
                }
                for (Rule rule : ((Ruleset)object).rules) {
                    this.add(rule);
                }
            }
        }

        List<Rule> getRules() {
            return this.rules;
        }

        boolean isEmpty() {
            return this.rules == null || this.rules.isEmpty();
        }

        int ruleCount() {
            if (this.rules != null) {
                return this.rules.size();
            }
            return 0;
        }

        void removeFromSource(Source source) {
            if (this.rules != null) {
                Iterator<Rule> iterator = this.rules.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().source != source) continue;
                    iterator.remove();
                }
            }
        }

        public String toString() {
            if (this.rules == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Rule rule : this.rules) {
                stringBuilder.append(rule.toString()).append('\n');
            }
            return stringBuilder.toString();
        }
    }

    static enum Source {
        Document,
        RenderOptions;

    }

    static class Rule {
        Selector selector = null;
        SVG.Style style = null;
        Source source;

        Rule(Selector selector, SVG.Style style2, Source source) {
            this.selector = selector;
            this.style = style2;
            this.source = source;
        }

        public String toString() {
            return this.selector + " {...} (src=" + (Object)((Object)this.source) + ")";
        }
    }

    private static class Selector {
        List<SimpleSelector> simpleSelectors = null;
        int specificity = 0;

        private Selector() {
        }

        void add(SimpleSelector simpleSelector) {
            if (this.simpleSelectors == null) {
                this.simpleSelectors = new ArrayList<SimpleSelector>();
            }
            this.simpleSelectors.add(simpleSelector);
        }

        int size() {
            if (this.simpleSelectors == null) {
                return 0;
            }
            return this.simpleSelectors.size();
        }

        SimpleSelector get(int n2) {
            return this.simpleSelectors.get(n2);
        }

        boolean isEmpty() {
            return this.simpleSelectors == null || this.simpleSelectors.isEmpty();
        }

        void addedIdAttribute() {
            this.specificity += 1000000;
        }

        void addedAttributeOrPseudo() {
            this.specificity += 1000;
        }

        void addedElement() {
            ++this.specificity;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (SimpleSelector simpleSelector : this.simpleSelectors) {
                stringBuilder.append(simpleSelector).append(' ');
            }
            return stringBuilder.append('[').append(this.specificity).append(']').toString();
        }
    }

    private static class CSSTextScanner
    extends SVGParser.TextScanner {
        CSSTextScanner(String string2) {
            super(string2.replaceAll("(?s)/\\*.*?\\*/", ""));
        }

        String nextIdentifier() {
            int n2 = this.scanForIdentifier();
            if (n2 == this.position) {
                return null;
            }
            String string2 = this.input.substring(this.position, n2);
            this.position = n2;
            return string2;
        }

        private int scanForIdentifier() {
            if (this.empty()) {
                return this.position;
            }
            int n2 = this.position;
            int n3 = this.position;
            int n4 = this.input.charAt(this.position);
            if (n4 == 45) {
                n4 = this.advanceChar();
            }
            if (n4 >= 65 && n4 <= 90 || n4 >= 97 && n4 <= 122 || n4 == 95) {
                n4 = this.advanceChar();
                while (n4 >= 65 && n4 <= 90 || n4 >= 97 && n4 <= 122 || n4 >= 48 && n4 <= 57 || n4 == 45 || n4 == 95) {
                    n4 = this.advanceChar();
                }
                n3 = this.position;
            }
            this.position = n2;
            return n3;
        }

        private List<Selector> nextSelectorGroup() throws CSSParseException {
            if (this.empty()) {
                return null;
            }
            ArrayList<Selector> arrayList = new ArrayList<Selector>(1);
            Selector selector = new Selector();
            while (!this.empty() && this.nextSimpleSelector(selector)) {
                if (!this.skipCommaWhitespace()) continue;
                arrayList.add(selector);
                selector = new Selector();
            }
            if (!selector.isEmpty()) {
                arrayList.add(selector);
            }
            return arrayList;
        }

        boolean nextSimpleSelector(Selector selector) throws CSSParseException {
            String string2;
            if (this.empty()) {
                return false;
            }
            int n2 = this.position;
            Combinator combinator = null;
            SimpleSelector simpleSelector = null;
            if (!selector.isEmpty()) {
                if (this.consume('>')) {
                    combinator = Combinator.CHILD;
                    this.skipWhitespace();
                } else if (this.consume('+')) {
                    combinator = Combinator.FOLLOWS;
                    this.skipWhitespace();
                }
            }
            if (this.consume('*')) {
                simpleSelector = new SimpleSelector(combinator, null);
            } else {
                string2 = this.nextIdentifier();
                if (string2 != null) {
                    simpleSelector = new SimpleSelector(combinator, string2);
                    selector.addedElement();
                }
            }
            while (!this.empty()) {
                if (this.consume('.')) {
                    if (simpleSelector == null) {
                        simpleSelector = new SimpleSelector(combinator, null);
                    }
                    if ((string2 = this.nextIdentifier()) == null) {
                        throw new CSSParseException("Invalid \".class\" simpleSelectors");
                    }
                    simpleSelector.addAttrib(CSSParser.CLASS, AttribOp.EQUALS, string2);
                    selector.addedAttributeOrPseudo();
                    continue;
                }
                if (this.consume('#')) {
                    if (simpleSelector == null) {
                        simpleSelector = new SimpleSelector(combinator, null);
                    }
                    if ((string2 = this.nextIdentifier()) == null) {
                        throw new CSSParseException("Invalid \"#id\" simpleSelectors");
                    }
                    simpleSelector.addAttrib(CSSParser.ID, AttribOp.EQUALS, string2);
                    selector.addedIdAttribute();
                    continue;
                }
                if (this.consume('[')) {
                    if (simpleSelector == null) {
                        simpleSelector = new SimpleSelector(combinator, null);
                    }
                    this.skipWhitespace();
                    string2 = this.nextIdentifier();
                    String string3 = null;
                    if (string2 == null) {
                        throw new CSSParseException("Invalid attribute simpleSelectors");
                    }
                    this.skipWhitespace();
                    AttribOp attribOp = null;
                    if (this.consume('=')) {
                        attribOp = AttribOp.EQUALS;
                    } else if (this.consume("~=")) {
                        attribOp = AttribOp.INCLUDES;
                    } else if (this.consume("|=")) {
                        attribOp = AttribOp.DASHMATCH;
                    }
                    if (attribOp != null) {
                        this.skipWhitespace();
                        string3 = this.nextAttribValue();
                        if (string3 == null) {
                            throw new CSSParseException("Invalid attribute simpleSelectors");
                        }
                        this.skipWhitespace();
                    }
                    if (!this.consume(']')) {
                        throw new CSSParseException("Invalid attribute simpleSelectors");
                    }
                    simpleSelector.addAttrib(string2, attribOp == null ? AttribOp.EXISTS : attribOp, string3);
                    selector.addedAttributeOrPseudo();
                    continue;
                }
                if (!this.consume(':')) break;
                if (simpleSelector == null) {
                    simpleSelector = new SimpleSelector(combinator, null);
                }
                this.parsePseudoClass(selector, simpleSelector);
            }
            if (simpleSelector != null) {
                selector.add(simpleSelector);
                return true;
            }
            this.position = n2;
            return false;
        }

        private AnPlusB nextAnPlusB() throws CSSParseException {
            AnPlusB anPlusB;
            if (this.empty()) {
                return null;
            }
            int n2 = this.position;
            if (!this.consume('(')) {
                return null;
            }
            this.skipWhitespace();
            if (this.consume("odd")) {
                anPlusB = new AnPlusB(2, 1);
            } else if (this.consume("even")) {
                anPlusB = new AnPlusB(2, 0);
            } else {
                int n3 = 1;
                int n4 = 1;
                if (!this.consume('+') && this.consume('-')) {
                    n4 = -1;
                }
                IntegerParser integerParser = null;
                IntegerParser integerParser2 = IntegerParser.parseInt(this.input, this.position, this.inputLength, false);
                if (integerParser2 != null) {
                    this.position = integerParser2.getEndPos();
                }
                if (this.consume('n') || this.consume('N')) {
                    integerParser = integerParser2 != null ? integerParser2 : new IntegerParser(1L, this.position);
                    n3 = n4;
                    integerParser2 = null;
                    n4 = 1;
                    this.skipWhitespace();
                    boolean bl2 = this.consume('+');
                    if (!bl2 && (bl2 = this.consume('-'))) {
                        n4 = -1;
                    }
                    if (bl2) {
                        this.skipWhitespace();
                        integerParser2 = IntegerParser.parseInt(this.input, this.position, this.inputLength, false);
                        if (integerParser2 == null) {
                            this.position = n2;
                            return null;
                        }
                        this.position = integerParser2.getEndPos();
                    }
                }
                anPlusB = new AnPlusB(integerParser == null ? 0 : n3 * integerParser.value(), integerParser2 == null ? 0 : n4 * integerParser2.value());
            }
            this.skipWhitespace();
            if (this.consume(')')) {
                return anPlusB;
            }
            this.position = n2;
            return null;
        }

        private List<String> nextIdentListParam() throws CSSParseException {
            if (this.empty()) {
                return null;
            }
            int n2 = this.position;
            ArrayList<String> arrayList = null;
            if (!this.consume('(')) {
                return null;
            }
            this.skipWhitespace();
            do {
                String string2;
                if ((string2 = this.nextIdentifier()) == null) {
                    this.position = n2;
                    return null;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string2);
                this.skipWhitespace();
            } while (this.skipCommaWhitespace());
            if (this.consume(')')) {
                return arrayList;
            }
            this.position = n2;
            return null;
        }

        private List<Selector> nextPseudoNotParam() throws CSSParseException {
            if (this.empty()) {
                return null;
            }
            int n2 = this.position;
            if (!this.consume('(')) {
                return null;
            }
            this.skipWhitespace();
            List<Selector> list = this.nextSelectorGroup();
            if (list == null) {
                this.position = n2;
                return null;
            }
            if (!this.consume(')')) {
                this.position = n2;
                return null;
            }
            block0: for (Selector selector : list) {
                if (selector.simpleSelectors == null) break;
                for (SimpleSelector simpleSelector : selector.simpleSelectors) {
                    if (simpleSelector.pseudos == null) continue block0;
                    Iterator<PseudoClass> iterator = simpleSelector.pseudos.iterator();
                    while (iterator.hasNext()) {
                        if (!(iterator.next() instanceof PseudoClassNot)) continue;
                        return null;
                    }
                }
            }
            return list;
        }

        private void parsePseudoClass(Selector selector, SimpleSelector simpleSelector) throws CSSParseException {
            Object object = this.nextIdentifier();
            if (object == null) {
                throw new CSSParseException("Invalid pseudo class");
            }
            Object object2 = PseudoClassIdents.fromString((String)object);
            switch (object2) {
                case first_child: {
                    object = new PseudoClassAnPlusB(0, 1, true, false, null);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case last_child: {
                    object = new PseudoClassAnPlusB(0, 1, false, false, null);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case only_child: {
                    object = new PseudoClassOnlyChild(false, null);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case first_of_type: {
                    object = new PseudoClassAnPlusB(0, 1, true, true, simpleSelector.tag);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case last_of_type: {
                    object = new PseudoClassAnPlusB(0, 1, false, true, simpleSelector.tag);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case only_of_type: {
                    object = new PseudoClassOnlyChild(true, simpleSelector.tag);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case root: {
                    object = new PseudoClassRoot();
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case empty: {
                    object = new PseudoClassEmpty();
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case nth_child: 
                case nth_last_child: 
                case nth_of_type: 
                case nth_last_of_type: {
                    boolean bl2 = object2 == PseudoClassIdents.nth_child || object2 == PseudoClassIdents.nth_of_type;
                    boolean bl3 = object2 == PseudoClassIdents.nth_of_type || object2 == PseudoClassIdents.nth_last_of_type;
                    AnPlusB anPlusB = this.nextAnPlusB();
                    if (anPlusB == null) {
                        throw new CSSParseException("Invalid or missing parameter section for pseudo class: ".concat(String.valueOf(object)));
                    }
                    object = new PseudoClassAnPlusB(anPlusB.a, anPlusB.b, bl2, bl3, simpleSelector.tag);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case not: {
                    object2 = this.nextPseudoNotParam();
                    if (object2 == null) {
                        throw new CSSParseException("Invalid or missing parameter section for pseudo class: ".concat(String.valueOf(object)));
                    }
                    object = new PseudoClassNot((List<Selector>)object2);
                    selector.specificity = ((PseudoClassNot)object).getSpecificity();
                    break;
                }
                case target: {
                    object = new PseudoClassTarget();
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case lang: {
                    this.nextIdentListParam();
                    object = new PseudoClassNotSupported((String)object);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case link: 
                case visited: 
                case hover: 
                case active: 
                case focus: 
                case enabled: 
                case disabled: 
                case checked: 
                case indeterminate: {
                    object = new PseudoClassNotSupported((String)object);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                default: {
                    throw new CSSParseException("Unsupported pseudo class: ".concat(String.valueOf(object)));
                }
            }
            simpleSelector.addPseudo((PseudoClass)object);
        }

        private String nextAttribValue() {
            if (this.empty()) {
                return null;
            }
            String string2 = this.nextQuotedString();
            if (string2 != null) {
                return string2;
            }
            return this.nextIdentifier();
        }

        String nextPropertyValue() {
            if (this.empty()) {
                return null;
            }
            int n2 = this.position;
            int n3 = this.position;
            int n4 = this.input.charAt(this.position);
            while (n4 != -1 && n4 != 59 && n4 != 125 && n4 != 33 && !this.isEOL(n4)) {
                if (!this.isWhitespace(n4)) {
                    n3 = this.position + 1;
                }
                n4 = this.advanceChar();
            }
            if (this.position > n2) {
                return this.input.substring(n2, n3);
            }
            this.position = n2;
            return null;
        }

        String nextCSSString() {
            int n2;
            if (this.empty()) {
                return null;
            }
            int n3 = n2 = this.input.charAt(this.position);
            if (n2 != 39 && n2 != 34) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            ++this.position;
            n2 = this.nextChar();
            while (n2 != -1 && n2 != n3) {
                if (n2 == 92) {
                    n2 = this.nextChar();
                    if (n2 == -1) continue;
                    if (n2 == 10 || n2 == 13 || n2 == 12) {
                        n2 = this.nextChar();
                        continue;
                    }
                    int n4 = this.hexChar(n2);
                    if (n4 != -1) {
                        int n5 = n4;
                        for (int i2 = 1; i2 <= 5 && (n4 = this.hexChar(n2 = this.nextChar().intValue())) != -1; ++i2) {
                            n5 = n5 * 16 + n4;
                        }
                        stringBuilder.append((char)n5);
                        continue;
                    }
                }
                stringBuilder.append((char)n2);
                n2 = this.nextChar();
            }
            return stringBuilder.toString();
        }

        private int hexChar(int n2) {
            if (n2 >= 48 && n2 <= 57) {
                return n2 - 48;
            }
            if (n2 >= 65 && n2 <= 70) {
                return n2 - 65 + 10;
            }
            if (n2 >= 97 && n2 <= 102) {
                return n2 - 97 + 10;
            }
            return -1;
        }

        String nextURL() {
            if (this.empty()) {
                return null;
            }
            int n2 = this.position;
            if (!this.consume("url(")) {
                return null;
            }
            this.skipWhitespace();
            String string2 = this.nextCSSString();
            if (string2 == null) {
                string2 = this.nextLegacyURL();
            }
            if (string2 == null) {
                this.position = n2;
                return null;
            }
            this.skipWhitespace();
            if (!this.empty() && !this.consume(")")) {
                this.position = n2;
                return null;
            }
            return string2;
        }

        String nextLegacyURL() {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            while (!(this.empty() || (n2 = this.input.charAt(this.position)) == 39 || n2 == 34 || n2 == 40 || n2 == 41 || this.isWhitespace(n2) || Character.isISOControl(n2))) {
                ++this.position;
                if (n2 == 92) {
                    if (this.empty() || (n2 = this.input.charAt(this.position++)) == 10 || n2 == 13 || n2 == 12) continue;
                    int n3 = this.hexChar(n2);
                    if (n3 != -1) {
                        n2 = n3;
                        for (int i2 = 1; i2 <= 5 && !this.empty(); ++i2) {
                            CSSTextScanner cSSTextScanner = this;
                            n3 = cSSTextScanner.hexChar(cSSTextScanner.input.charAt(this.position));
                            if (n3 == -1) break;
                            ++this.position;
                            n2 = n2 * 16 + n3;
                        }
                        stringBuilder.append((char)n2);
                        continue;
                    }
                }
                stringBuilder.append((char)n2);
            }
            if (stringBuilder.length() == 0) {
                return null;
            }
            return stringBuilder.toString();
        }

        private static class AnPlusB {
            public int a;
            public int b;

            AnPlusB(int n2, int n3) {
                this.a = n2;
                this.b = n3;
            }
        }
    }

    static class RuleMatchContext {
        SVG.SvgElementBase targetElement;

        RuleMatchContext() {
        }

        public String toString() {
            if (this.targetElement != null) {
                return String.format("<%s id=\"%s\">", this.targetElement.getNodeName(), this.targetElement.id);
            }
            return "";
        }
    }

    private static interface PseudoClass {
        public boolean matches(RuleMatchContext var1, SVG.SvgElementBase var2);
    }

    private static class PseudoClassAnPlusB
    implements PseudoClass {
        private int a;
        private int b;
        private boolean isFromStart;
        private boolean isOfType;
        private String nodeName;

        PseudoClassAnPlusB(int n2, int n3, boolean bl2, boolean bl3, String string2) {
            this.a = n2;
            this.b = n3;
            this.isFromStart = bl2;
            this.isOfType = bl3;
            this.nodeName = string2;
        }

        @Override
        public boolean matches(RuleMatchContext object, SVG.SvgElementBase svgElementBase) {
            object = this.isOfType && this.nodeName == null ? svgElementBase.getNodeName() : this.nodeName;
            int n2 = 0;
            int n3 = 1;
            if (svgElementBase.parent != null) {
                n3 = 0;
                for (SVG.SvgElementBase svgElementBase2 : svgElementBase.parent.getChildren()) {
                    if (svgElementBase2 == svgElementBase) {
                        n2 = n3;
                    }
                    if (object != null && !svgElementBase2.getNodeName().equals(object)) continue;
                    ++n3;
                }
            }
            int n4 = n2 = this.isFromStart ? n2 + 1 : n3 - n2;
            if (this.a == 0) {
                return n2 == this.b;
            }
            return (n2 - this.b) % this.a == 0 && (Integer.signum(n2 - this.b) == 0 || Integer.signum(n2 - this.b) == Integer.signum(this.a));
        }

        public String toString() {
            String string2;
            String string3 = string2 = this.isFromStart ? "" : "last-";
            if (this.isOfType) {
                return String.format("nth-%schild(%dn%+d of type <%s>)", string2, this.a, this.b, this.nodeName);
            }
            return String.format("nth-%schild(%dn%+d)", string2, this.a, this.b);
        }
    }

    private static class PseudoClassOnlyChild
    implements PseudoClass {
        private boolean isOfType;
        private String nodeName;

        public PseudoClassOnlyChild(boolean bl2, String string2) {
            this.isOfType = bl2;
            this.nodeName = string2;
        }

        @Override
        public boolean matches(RuleMatchContext object, SVG.SvgElementBase object2) {
            Object object3 = object = this.isOfType && this.nodeName == null ? ((SVG.SvgObject)object2).getNodeName() : this.nodeName;
            if (((SVG.SvgElementBase)object2).parent != null) {
                int n2 = 0;
                object2 = ((SVG.SvgElementBase)object2).parent.getChildren().iterator();
                while (true) {
                    if (!object2.hasNext()) {
                        return n2 == 1;
                    }
                    SVG.SvgElementBase svgElementBase = (SVG.SvgElementBase)((SVG.SvgObject)object2.next());
                    if (object != null && !svgElementBase.getNodeName().equals(object)) continue;
                    ++n2;
                }
            }
            return true;
        }

        public String toString() {
            if (this.isOfType) {
                return String.format("only-of-type <%s>", this.nodeName);
            }
            return String.format("only-child", new Object[0]);
        }
    }

    private static class PseudoClassRoot
    implements PseudoClass {
        private PseudoClassRoot() {
        }

        @Override
        public boolean matches(RuleMatchContext ruleMatchContext, SVG.SvgElementBase svgElementBase) {
            return svgElementBase.parent == null;
        }

        public String toString() {
            return "root";
        }
    }

    private static class PseudoClassEmpty
    implements PseudoClass {
        private PseudoClassEmpty() {
        }

        @Override
        public boolean matches(RuleMatchContext ruleMatchContext, SVG.SvgElementBase svgElementBase) {
            if (svgElementBase instanceof SVG.SvgContainer) {
                return ((SVG.SvgContainer)((Object)svgElementBase)).getChildren().size() == 0;
            }
            return true;
        }

        public String toString() {
            return "empty";
        }
    }

    private static class PseudoClassNot
    implements PseudoClass {
        private List<Selector> selectorGroup;

        PseudoClassNot(List<Selector> list) {
            this.selectorGroup = list;
        }

        @Override
        public boolean matches(RuleMatchContext ruleMatchContext, SVG.SvgElementBase svgElementBase) {
            Selector selector;
            Iterator<Selector> iterator = this.selectorGroup.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!CSSParser.ruleMatch(ruleMatchContext, selector = iterator.next(), svgElementBase));
            return false;
        }

        int getSpecificity() {
            int n2 = Integer.MIN_VALUE;
            for (Selector selector : this.selectorGroup) {
                if (selector.specificity <= n2) continue;
                n2 = selector.specificity;
            }
            return n2;
        }

        public String toString() {
            return "not(" + this.selectorGroup + ")";
        }
    }

    private static class PseudoClassTarget
    implements PseudoClass {
        private PseudoClassTarget() {
        }

        @Override
        public boolean matches(RuleMatchContext ruleMatchContext, SVG.SvgElementBase svgElementBase) {
            if (ruleMatchContext != null) {
                return svgElementBase == ruleMatchContext.targetElement;
            }
            return false;
        }

        public String toString() {
            return "target";
        }
    }

    private static class PseudoClassNotSupported
    implements PseudoClass {
        private String clazz;

        PseudoClassNotSupported(String string2) {
            this.clazz = string2;
        }

        @Override
        public boolean matches(RuleMatchContext ruleMatchContext, SVG.SvgElementBase svgElementBase) {
            return false;
        }

        public String toString() {
            return this.clazz;
        }
    }
}

