/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.route;

public class GeoPoint {
    public int x;
    public int y;

    public GeoPoint() {
    }

    public GeoPoint(int n2, int n3) {
        this.x = n2;
        this.y = n3;
    }

    public GeoPoint(double d2, double d3) {
        this.latLongToPixels(d2, d3, 20);
    }

    public void setLonLat(double d2, double d3) {
        this.latLongToPixels(d2, d3, 20);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public double getLatitude() {
        double d2 = 2.0037508342789244E7 - (double)this.y * 0.1492910708694849;
        return (1.570796326794897 - 2.0 * Math.atan(Math.exp(-d2 / 6378137.0))) * 57.29577951308232;
    }

    public double getLongitude() {
        return ((double)this.x * 0.1492910708694849 - 2.0037508342789244E7) / 6378137.0 * 57.29577951308232;
    }

    private void latLongToPixels(double d2, double d3, int n2) {
        d3 = this.clip(d3, -85.0511287798, 85.0511287798) * Math.PI / 180.0;
        d2 = this.clip(d2, -180.0, 180.0) * Math.PI / 180.0;
        double d4 = Math.sin(d3);
        double d5 = 6378137.0 * d2;
        double d6 = Math.log((1.0 + d4) / (1.0 - d4));
        double d7 = 3189068.0 * d6;
        long l2 = 256L << n2;
        double d8 = 4.007501668557849E7 / (double)l2;
        this.x = (int)this.clip((2.0037508342789244E7 + d5) / d8 + 0.5, 0.0, l2 - 1L);
        double d9 = 2.0037508342789244E7 - d7;
        this.y = (int)this.clip(d9 / d8 + 0.5, 0.0, l2 - 1L);
    }

    private double clip(double d2, double d3, double d4) {
        return Math.min(Math.max(d2, d3), d4);
    }
}

