/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view.statusbar;

import android.content.Context;
import android.content.res.Resources;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import com.amap.api.col.3nl.ia;
import com.amap.api.navi.view.nightmode.NightModeTextView;
import com.amap.api.navi.view.statusbar.IStatusBarItemView;
import com.amap.api.navi.view.statusbar.TimeChangeBroadcastReceiver;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class StatusBarTimeItemView
extends NightModeTextView
implements IStatusBarItemView,
TimeChangeBroadcastReceiver.OnTimeChangeCallBack {
    private String mFormatBeforeDawn;
    private String mFormatForenoon;
    private String mFormatNoon;
    private String mFormatAfternoon;
    private String mFormatEvening;
    TimeChangeBroadcastReceiver receiver = null;

    public StatusBarTimeItemView(Context context) {
        this(context, null);
    }

    public StatusBarTimeItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public StatusBarTimeItemView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    @Override
    public void init() {
        Resources resources = ia.b(this.getContext());
        this.mFormatBeforeDawn = resources.getString(2131230739);
        this.mFormatForenoon = resources.getString(2131230741);
        this.mFormatNoon = resources.getString(2131230742);
        this.mFormatAfternoon = resources.getString(2131230738);
        this.mFormatEvening = resources.getString(2131230740);
        this.receiver = TimeChangeBroadcastReceiver.getInstance();
        this.receiver.addOnTimeChangeCallBack(this.getContext(), this);
        this.setDayNightModeTextColor(2131034156, 2131034157);
        this.setTextSize(0, resources.getDimensionPixelSize(2131165226));
        this.updateCurrentTime();
    }

    @Override
    public void onDestroy() {
        this.receiver.removeOnTimeChangeCallBack(this.getContext(), this);
    }

    @Override
    public void reloadItemView(int n2) {
    }

    public void updateCurrentTime() {
        String string2;
        if (DateFormat.is24HourFormat((Context)this.getContext())) {
            String string3 = new SimpleDateFormat("HH:mm", Locale.getDefault()).format(System.currentTimeMillis());
            this.setText(string3);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int n2 = calendar.get(9);
        int n3 = calendar.get(10);
        int n4 = calendar.get(12);
        if (n2 == 0) {
            if (n3 < 6) {
                string2 = this.mFormatBeforeDawn;
                if (n3 == 0) {
                    n3 = 12;
                }
            } else {
                string2 = this.mFormatForenoon;
            }
        } else if (n3 <= 0) {
            string2 = this.mFormatNoon;
            n3 = 12;
        } else {
            string2 = n3 < 6 ? this.mFormatAfternoon : this.mFormatEvening;
        }
        StatusBarTimeItemView statusBarTimeItemView = this;
        statusBarTimeItemView.setText(statusBarTimeItemView.getFormatTime(string2, n3, n4));
    }

    private String getFormatTime(String string2, int n2, int n3) {
        return String.format(string2 + "%s:%s", String.valueOf(n2), n3 < 10 ? "0".concat(String.valueOf(n3)) : Integer.valueOf(n3));
    }

    @Override
    public void onUpdate() {
        this.updateCurrentTime();
    }
}

