/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.amap.api.col.3nl.gf;
import com.amap.api.col.3nl.gi;
import com.amap.api.col.3nl.hw;
import com.amap.api.col.3nl.ia;
import com.amap.api.navi.R;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SlidingUpPanelLayout
extends ViewGroup {
    private static final String TAG = SlidingUpPanelLayout.class.getSimpleName();
    private static final int DEFAULT_PANEL_HEIGHT = 68;
    private static final float DEFAULT_ANCHOR_POINT = 1.0f;
    private static PanelState DEFAULT_SLIDE_STATE = PanelState.NAVI_SDK_COLLAPSED;
    private static final int DEFAULT_SHADOW_HEIGHT = 4;
    private static final int DEFAULT_FADE_COLOR = -1728053248;
    private static final int DEFAULT_MIN_FLING_VELOCITY = 400;
    private static final boolean DEFAULT_OVERLAY_FLAG = false;
    private static final boolean DEFAULT_CLIP_PANEL_FLAG = true;
    private static final int[] DEFAULT_ATTRS = new int[]{16842927};
    public static final String SLIDING_STATE = "sliding_state";
    private int mMinFlingVelocity = 400;
    private int mCoveredFadeColor = -1728053248;
    private static final int DEFAULT_PARALLAX_OFFSET = 0;
    private final Paint mCoveredFadePaint = new Paint();
    private final Drawable mShadowDrawable;
    private int mPanelHeight = -1;
    private int mShadowHeight = -1;
    private int mParallaxOffset = -1;
    private boolean mIsSlidingUp;
    private boolean mOverlayContent = false;
    private boolean mClipPanel = true;
    private View mDragView;
    private int mDragViewResId = -1;
    private View mScrollableView;
    private int mScrollableViewResId;
    private gf mScrollableViewHelper = new gf();
    private View mSlideableView;
    private View mMainView;
    private View mTopView;
    private PanelState mSlideState = DEFAULT_SLIDE_STATE;
    private PanelState mLastNotDraggingSlideState = DEFAULT_SLIDE_STATE;
    private float mSlideOffset;
    private int mSlideRange;
    private float mAnchorPoint = 1.0f;
    private boolean mIsUnableToDrag;
    private boolean mIsTouchEnabled;
    private float mPrevMotionY;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private boolean mIsScrollableViewHandlingTouch = false;
    private final List<PanelSlideListener> mPanelSlideListeners = new CopyOnWriteArrayList<PanelSlideListener>();
    private View.OnClickListener mFadeOnClickListener;
    private final gi mDragHelper;
    private boolean mFirstLayout = true;
    private final Rect mTmpRect = new Rect();
    public static final int ACTION_MASK = 255;

    public SlidingUpPanelLayout(Context context) {
        this(context, null);
    }

    public SlidingUpPanelLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SlidingUpPanelLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        if (this.isInEditMode()) {
            this.mShadowDrawable = null;
            this.mDragHelper = null;
            return;
        }
        Interpolator interpolator = null;
        if (attributeSet != null) {
            TypedArray typedArray;
            TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, DEFAULT_ATTRS);
            if (typedArray2 != null) {
                int n3 = typedArray2.getInt(0, 0);
                this.setGravity(n3);
                typedArray2.recycle();
            }
            if ((typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.amap_navi_SlidingUpPanelLayout)) != null) {
                this.mPanelHeight = typedArray.getDimensionPixelSize(0, -1);
                this.mShadowHeight = typedArray.getDimensionPixelSize(1, -1);
                this.mParallaxOffset = typedArray.getDimensionPixelSize(2, -1);
                this.mMinFlingVelocity = typedArray.getInt(4, 400);
                this.mCoveredFadeColor = typedArray.getColor(3, -1728053248);
                this.mDragViewResId = typedArray.getResourceId(5, -1);
                this.mScrollableViewResId = typedArray.getResourceId(6, -1);
                this.mOverlayContent = typedArray.getBoolean(7, false);
                this.mClipPanel = typedArray.getBoolean(8, true);
                this.mAnchorPoint = typedArray.getFloat(9, 1.0f);
                this.mSlideState = PanelState.values()[typedArray.getInt(10, DEFAULT_SLIDE_STATE.ordinal())];
                int n4 = typedArray.getResourceId(11, -1);
                if (n4 != -1) {
                    interpolator = AnimationUtils.loadInterpolator((Context)context, (int)n4);
                }
                typedArray.recycle();
            }
        }
        float f2 = context.getResources().getDisplayMetrics().density;
        if (this.mPanelHeight == -1) {
            this.mPanelHeight = (int)(68.0f * f2 + 0.5f);
        }
        if (this.mShadowHeight == -1) {
            this.mShadowHeight = (int)(4.0f * f2 + 0.5f);
        }
        if (this.mParallaxOffset == -1) {
            this.mParallaxOffset = (int)(0.0f * f2);
        }
        this.mShadowDrawable = this.mShadowHeight > 0 ? ia.b(context).getDrawable(this.mIsSlidingUp ? 2130837507 : 2130837535) : null;
        this.setWillNotDraw(false);
        this.mDragHelper = gi.a(this, interpolator, new a(0));
        this.mDragHelper.a((float)this.mMinFlingVelocity * f2);
        this.mIsTouchEnabled = true;
    }

    public void setTopView(View view) {
        this.mTopView = view;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mDragViewResId != -1) {
            SlidingUpPanelLayout slidingUpPanelLayout = this;
            slidingUpPanelLayout.setDragView(slidingUpPanelLayout.findViewById(this.mDragViewResId));
        }
        if (this.mScrollableViewResId != -1) {
            SlidingUpPanelLayout slidingUpPanelLayout = this;
            slidingUpPanelLayout.setScrollableView(slidingUpPanelLayout.findViewById(this.mScrollableViewResId));
        }
    }

    public void setGravity(int n2) {
        if (n2 != 48 && n2 != 80) {
            throw new IllegalArgumentException("gravity must be set to either top or bottom");
        }
        boolean bl2 = this.mIsSlidingUp = n2 == 80;
        if (!this.mFirstLayout) {
            this.requestLayout();
        }
    }

    public void setCoveredFadeColor(int n2) {
        this.mCoveredFadeColor = n2;
        this.requestLayout();
    }

    public int getCoveredFadeColor() {
        return this.mCoveredFadeColor;
    }

    public void setTouchEnabled(boolean bl2) {
        this.mIsTouchEnabled = bl2;
    }

    public boolean isTouchEnabled() {
        return this.mIsTouchEnabled && this.mSlideableView != null && this.mSlideState != PanelState.NAVI_SDK_HIDDEN;
    }

    public void setPanelHeight(int n2) {
        if (this.getPanelHeight() == n2) {
            return;
        }
        this.mPanelHeight = n2;
        if (!this.mFirstLayout) {
            this.requestLayout();
        }
        if (this.getPanelState() == PanelState.NAVI_SDK_COLLAPSED) {
            this.smoothToBottom();
            this.invalidate();
        }
    }

    protected void smoothToBottom() {
        this.smoothSlideTo(0.0f, 0);
    }

    public int getShadowHeight() {
        return this.mShadowHeight;
    }

    public void setShadowHeight(int n2) {
        this.mShadowHeight = n2;
        if (!this.mFirstLayout) {
            this.invalidate();
        }
    }

    public int getPanelHeight() {
        return this.mPanelHeight;
    }

    public int getCurrentParallaxOffset() {
        int n2 = (int)((float)this.mParallaxOffset * Math.max(this.mSlideOffset, 0.0f));
        if (this.mIsSlidingUp) {
            return -n2;
        }
        return n2;
    }

    public void setParallaxOffset(int n2) {
        this.mParallaxOffset = n2;
        if (!this.mFirstLayout) {
            this.requestLayout();
        }
    }

    public int getMinFlingVelocity() {
        return this.mMinFlingVelocity;
    }

    public void setMinFlingVelocity(int n2) {
        this.mMinFlingVelocity = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPanelSlideListener(PanelSlideListener panelSlideListener) {
        List<PanelSlideListener> list = this.mPanelSlideListeners;
        synchronized (list) {
            this.mPanelSlideListeners.add(panelSlideListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePanelSlideListener(PanelSlideListener panelSlideListener) {
        List<PanelSlideListener> list = this.mPanelSlideListeners;
        synchronized (list) {
            this.mPanelSlideListeners.remove(panelSlideListener);
            return;
        }
    }

    public void setFadeOnClickListener(View.OnClickListener onClickListener) {
        this.mFadeOnClickListener = onClickListener;
    }

    public void setDragView(View view) {
        if (this.mDragView != null) {
            this.mDragView.setOnClickListener(null);
        }
        this.mDragView = view;
        if (this.mDragView != null) {
            this.mDragView.setClickable(true);
            this.mDragView.setFocusable(false);
            this.mDragView.setFocusableInTouchMode(false);
            this.mDragView.setOnClickListener(new View.OnClickListener(){

                public final void onClick(View view) {
                    try {
                        if (!SlidingUpPanelLayout.this.isEnabled() || !SlidingUpPanelLayout.this.isTouchEnabled()) {
                            return;
                        }
                        if (SlidingUpPanelLayout.this.mSlideState != PanelState.NAVI_SDK_EXPANDED && SlidingUpPanelLayout.this.mSlideState != PanelState.NAVI_SDK_ANCHORED) {
                            if (SlidingUpPanelLayout.this.mAnchorPoint < 1.0f) {
                                SlidingUpPanelLayout.this.setPanelState(PanelState.NAVI_SDK_ANCHORED);
                                return;
                            }
                            SlidingUpPanelLayout.this.setPanelState(PanelState.NAVI_SDK_EXPANDED);
                            return;
                        }
                        SlidingUpPanelLayout.this.setPanelState(PanelState.NAVI_SDK_COLLAPSED);
                        return;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }
            });
        }
    }

    public void setDragView(int n2) {
        this.mDragViewResId = n2;
        SlidingUpPanelLayout slidingUpPanelLayout = this;
        slidingUpPanelLayout.setDragView(slidingUpPanelLayout.findViewById(n2));
    }

    public void setScrollableView(View view) {
        this.mScrollableView = view;
    }

    public void setAnchorPoint(float f2) {
        if (f2 > 0.0f && f2 <= 1.0f) {
            this.mAnchorPoint = f2;
            this.mFirstLayout = true;
            this.requestLayout();
        }
    }

    public float getAnchorPoint() {
        return this.mAnchorPoint;
    }

    public void setOverlayed(boolean bl2) {
        this.mOverlayContent = bl2;
    }

    public boolean isOverlayed() {
        return this.mOverlayContent;
    }

    public void setClipPanel(boolean bl2) {
        this.mClipPanel = bl2;
    }

    public boolean isClipPanel() {
        return this.mClipPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchOnPanelSlide(View view) {
        try {
            List<PanelSlideListener> list = this.mPanelSlideListeners;
            synchronized (list) {
                Iterator<PanelSlideListener> iterator = this.mPanelSlideListeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onPanelSlide(view, this.mSlideOffset);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchOnPanelStateChanged(View view, PanelState panelState, PanelState panelState2) {
        List<PanelSlideListener> list = this.mPanelSlideListeners;
        synchronized (list) {
            Iterator<PanelSlideListener> iterator = this.mPanelSlideListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPanelStateChanged(view, panelState, panelState2);
            }
        }
        this.sendAccessibilityEvent(32);
    }

    void updateObscuredViewVisibility() {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.getChildCount() == 0) {
            return;
        }
        int n6 = this.getPaddingLeft();
        int n7 = this.getWidth() - this.getPaddingRight();
        int n8 = this.getPaddingTop();
        int n9 = this.getHeight() - this.getPaddingBottom();
        if (this.mSlideableView != null && SlidingUpPanelLayout.hasOpaqueBackground(this.mSlideableView)) {
            n5 = this.mSlideableView.getLeft();
            n4 = this.mSlideableView.getRight();
            n3 = this.mSlideableView.getTop();
            n2 = this.mSlideableView.getBottom();
        } else {
            n2 = 0;
            n3 = 0;
            n4 = 0;
            n5 = 0;
        }
        View view = this.getChildAt(0);
        n6 = Math.max(n6, view.getLeft());
        n8 = Math.max(n8, view.getTop());
        n7 = Math.min(n7, view.getRight());
        n9 = Math.min(n9, view.getBottom());
        n6 = n6 >= n5 && n8 >= n3 && n7 <= n4 && n9 <= n2 ? 4 : 0;
        view.setVisibility(n6);
    }

    void setAllChildrenVisible() {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 4) continue;
            view.setVisibility(0);
        }
    }

    private static boolean hasOpaqueBackground(View view) {
        return (view = view.getBackground()) != null && view.getOpacity() == -1;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int n2, int n3) {
        try {
            int n4 = View.MeasureSpec.getMode((int)n2);
            n2 = View.MeasureSpec.getSize((int)n2);
            int n5 = View.MeasureSpec.getMode((int)n3);
            n3 = View.MeasureSpec.getSize((int)n3);
            if (n4 != 0x40000000 && n4 != Integer.MIN_VALUE) {
                throw new IllegalStateException("Width must have an exact value or MATCH_PARENT");
            }
            if (n5 != 0x40000000 && n5 != Integer.MIN_VALUE) {
                throw new IllegalStateException("Height must have an exact value or MATCH_PARENT");
            }
            n4 = this.getChildCount();
            if (n4 != 2) {
                throw new IllegalStateException("Sliding up panel layout must have exactly 2 children!");
            }
            this.mMainView = this.getChildAt(0);
            this.mSlideableView = this.getChildAt(1);
            if (this.mDragView == null) {
                SlidingUpPanelLayout slidingUpPanelLayout = this;
                slidingUpPanelLayout.setDragView(slidingUpPanelLayout.mSlideableView);
            }
            if (this.mSlideableView.getVisibility() != 0) {
                this.mSlideState = PanelState.NAVI_SDK_HIDDEN;
            }
            n5 = n3 - this.getPaddingTop() - this.getPaddingBottom();
            int n6 = n2 - this.getPaddingLeft() - this.getPaddingRight();
            for (int i2 = 0; i2 < n4; ++i2) {
                int n7;
                View view = this.getChildAt(i2);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (view.getVisibility() == 8 && i2 == 0) continue;
                int n8 = n5;
                int n9 = n6;
                if (view == this.mMainView) {
                    if (!this.mOverlayContent && this.mSlideState != PanelState.NAVI_SDK_HIDDEN) {
                        n8 = n5 - this.mPanelHeight;
                    }
                    n9 = n6 - (layoutParams.leftMargin + layoutParams.rightMargin);
                } else if (view == this.mSlideableView) {
                    n8 = n5 - layoutParams.topMargin;
                }
                n9 = layoutParams.width == -2 ? View.MeasureSpec.makeMeasureSpec((int)n9, (int)Integer.MIN_VALUE) : (layoutParams.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)n9, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)layoutParams.width, (int)0x40000000));
                if (layoutParams.height == -2) {
                    n7 = View.MeasureSpec.makeMeasureSpec((int)n8, (int)Integer.MIN_VALUE);
                } else {
                    if (layoutParams.weight > 0.0f && layoutParams.weight < 1.0f) {
                        n8 = (int)((float)n8 * layoutParams.weight);
                    } else if (layoutParams.height != -1) {
                        n8 = layoutParams.height;
                    }
                    n7 = View.MeasureSpec.makeMeasureSpec((int)n8, (int)0x40000000);
                }
                view.measure(n9, n7);
                if (view != this.mSlideableView) continue;
                this.mSlideRange = this.mSlideableView.getMeasuredHeight() - this.mPanelHeight;
            }
            this.setMeasuredDimension(n2, n3);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        try {
            int n6;
            int n7 = this.getPaddingLeft();
            int n8 = this.getPaddingTop();
            int n9 = this.getChildCount();
            if (this.mFirstLayout) {
                switch (this.mSlideState) {
                    case NAVI_SDK_EXPANDED: {
                        this.mSlideOffset = 1.0f;
                        break;
                    }
                    case NAVI_SDK_ANCHORED: {
                        this.mSlideOffset = this.mAnchorPoint;
                        break;
                    }
                    case NAVI_SDK_HIDDEN: {
                        n6 = this.computePanelTopPosition(0.0f) + (this.mIsSlidingUp ? this.mPanelHeight : -this.mPanelHeight);
                        this.mSlideOffset = this.computeSlideOffset(n6);
                        break;
                    }
                    default: {
                        this.mSlideOffset = 0.0f;
                    }
                }
            }
            for (n6 = 0; n6 < n9; ++n6) {
                View view = this.getChildAt(n6);
                LayoutParams n82 = (LayoutParams)view.getLayoutParams();
                if (view.getVisibility() == 8 && (n6 == 0 || this.mFirstLayout)) continue;
                int n10 = view.getMeasuredHeight();
                int n11 = n8;
                if (view == this.mSlideableView) {
                    SlidingUpPanelLayout slidingUpPanelLayout = this;
                    n11 = slidingUpPanelLayout.computePanelTopPosition(slidingUpPanelLayout.mSlideOffset);
                }
                if (!this.mIsSlidingUp && view == this.mMainView && !this.mOverlayContent) {
                    SlidingUpPanelLayout slidingUpPanelLayout = this;
                    n11 = slidingUpPanelLayout.computePanelTopPosition(slidingUpPanelLayout.mSlideOffset) + this.mSlideableView.getMeasuredHeight();
                }
                n10 = n11 + n10;
                int n12 = n7 + n82.leftMargin;
                int n13 = n12 + view.getMeasuredWidth();
                view.layout(n12, n11, n13, n10);
            }
            if (this.mFirstLayout) {
                this.updateObscuredViewVisibility();
            }
            this.applyParallaxForCurrentSlideOffset();
            this.mFirstLayout = false;
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (n3 != n5) {
            this.mFirstLayout = true;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (this.mIsScrollableViewHandlingTouch || !this.isTouchEnabled()) {
            this.mDragHelper.d();
            return false;
        }
        int n2 = SlidingUpPanelLayout.getActionMasked(motionEvent);
        float f2 = motionEvent.getX();
        float f3 = motionEvent.getY();
        float f4 = Math.abs(f2 - this.mInitialMotionX);
        float f5 = Math.abs(f3 - this.mInitialMotionY);
        int n3 = this.mDragHelper.b();
        switch (n2) {
            case 0: {
                this.mIsUnableToDrag = false;
                this.mInitialMotionX = f2;
                this.mInitialMotionY = f3;
                SlidingUpPanelLayout slidingUpPanelLayout = this;
                if (slidingUpPanelLayout.isViewUnder(slidingUpPanelLayout.mDragView, (int)f2, (int)f3)) break;
                this.mDragHelper.c();
                this.mIsUnableToDrag = true;
                return false;
            }
            case 2: {
                if (!(f5 > (float)n3) || !(f4 > f5)) break;
                this.mDragHelper.c();
                this.mIsUnableToDrag = true;
                return false;
            }
            case 1: 
            case 3: {
                if (this.mDragHelper.f()) {
                    this.mDragHelper.b(motionEvent);
                    return true;
                }
                if (!(f5 <= (float)n3) || !(f4 <= (float)n3) || !(this.mSlideOffset > 0.0f)) break;
                SlidingUpPanelLayout slidingUpPanelLayout = this;
                if (slidingUpPanelLayout.isViewUnder(slidingUpPanelLayout.mSlideableView, (int)this.mInitialMotionX, (int)this.mInitialMotionY) || this.mFadeOnClickListener == null) break;
                this.playSoundEffect(0);
                this.mFadeOnClickListener.onClick((View)this);
                return true;
            }
        }
        return this.mDragHelper.a(motionEvent);
    }

    private boolean dodo(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            int[] nArray = new int[2];
            this.getLocationOnScreen(nArray);
            this.mDragView.getLocationOnScreen(nArray);
            if ((int)motionEvent.getX() >= nArray[0] && (int)motionEvent.getY() + 100 < nArray[1]) {
                return super.onTouchEvent(motionEvent);
            }
        }
        return true;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.isEnabled() || !this.isTouchEnabled()) {
            return super.onTouchEvent(motionEvent);
        }
        try {
            if (this.mDragHelper.b(motionEvent)) {
                return true;
            }
            return super.onTouchEvent(motionEvent);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static int getActionMasked(MotionEvent motionEvent) {
        return motionEvent.getAction() & 0xFF;
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (!this.dodo(motionEvent)) {
            return false;
        }
        int n2 = SlidingUpPanelLayout.getActionMasked(motionEvent);
        if (!this.isEnabled() || !this.isTouchEnabled() || this.mIsUnableToDrag && n2 != 0) {
            this.mDragHelper.d();
            return super.dispatchTouchEvent(motionEvent);
        }
        float f2 = motionEvent.getY();
        if (n2 == 0) {
            this.mIsScrollableViewHandlingTouch = false;
            this.mPrevMotionY = f2;
        } else if (n2 == 2) {
            float f3 = f2 - this.mPrevMotionY;
            this.mPrevMotionY = f2;
            SlidingUpPanelLayout slidingUpPanelLayout = this;
            if (!slidingUpPanelLayout.isViewUnder(slidingUpPanelLayout.mScrollableView, (int)this.mInitialMotionX, (int)this.mInitialMotionY)) {
                return super.dispatchTouchEvent(motionEvent);
            }
            int n3 = this.mIsSlidingUp ? 1 : -1;
            if (f3 * (float)n3 > 0.0f) {
                if (gf.a(this.mScrollableView, this.mIsSlidingUp) > 0) {
                    this.mIsScrollableViewHandlingTouch = true;
                    return super.dispatchTouchEvent(motionEvent);
                }
                if (this.mIsScrollableViewHandlingTouch) {
                    MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                    motionEvent2.setAction(3);
                    super.dispatchTouchEvent(motionEvent2);
                    motionEvent2.recycle();
                    motionEvent.setAction(0);
                }
                this.mIsScrollableViewHandlingTouch = false;
                return this.onTouchEvent(motionEvent);
            }
            int n4 = this.mIsSlidingUp ? 1 : -1;
            if (f3 * (float)n4 < 0.0f) {
                if (this.mSlideOffset < 1.0f) {
                    this.mIsScrollableViewHandlingTouch = false;
                    return this.onTouchEvent(motionEvent);
                }
                if (!this.mIsScrollableViewHandlingTouch && this.mDragHelper.f()) {
                    this.mDragHelper.c();
                    motionEvent.setAction(0);
                }
                this.mIsScrollableViewHandlingTouch = true;
                return super.dispatchTouchEvent(motionEvent);
            }
        } else if (n2 == 1 && this.mIsScrollableViewHandlingTouch) {
            this.mDragHelper.a(0);
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    private boolean isViewUnder(View view, int n2, int n3) {
        if (view == null) {
            return false;
        }
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        int[] nArray2 = new int[2];
        this.getLocationOnScreen(nArray2);
        n2 = nArray2[0] + n2;
        n3 = nArray2[1] + n3;
        return n2 >= nArray[0] && n2 < nArray[0] + view.getWidth() && n3 >= nArray[1] && n3 < nArray[1] + view.getHeight();
    }

    private int computePanelTopPosition(float f2) {
        int n2 = this.mSlideableView != null ? this.mSlideableView.getMeasuredHeight() : 0;
        int n3 = (int)(f2 * (float)this.mSlideRange);
        if (this.mIsSlidingUp) {
            return this.getMeasuredHeight() - this.getPaddingBottom() - this.mPanelHeight - n3;
        }
        return this.getPaddingTop() - n2 + this.mPanelHeight + n3;
    }

    private float computeSlideOffset(int n2) {
        int n3 = this.computePanelTopPosition(0.0f);
        if (this.mIsSlidingUp) {
            return (float)(n3 - n2) / (float)this.mSlideRange;
        }
        return (float)(n2 - n3) / (float)this.mSlideRange;
    }

    public PanelState getPanelState() {
        return this.mSlideState;
    }

    public void setPanelState(PanelState panelState) {
        if (panelState == null || panelState == PanelState.NAVI_SDK_DRAGGING) {
            throw new IllegalArgumentException("Panel state cannot be null or DRAGGING.");
        }
        if (!this.isEnabled() || !this.mFirstLayout && this.mSlideableView == null || panelState == this.mSlideState || this.mSlideState == PanelState.NAVI_SDK_DRAGGING) {
            return;
        }
        if (this.mFirstLayout) {
            this.setPanelStateInternal(panelState);
            return;
        }
        if (this.mSlideState == PanelState.NAVI_SDK_HIDDEN) {
            this.mSlideableView.setVisibility(0);
            this.requestLayout();
        }
        switch (panelState) {
            case NAVI_SDK_ANCHORED: {
                SlidingUpPanelLayout slidingUpPanelLayout = this;
                slidingUpPanelLayout.smoothSlideTo(slidingUpPanelLayout.mAnchorPoint, 0);
                return;
            }
            case NAVI_SDK_COLLAPSED: {
                this.smoothSlideTo(0.0f, 0);
                return;
            }
            case NAVI_SDK_EXPANDED: {
                this.smoothSlideTo(1.0f, 0);
                return;
            }
            case NAVI_SDK_HIDDEN: {
                int n2 = this.computePanelTopPosition(0.0f) + (this.mIsSlidingUp ? this.mPanelHeight : -this.mPanelHeight);
                SlidingUpPanelLayout slidingUpPanelLayout = this;
                slidingUpPanelLayout.smoothSlideTo(slidingUpPanelLayout.computeSlideOffset(n2), 0);
            }
        }
    }

    private void setPanelStateInternal(PanelState panelState) {
        if (this.mSlideState == panelState) {
            return;
        }
        PanelState panelState2 = this.mSlideState;
        this.mSlideState = panelState;
        SlidingUpPanelLayout slidingUpPanelLayout = this;
        slidingUpPanelLayout.dispatchOnPanelStateChanged((View)slidingUpPanelLayout, panelState2, panelState);
    }

    @SuppressLint(value={"NewApi"})
    private void applyParallaxForCurrentSlideOffset() {
        if (this.mParallaxOffset > 0) {
            int n2 = this.getCurrentParallaxOffset();
            this.mMainView.setTranslationY((float)n2);
        }
    }

    private void applyParallaxForTopOffset(int n2) {
        if (this.mTopView != null) {
            int n3 = this.mTopView.getHeight();
            if ((n2 = n2 - hw.a(this.getContext(), 100) - n3) > 0) {
                n2 = 0;
            }
            if (n2 < -n3) {
                n2 = -n3;
            }
            this.mTopView.setTranslationY((float)n2);
        }
    }

    private void onPanelDragged(int n2) {
        if (this.mSlideState != PanelState.NAVI_SDK_DRAGGING) {
            this.mLastNotDraggingSlideState = this.mSlideState;
        }
        this.setPanelStateInternal(PanelState.NAVI_SDK_DRAGGING);
        this.mSlideOffset = this.computeSlideOffset(n2);
        this.applyParallaxForCurrentSlideOffset();
        SlidingUpPanelLayout slidingUpPanelLayout = this;
        slidingUpPanelLayout.dispatchOnPanelSlide(slidingUpPanelLayout.mSlideableView);
        LayoutParams layoutParams = (LayoutParams)this.mMainView.getLayoutParams();
        int n3 = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop() - this.mPanelHeight;
        if (this.mSlideOffset <= 0.0f && !this.mOverlayContent) {
            int n4 = layoutParams.height = this.mIsSlidingUp ? n2 - this.getPaddingBottom() : this.getHeight() - this.getPaddingBottom() - this.mSlideableView.getMeasuredHeight() - n2;
            if (layoutParams.height == n3) {
                layoutParams.height = -1;
            }
            this.mMainView.requestLayout();
            return;
        }
        if (layoutParams.height != -1 && !this.mOverlayContent) {
            layoutParams.height = -1;
            this.mMainView.requestLayout();
        }
    }

    protected boolean drawChild(Canvas canvas, View view, long l2) {
        boolean bl2;
        int n2 = canvas.save();
        if (this.mSlideableView != null && this.mSlideableView != view) {
            canvas.getClipBounds(this.mTmpRect);
            if (!this.mOverlayContent) {
                if (this.mIsSlidingUp) {
                    this.mTmpRect.bottom = Math.min(this.mTmpRect.bottom, this.mSlideableView.getTop());
                } else {
                    this.mTmpRect.top = Math.max(this.mTmpRect.top, this.mSlideableView.getBottom());
                }
            }
            if (this.mClipPanel) {
                canvas.clipRect(this.mTmpRect);
            }
            bl2 = super.drawChild(canvas, view, l2);
            if (this.mCoveredFadeColor != 0 && this.mSlideOffset > 0.0f) {
                int n3 = (int)((float)((this.mCoveredFadeColor & 0xFF000000) >>> 24) * this.mSlideOffset) << 24 | this.mCoveredFadeColor & 0xFFFFFF;
                this.mCoveredFadePaint.setColor(n3);
                canvas.drawRect(this.mTmpRect, this.mCoveredFadePaint);
            }
        } else {
            bl2 = super.drawChild(canvas, view, l2);
        }
        canvas.restoreToCount(n2);
        return bl2;
    }

    boolean smoothSlideTo(float f2, int n2) {
        if (!this.isEnabled() || this.mSlideableView == null) {
            return false;
        }
        int n3 = this.computePanelTopPosition(f2);
        if (this.mDragHelper.a(this.mSlideableView, this.mSlideableView.getLeft(), n3)) {
            this.setAllChildrenVisible();
            this.invalidate();
            return true;
        }
        return false;
    }

    public void computeScroll() {
        if (this.mDragHelper != null && this.mDragHelper.e()) {
            if (!this.isEnabled()) {
                this.mDragHelper.d();
                return;
            }
            this.invalidate();
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mShadowDrawable != null && this.mSlideableView != null) {
            int n2;
            int n3;
            int n4 = this.mSlideableView.getRight();
            if (this.mIsSlidingUp) {
                n3 = this.mSlideableView.getTop() - this.mShadowHeight;
                n2 = this.mSlideableView.getTop();
            } else {
                n3 = this.mSlideableView.getBottom();
                n2 = this.mSlideableView.getBottom() + this.mShadowHeight;
            }
            int n5 = this.mSlideableView.getLeft();
            this.mShadowDrawable.setBounds(n5, n3, n4, n2);
            this.mShadowDrawable.draw(canvas);
        }
    }

    protected boolean canScroll(View view, boolean bl2, int n2, int n3, int n4) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n5 = view.getScrollX();
            int n6 = view.getScrollY();
            for (int i2 = viewGroup.getChildCount() - 1; i2 >= 0; --i2) {
                View view2 = viewGroup.getChildAt(i2);
                if (n3 + n5 < view2.getLeft() || n3 + n5 >= view2.getRight() || n4 + n6 < view2.getTop() || n4 + n6 >= view2.getBottom() || !this.canScroll(view2, true, n2, n3 + n5 - view2.getLeft(), n4 + n6 - view2.getTop())) continue;
                return true;
            }
        }
        return bl2 && view.canScrollHorizontally(-n2);
    }

    public boolean canScrollHorizontally(int n2) {
        int n3 = this.computeHorizontalScrollOffset();
        int n4 = this.computeHorizontalScrollRange() - this.computeHorizontalScrollExtent();
        if (n4 == 0) {
            return false;
        }
        if (n2 < 0) {
            return n3 > 0;
        }
        return n3 < n4 - 1;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams && super.checkLayoutParams(layoutParams);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putSerializable(SLIDING_STATE, (Serializable)((Object)(this.mSlideState != PanelState.NAVI_SDK_DRAGGING ? this.mSlideState : this.mLastNotDraggingSlideState)));
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof Bundle) {
            parcelable = (Bundle)parcelable;
            this.mSlideState = (PanelState)((Object)parcelable.getSerializable(SLIDING_STATE));
            this.mSlideState = this.mSlideState == null ? DEFAULT_SLIDE_STATE : this.mSlideState;
            parcelable = parcelable.getParcelable("superState");
        }
        super.onRestoreInstanceState(parcelable);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int[] ATTRS = new int[]{0x1010181};
        public float weight = 0.0f;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
        }

        public LayoutParams(int n2, int n3, float f2) {
            super(n2, n3);
            this.weight = f2;
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.MarginLayoutParams)layoutParams);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = context.obtainStyledAttributes(attributeSet, ATTRS);
            if (context != null) {
                this.weight = context.getFloat(0, 0.0f);
                context.recycle();
            }
        }
    }

    private final class a
    extends gi.a {
        private a() {
        }

        @Override
        public final boolean a(View view) {
            return !SlidingUpPanelLayout.this.mIsUnableToDrag && view == SlidingUpPanelLayout.this.mSlideableView;
        }

        @Override
        public final void a() {
            if (SlidingUpPanelLayout.this.mDragHelper != null && SlidingUpPanelLayout.this.mDragHelper.a() == 0) {
                SlidingUpPanelLayout.this.mSlideOffset = SlidingUpPanelLayout.this.computeSlideOffset(SlidingUpPanelLayout.this.mSlideableView.getTop());
                SlidingUpPanelLayout.this.applyParallaxForCurrentSlideOffset();
                if (SlidingUpPanelLayout.this.mSlideOffset == 1.0f) {
                    SlidingUpPanelLayout.this.updateObscuredViewVisibility();
                    SlidingUpPanelLayout.this.setPanelStateInternal(PanelState.NAVI_SDK_EXPANDED);
                    return;
                }
                if (SlidingUpPanelLayout.this.mSlideOffset == 0.0f) {
                    SlidingUpPanelLayout.this.setPanelStateInternal(PanelState.NAVI_SDK_COLLAPSED);
                    return;
                }
                if (SlidingUpPanelLayout.this.mSlideOffset < 0.0f) {
                    SlidingUpPanelLayout.this.setPanelStateInternal(PanelState.NAVI_SDK_HIDDEN);
                    SlidingUpPanelLayout.this.mSlideableView.setVisibility(4);
                    return;
                }
                SlidingUpPanelLayout.this.updateObscuredViewVisibility();
                SlidingUpPanelLayout.this.setPanelStateInternal(PanelState.NAVI_SDK_ANCHORED);
            }
        }

        @Override
        public final void b() {
            SlidingUpPanelLayout.this.setAllChildrenVisible();
        }

        @Override
        public final void a(int n2) {
            SlidingUpPanelLayout.this.onPanelDragged(n2);
            SlidingUpPanelLayout.this.applyParallaxForTopOffset(n2);
            SlidingUpPanelLayout.this.invalidate();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public final void a(View var1_1, float var2_2) {
            block6: {
                block8: {
                    block7: {
                        block5: {
                            v0 = var2_2 = SlidingUpPanelLayout.access$1200(SlidingUpPanelLayout.this) != false ? -var2_2 : var2_2;
                            if (!(v0 > 0.0f) || !(SlidingUpPanelLayout.access$600(SlidingUpPanelLayout.this) <= SlidingUpPanelLayout.access$200(SlidingUpPanelLayout.this))) break block5;
                            var2_3 = SlidingUpPanelLayout.access$1300(SlidingUpPanelLayout.this, SlidingUpPanelLayout.access$200(SlidingUpPanelLayout.this));
                            break block6;
                        }
                        if (!(var2_2 > 0.0f) || !(SlidingUpPanelLayout.access$600(SlidingUpPanelLayout.this) > SlidingUpPanelLayout.access$200(SlidingUpPanelLayout.this))) break block7;
                        var2_3 = SlidingUpPanelLayout.access$1300(SlidingUpPanelLayout.this, 1.0f);
                        break block6;
                    }
                    if (!(var2_2 < 0.0f) || !(SlidingUpPanelLayout.access$600(SlidingUpPanelLayout.this) >= SlidingUpPanelLayout.access$200(SlidingUpPanelLayout.this))) break block8;
                    var2_3 = SlidingUpPanelLayout.access$1300(SlidingUpPanelLayout.this, SlidingUpPanelLayout.access$200(SlidingUpPanelLayout.this));
                    break block6;
                }
                if (var2_2 < 0.0f && SlidingUpPanelLayout.access$600(SlidingUpPanelLayout.this) < SlidingUpPanelLayout.access$200(SlidingUpPanelLayout.this)) ** GOTO lbl-1000
                if (SlidingUpPanelLayout.access$600(SlidingUpPanelLayout.this) >= (1.0f + SlidingUpPanelLayout.access$200(SlidingUpPanelLayout.this)) / 2.0f) {
                    var2_3 = SlidingUpPanelLayout.access$1300(SlidingUpPanelLayout.this, 1.0f);
                } else if (SlidingUpPanelLayout.access$600(SlidingUpPanelLayout.this) >= SlidingUpPanelLayout.access$200(SlidingUpPanelLayout.this) / 2.0f) {
                    var2_3 = SlidingUpPanelLayout.access$1300(SlidingUpPanelLayout.this, SlidingUpPanelLayout.access$200(SlidingUpPanelLayout.this));
                } else lbl-1000:
                // 2 sources

                {
                    var2_3 = SlidingUpPanelLayout.access$1300(SlidingUpPanelLayout.this, 0.0f);
                }
            }
            if (SlidingUpPanelLayout.access$500(SlidingUpPanelLayout.this) != null) {
                SlidingUpPanelLayout.access$500(SlidingUpPanelLayout.this).a(var1_1.getLeft(), var2_3);
            }
            SlidingUpPanelLayout.this.invalidate();
        }

        @Override
        public final int c() {
            return SlidingUpPanelLayout.this.mSlideRange;
        }

        @Override
        public final int c(int n2) {
            int n3 = SlidingUpPanelLayout.this.computePanelTopPosition(0.0f);
            int n4 = SlidingUpPanelLayout.this.computePanelTopPosition(1.0f);
            if (SlidingUpPanelLayout.this.mIsSlidingUp) {
                return Math.min(Math.max(n2, n4), n3);
            }
            return Math.min(Math.max(n2, n3), n4);
        }

        /* synthetic */ a(byte by2) {
            this();
        }
    }

    public static class SimplePanelSlideListener
    implements PanelSlideListener {
        @Override
        public void onPanelSlide(View view, float f2) {
        }

        @Override
        public void onPanelStateChanged(View view, PanelState panelState, PanelState panelState2) {
        }
    }

    public static interface PanelSlideListener {
        public void onPanelSlide(View var1, float var2);

        public void onPanelStateChanged(View var1, PanelState var2, PanelState var3);
    }

    public static enum PanelState {
        NAVI_SDK_EXPANDED,
        NAVI_SDK_COLLAPSED,
        NAVI_SDK_ANCHORED,
        NAVI_SDK_HIDDEN,
        NAVI_SDK_DRAGGING;

    }
}

