/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import com.amap.api.col.3nl.hw;
import com.amap.api.col.3nl.ia;
import com.amap.api.maps.AMap;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.navi.model.AMapNaviForbiddenInfo;
import com.amap.api.navi.model.AMapNaviLimitInfo;
import com.amap.api.navi.model.AMapNotAvoidInfo;
import com.amap.api.navi.model.AMapTrafficIncidentInfo;
import com.amap.api.navi.model.NaviLatLng;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NaviLimitOverlay {
    private AMap aMap;
    private BitmapDescriptor limitHeightDescriptor;
    private BitmapDescriptor limitWidthDescriptor;
    private BitmapDescriptor limitGoStraightDescriptor;
    private BitmapDescriptor limitTurnLeftDescriptor;
    private BitmapDescriptor limitTurnRightDescriptor;
    private BitmapDescriptor limitTurnLeftRoundDescriptor;
    private BitmapDescriptor limitTurnRightRoundDescriptor;
    private BitmapDescriptor routeClosedRoundDescriptor;
    private List<Marker> markers = new ArrayList<Marker>();

    public NaviLimitOverlay(Context context, AMap aMap) {
        try {
            this.aMap = aMap;
            context = ia.b(context);
            this.limitHeightDescriptor = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)context, (int)2130838041));
            this.limitWidthDescriptor = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)context, (int)2130838042));
            this.limitGoStraightDescriptor = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)context, (int)2130838040));
            this.limitTurnLeftDescriptor = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)context, (int)2130838036));
            this.limitTurnRightDescriptor = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)context, (int)2130838037));
            this.limitTurnLeftRoundDescriptor = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)context, (int)2130838038));
            this.limitTurnRightRoundDescriptor = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)context, (int)2130838039));
            this.routeClosedRoundDescriptor = BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeResource((Resources)context, (int)2130837957));
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void drawLimitInfo(List<AMapNaviLimitInfo> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AMapNaviLimitInfo aMapNaviLimitInfo = list.get(i2);
            this.handleLimitAndAddMarker(aMapNaviLimitInfo);
        }
    }

    public void drawForbiddenInfo(List<AMapNaviForbiddenInfo> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AMapNaviForbiddenInfo aMapNaviForbiddenInfo = list.get(i2);
            this.handleForbiddenAndAddMarker(aMapNaviForbiddenInfo);
        }
    }

    public void drawIncidentInfo(List<AMapTrafficIncidentInfo> object) {
        object = object.iterator();
        while (object.hasNext()) {
            AMapTrafficIncidentInfo aMapTrafficIncidentInfo = (AMapTrafficIncidentInfo)object.next();
            this.handleIncidentAndAddMarker(aMapTrafficIncidentInfo);
        }
    }

    private void handleForbiddenAndAddMarker(AMapNaviForbiddenInfo aMapNaviForbiddenInfo) {
        BitmapDescriptor bitmapDescriptor = null;
        switch (aMapNaviForbiddenInfo.forbiddenType) {
            case 0: {
                bitmapDescriptor = this.limitTurnLeftDescriptor;
                break;
            }
            case 1: {
                bitmapDescriptor = this.limitTurnRightDescriptor;
                break;
            }
            case 2: {
                bitmapDescriptor = this.limitTurnLeftRoundDescriptor;
                break;
            }
            case 3: {
                bitmapDescriptor = this.limitTurnRightRoundDescriptor;
                break;
            }
            case 4: {
                bitmapDescriptor = this.limitGoStraightDescriptor;
            }
        }
        if (bitmapDescriptor != null) {
            this.addMarker(bitmapDescriptor, new LatLng(aMapNaviForbiddenInfo.latitude, aMapNaviForbiddenInfo.longitude)).setObject(aMapNaviForbiddenInfo);
        }
    }

    private void handleLimitAndAddMarker(AMapNaviLimitInfo aMapNaviLimitInfo) {
        BitmapDescriptor bitmapDescriptor = null;
        switch (aMapNaviLimitInfo.type) {
            case 82: {
                bitmapDescriptor = this.limitWidthDescriptor;
                break;
            }
            case 81: {
                bitmapDescriptor = this.limitHeightDescriptor;
            }
        }
        if (bitmapDescriptor != null) {
            this.addMarker(bitmapDescriptor, new LatLng(aMapNaviLimitInfo.latitude, aMapNaviLimitInfo.longitude)).setObject(aMapNaviLimitInfo);
        }
    }

    private void handleIncidentAndAddMarker(AMapTrafficIncidentInfo aMapTrafficIncidentInfo) {
        BitmapDescriptor bitmapDescriptor = null;
        switch (aMapTrafficIncidentInfo.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                bitmapDescriptor = this.routeClosedRoundDescriptor;
            }
        }
        if (bitmapDescriptor != null) {
            this.addMarker(bitmapDescriptor, new LatLng(aMapTrafficIncidentInfo.getLatitude(), aMapTrafficIncidentInfo.getLongitude())).setObject(aMapTrafficIncidentInfo);
        }
    }

    public void handlePassLimitAndForbidden(AMapNotAvoidInfo aMapNotAvoidInfo) {
        try {
            int n2 = -1;
            for (int i2 = 0; i2 < this.markers.size(); ++i2) {
                Object object;
                Marker marker = this.markers.get(i2);
                LatLng latLng = marker.getPosition();
                float f2 = hw.a(new NaviLatLng(aMapNotAvoidInfo.coord2D.getLatitude(), aMapNotAvoidInfo.coord2D.getLongitude()), new NaviLatLng(latLng.latitude, latLng.longitude));
                if (marker.getObject() instanceof AMapNaviLimitInfo) {
                    object = (AMapNaviLimitInfo)marker.getObject();
                    if (!(f2 < 10.0f) || ((AMapNaviLimitInfo)object).type != aMapNotAvoidInfo.type + 80) continue;
                    n2 = i2;
                    marker.remove();
                    break;
                }
                if (!(marker.getObject() instanceof AMapNaviForbiddenInfo)) continue;
                object = (AMapNaviForbiddenInfo)marker.getObject();
                if (!(f2 < 10.0f) || ((AMapNaviForbiddenInfo)object).forbiddenType != aMapNotAvoidInfo.forbidType) continue;
                n2 = i2;
                marker.remove();
                break;
            }
            if (n2 >= 0) {
                this.markers.remove(n2);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private Marker addMarker(BitmapDescriptor object, LatLng latLng) {
        object = this.aMap.addMarker(new MarkerOptions().position(latLng).anchor(0.5f, 0.5f).icon((BitmapDescriptor)object));
        this.markers.add((Marker)object);
        return object;
    }

    public void destroy() {
        try {
            this.removeAllMarker();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void removeAllMarker() {
        try {
            Iterator<Marker> iterator = this.markers.iterator();
            while (iterator.hasNext()) {
                iterator.next().remove();
            }
            this.markers.clear();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void setVisible(boolean bl2) {
        try {
            Iterator<Marker> iterator = this.markers.iterator();
            while (iterator.hasNext()) {
                iterator.next().setVisible(bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }
}

