/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.graphics.Color;
import android.util.Log;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.Gradient;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.WeightedLatLng;
import com.autonavi.base.amap.mapcore.jbinding.JBindingExclude;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JBindingInclude
public class HeatMapLayerOptions
extends BaseOptions {
    @JBindingExclude
    public static final int DEFAULT_RADIUS = 12;
    @JBindingExclude
    public static final double DEFAULT_OPACITY = 0.6;
    @JBindingExclude
    private static final int[] DEFAULT_GRADIENT_COLORS = new int[]{Color.rgb((int)102, (int)225, (int)0), Color.rgb((int)255, (int)0, (int)0)};
    @JBindingExclude
    private static final float[] DEFAULT_GRADIENT_START_POINTS = new float[]{0.2f, 1.0f};
    @JBindingExclude
    public static final int TYPE_NORMAL = 0;
    @JBindingExclude
    public static final int TYPE_GRID = 1;
    @JBindingExclude
    public static final int TYPE_HEXAGON = 2;
    @JBindingExclude
    public static final Gradient DEFAULT_GRADIENT = new Gradient(DEFAULT_GRADIENT_COLORS, DEFAULT_GRADIENT_START_POINTS);
    @JBindingExclude
    private Gradient mGradient = DEFAULT_GRADIENT;
    @JBindingExclude
    private Collection<WeightedLatLng> mData;
    private float mSize = 2000.0f;
    private float mOpacity = 1.0f;
    private double maxIntensity = 0.0;
    private float maxZoom = 20.0f;
    private float minZoom = 3.0f;
    private float mGap = 0.0f;
    private int mType = 2;
    private float zIndex = 0.0f;
    private boolean isVisible = true;
    private boolean isPointsUpdated = false;
    private double[] pointList;
    private int[] mColors;
    private float[] mStartPoints;
    private double mLatitude;

    public HeatMapLayerOptions() {
        this.type = "HeatMapLayerOptions";
    }

    public HeatMapLayerOptions data(Collection<LatLng> collection) {
        return this.weightedData(HeatMapLayerOptions.a(collection));
    }

    public HeatMapLayerOptions weightedData(Collection<WeightedLatLng> collection) {
        this.mData = collection;
        this.isPointsUpdated = true;
        this.a();
        return this;
    }

    public HeatMapLayerOptions size(float f2) {
        this.mSize = f2;
        return this;
    }

    public HeatMapLayerOptions gradient(Gradient gradient) {
        this.mGradient = gradient;
        if (this.mGradient != null) {
            this.mColors = this.mGradient.getColors();
            this.mStartPoints = this.mGradient.getStartPoints();
        }
        return this;
    }

    public HeatMapLayerOptions opacity(float f2) {
        this.mOpacity = Math.max(0.0f, Math.min(f2, 1.0f));
        return this;
    }

    public HeatMapLayerOptions maxIntensity(double d2) {
        this.maxIntensity = d2;
        return this;
    }

    public HeatMapLayerOptions maxZoom(float f2) {
        this.maxZoom = f2;
        return this;
    }

    public HeatMapLayerOptions minZoom(float f2) {
        this.minZoom = f2;
        return this;
    }

    public HeatMapLayerOptions gap(float f2) {
        this.mGap = f2;
        return this;
    }

    public HeatMapLayerOptions type(int n2) {
        this.mType = n2;
        return this;
    }

    public HeatMapLayerOptions zIndex(float f2) {
        this.zIndex = f2;
        return this;
    }

    public HeatMapLayerOptions visible(boolean bl2) {
        this.isVisible = bl2;
        return this;
    }

    public Gradient getGradient() {
        return this.mGradient;
    }

    public Collection<WeightedLatLng> getData() {
        return this.mData;
    }

    public float getSize() {
        return this.mSize;
    }

    public float getOpacity() {
        return this.mOpacity;
    }

    public double getMaxIntensity() {
        return this.maxIntensity;
    }

    public float getMaxZoom() {
        return this.maxZoom;
    }

    public float getMinZoom() {
        return this.minZoom;
    }

    public float getGap() {
        return this.mGap;
    }

    public int getType() {
        return this.mType;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    private static Collection<WeightedLatLng> a(Collection<LatLng> object) {
        ArrayList<WeightedLatLng> arrayList = new ArrayList<WeightedLatLng>();
        object = object.iterator();
        while (object.hasNext()) {
            LatLng latLng = (LatLng)object.next();
            arrayList.add(new WeightedLatLng(latLng));
        }
        return arrayList;
    }

    private void a() {
        if (this.isPointsUpdated) {
            double d2 = 0.0;
            double d3 = Double.NaN;
            double d4 = Double.NaN;
            Collection<WeightedLatLng> collection = this.getData();
            if (collection == null) {
                return;
            }
            int n2 = collection.size();
            this.pointList = new double[n2 * 3];
            n2 = 0;
            for (WeightedLatLng weightedLatLng : collection) {
                if (weightedLatLng != null && weightedLatLng.latLng != null) {
                    this.pointList[n2 * 3] = weightedLatLng.latLng.latitude;
                    this.pointList[n2 * 3 + 1] = weightedLatLng.latLng.longitude;
                    this.pointList[n2 * 3 + 2] = weightedLatLng.intensity;
                    ++n2;
                    double d5 = weightedLatLng.latLng.latitude;
                    if (Double.isNaN(d3)) {
                        d3 = d5;
                    }
                    if (Double.isNaN(d4)) {
                        d4 = d5;
                    }
                    if (d5 > d4) {
                        d4 = d5;
                    }
                    if (!(d5 < d3)) continue;
                    d3 = d5;
                    continue;
                }
                Log.e((String)"mapcore", (String)"read file failed");
            }
            if (!Double.isNaN(d3) && !Double.isNaN(d4)) {
                d2 = (d3 + d4) / 2.0;
            }
            this.mLatitude = d2;
        }
    }
}

