/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.RemoteException;
import android.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.MVTTileOverlayOptions;
import java.lang.ref.WeakReference;

public final class MVTTileOverlay
extends BaseOverlay {
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;
    private MVTTileOverlayOptions mMVTTileOverlayOptions;

    public MVTTileOverlay(IGlOverlayLayer iGlOverlayLayer, MVTTileOverlayOptions mVTTileOverlayOptions, String string2) {
        super(string2);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.mMVTTileOverlayOptions = mVTTileOverlayOptions;
        if (this.mMVTTileOverlayOptions != null) {
            this.mMVTTileOverlayOptions.getTileProviderInner().init(iGlOverlayLayer, string2);
        }
    }

    public final void remove() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            return;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return;
        }
    }

    public final void setZIndex(float f2) {
        this.mMVTTileOverlayOptions.setZIndex(f2);
        this.updateOption();
    }

    public final float getZIndex() {
        return this.mMVTTileOverlayOptions.getZIndex();
    }

    public final void setVisible(boolean bl2) {
        this.mMVTTileOverlayOptions.setVisible(bl2);
        this.updateOption();
    }

    public final boolean visible() {
        return this.mMVTTileOverlayOptions.visible();
    }

    protected final void updateOption() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.updateOption(this.overlayName, this.mMVTTileOverlayOptions);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }
}

