/*
 * Decompiled with CFR 0.152.
 */
package org.vosk.android;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.vosk.Model;

public class StorageService {
    protected static final String TAG = StorageService.class.getSimpleName();

    public static void unpack(Context context, String sourcePath, String targetPath, Callback<Model> completeCallback, Callback<IOException> errorCallback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Handler handler = new Handler(Looper.getMainLooper());
        executor.execute(() -> {
            try {
                String outputPath = StorageService.sync(context, sourcePath, targetPath);
                Model model = new Model(outputPath);
                handler.post(() -> completeCallback.onComplete(model));
            }
            catch (IOException e) {
                handler.post(() -> errorCallback.onComplete(e));
            }
        });
    }

    public static String sync(Context context, String sourcePath, String targetPath) throws IOException {
        AssetManager assetManager = context.getAssets();
        File externalFilesDir = context.getExternalFilesDir(null);
        if (externalFilesDir == null) {
            throw new IOException("cannot get external files dir, external storage state is " + Environment.getExternalStorageState());
        }
        File targetDir = new File(externalFilesDir, targetPath);
        String resultPath = new File(targetDir, sourcePath).getAbsolutePath();
        String sourceUUID = StorageService.readLine(assetManager.open(sourcePath + "/uuid"));
        try {
            String targetUUID = StorageService.readLine(new FileInputStream(new File(targetDir, sourcePath + "/uuid")));
            if (targetUUID.equals(sourceUUID)) {
                return resultPath;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        StorageService.deleteContents(targetDir);
        StorageService.copyAssets(assetManager, sourcePath, targetDir);
        StorageService.copyFile(assetManager, sourcePath + "/uuid", targetDir);
        return resultPath;
    }

    private static String readLine(InputStream is) throws IOException {
        return new BufferedReader(new InputStreamReader(is)).readLine();
    }

    private static boolean deleteContents(File dir) {
        File[] files = dir.listFiles();
        boolean success = true;
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    success &= StorageService.deleteContents(file);
                }
                if (file.delete()) continue;
                success = false;
            }
        }
        return success;
    }

    private static void copyAssets(AssetManager assetManager, String path, File outPath) throws IOException {
        String[] assets = assetManager.list(path);
        if (assets == null) {
            return;
        }
        if (assets.length == 0) {
            if (!path.endsWith("uuid")) {
                StorageService.copyFile(assetManager, path, outPath);
            }
        } else {
            File dir = new File(outPath, path);
            if (!dir.exists()) {
                Log.v((String)TAG, (String)("Making directory " + dir.getAbsolutePath()));
                if (!dir.mkdirs()) {
                    Log.v((String)TAG, (String)("Failed to create directory " + dir.getAbsolutePath()));
                }
            }
            for (String asset : assets) {
                StorageService.copyAssets(assetManager, path + "/" + asset, outPath);
            }
        }
    }

    private static void copyFile(AssetManager assetManager, String fileName, File outPath) throws IOException {
        int read;
        Log.v((String)TAG, (String)("Copy " + fileName + " to " + outPath));
        InputStream in = assetManager.open(fileName);
        FileOutputStream out = new FileOutputStream(outPath + "/" + fileName);
        byte[] buffer = new byte[4000];
        while ((read = in.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, read);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static interface Callback<R> {
        public void onComplete(R var1);
    }
}

