/*
 * Decompiled with CFR 0.152.
 */
package com.alokvnair.progresscircle;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import com.alokvnair.progresscircle.R;

public class ProgressCircle
extends View {
    private static final int POINTS_COUNT = 9;
    private static final int STEP = 3;
    private static final int BIG_STEP = 1;
    private static final int DEFAULT_COLOR = Color.rgb((int)87, (int)247, (int)250);
    private static final float DEFAULT_RADIUS = 180.0f;
    private static final float DEFAULT_CIRCLE_RADIUS = 40.0f;
    private static final float DEFAULT_MOVE_RADIUS = 30.0f;
    private static final int SPLIT_ANGLE = 45;
    private static final int ADDITION_LENGTH = 6;
    private static final int FLAT_ANGLE = 180;
    private static final String INSTANCE_STATE = "saved_instance";
    private static final String ANGLE = "angle";
    private static final String BIGCIRCLECENTERX = "bigCircleCenterX";
    private static final String BIGCIRCLECENTERY = "bigCircleCenterY";
    private static final String RADIUS = "radius";
    private static final String CIRCLERADIUS = "circleRadius";
    private static final String MOVERADIUS = "moveRadius";
    private static final String POINTCOLOR = "pointColor";
    private static final String STARTX1 = "startX1";
    private static final String STARTY1 = "startY1";
    private static final String ENDX1 = "endX1";
    private static final String ENDY1 = "endY1";
    private static final String STARTX2 = "startX2";
    private static final String STARTY2 = "startY2";
    private static final String ENDX2 = "endX2";
    private static final String ENDY2 = "endY2";
    private static final String CONTROLX1 = "controlX1";
    private static final String CONTROLY1 = "controlY1";
    private static final String BIGSTEP = "bigStep";
    private CirclePoint[] circlePoints = new CirclePoint[9];
    private int angle = 0;
    private int bigStep = 1;
    float bigCircleCenterX;
    float bigCircleCenterY;
    float radius;
    float circleRadius;
    float moveRadius;
    int pointColor;
    private float startX1;
    private float startY1;
    private float startX2;
    private float startY2;
    private float controlX1;
    private float controlY1;
    private float endX1;
    private float endY1;
    private float endX2;
    private float endY2;
    private Path path1;
    private Paint circlePaint;
    private Paint linePaint;
    private boolean isFirst = true;

    public ProgressCircle(Context context) {
        this(context, null);
    }

    public ProgressCircle(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ProgressCircle(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ProgressCircle, defStyleAttr, 0);
        this.pointColor = attributes.getColor(R.styleable.ProgressCircle_point_color, DEFAULT_COLOR);
        boolean isDynamic = attributes.getBoolean(R.styleable.ProgressCircle_isdynamic, true);
        this.isDynamic(isDynamic);
        attributes.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measure(widthMeasureSpec, true), this.measure(heightMeasureSpec, false));
    }

    private int measure(int measureSpec, boolean isWidth) {
        int result;
        int padding;
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        int n = padding = isWidth ? this.getPaddingLeft() + this.getPaddingRight() : this.getPaddingTop() + this.getPaddingBottom();
        if (mode == 0x40000000) {
            result = size;
        } else {
            result = isWidth ? this.getSuggestedMinimumWidth() : this.getSuggestedMinimumHeight();
            result += padding;
            if (mode == Integer.MIN_VALUE) {
                result = isWidth ? Math.max(result, size) : Math.min(result, size);
            }
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        if (this.isFirst) {
            this.init();
            this.isFirst = false;
        }
        for (int i = 0; i < 8; ++i) {
            CirclePoint p = this.circlePoints[i];
            p.x = (float)this.getPaddingLeft() + this.bigCircleCenterX + (float)Math.cos(Math.toRadians(p.currentAngle)) * this.radius;
            p.y = (float)this.getPaddingTop() + this.bigCircleCenterY + (float)Math.sin(Math.toRadians(p.currentAngle)) * this.radius;
            p.currentAngle += this.bigStep;
            canvas.drawCircle(p.x, p.y, p.radius, this.circlePaint);
        }
        this.calculateMovingPoint(canvas);
        this.angle += 3;
        this.invalidate();
    }

    protected void init() {
        float temp = this.getHeight() > this.getWidth() ? (float)(this.getWidth() / 2) : (float)(this.getHeight() / 2);
        this.radius = temp - temp / 180.0f * 40.0f;
        this.circleRadius = 0.22222222f * this.radius;
        this.moveRadius = 0.16666667f * this.radius;
        this.bigCircleCenterX = this.getPaddingLeft() + this.getWidth() / 2;
        this.bigCircleCenterY = this.getPaddingTop() + this.getHeight() / 2;
        this.path1 = new Path();
        this.initializePaints();
        this.initializePoints();
    }

    protected void calculateMovingPoint(Canvas canvas) {
        CirclePoint p = this.circlePoints[8];
        p.x = this.bigCircleCenterX + (float)Math.cos(Math.toRadians(this.angle)) * this.radius;
        p.y = this.bigCircleCenterY + (float)Math.sin(Math.toRadians(this.angle)) * this.radius;
        canvas.drawCircle(p.x, p.y, p.radius, this.circlePaint);
        for (int i = 0; i < 8; ++i) {
            CirclePoint biggerP1 = this.circlePoints[i];
            if (this.isIntersect(p, biggerP1)) {
                canvas.drawCircle(biggerP1.x, biggerP1.y, biggerP1.radius + 6.0f * (1.0f - this.getDistanceRatio(p, biggerP1)), this.circlePaint);
            }
            if (!this.isConnect(p, biggerP1)) continue;
            float headOffsetX1 = (float)((double)this.circleRadius * Math.sin(Math.atan((p.y - biggerP1.y) / (p.x - biggerP1.x))));
            float headOffsetY1 = (float)((double)this.circleRadius * Math.cos(Math.atan((p.y - biggerP1.y) / (p.x - biggerP1.x))));
            float footOffsetX1 = (float)((double)this.moveRadius * Math.sin(Math.atan((p.y - biggerP1.y) / (p.x - biggerP1.x))));
            float footOffsetY1 = (float)((double)this.moveRadius * Math.cos(Math.atan((p.y - biggerP1.y) / (p.x - biggerP1.x))));
            this.startX1 = biggerP1.x - headOffsetX1;
            this.startY1 = biggerP1.y + headOffsetY1;
            this.endX1 = biggerP1.x + headOffsetX1;
            this.endY1 = biggerP1.y - headOffsetY1;
            this.startX2 = p.x - footOffsetX1;
            this.startY2 = p.y + footOffsetY1;
            this.endX2 = p.x + footOffsetX1;
            this.endY2 = p.y - footOffsetY1;
            this.controlX1 = (biggerP1.x + p.x) / 2.0f;
            this.controlY1 = (biggerP1.y + p.y) / 2.0f;
            this.path1.reset();
            this.path1.moveTo(this.startX1, this.startY1);
            this.path1.quadTo(this.controlX1, this.controlY1, this.startX2, this.startY2);
            this.path1.lineTo(this.endX2, this.endY2);
            this.path1.quadTo(this.controlX1, this.controlY1, this.endX1, this.endY1);
            this.path1.lineTo(this.startX1, this.startY1);
            canvas.drawPath(this.path1, this.linePaint);
        }
    }

    protected void initializePoints() {
        for (int i = 0; i < 9; ++i) {
            CirclePoint p = new CirclePoint();
            p.currentAngle = 45 * i;
            p.x = (float)this.getPaddingLeft() + this.bigCircleCenterX + (float)Math.cos(Math.toRadians(p.currentAngle)) * this.radius;
            p.y = (float)this.getPaddingTop() + this.bigCircleCenterY + (float)Math.sin(Math.toRadians(p.currentAngle)) * this.radius;
            p.color = this.pointColor;
            p.radius = this.circleRadius;
            if (i == 8) {
                p.radius = this.moveRadius;
            }
            this.circlePoints[i] = p;
        }
    }

    protected void initializePaints() {
        this.circlePaint = new Paint(1);
        this.circlePaint.setColor(this.pointColor);
        this.linePaint = new Paint();
        this.linePaint.setAntiAlias(true);
        this.linePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.linePaint.setStrokeWidth(1.0f);
        this.linePaint.setColor(this.pointColor);
    }

    private boolean isIntersect(CirclePoint a, CirclePoint b) {
        float distance = (float)Math.sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
        return distance < a.radius + b.radius;
    }

    private boolean isConnect(CirclePoint a, CirclePoint b) {
        float distance = (float)Math.sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
        return (double)distance < (double)this.radius * Math.cos(Math.toRadians(67.0));
    }

    private float getDistanceRatio(CirclePoint a, CirclePoint b) {
        float distance = (float)Math.sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
        return distance / (a.radius + b.radius);
    }

    public void setPointColor(int color) {
        this.pointColor = color;
        if (this.linePaint != null) {
            this.linePaint.setColor(color);
        }
        if (this.circlePaint != null) {
            this.circlePaint.setColor(color);
        }
    }

    public void isDynamic(boolean dynamic) {
        this.bigStep = dynamic ? 1 : 0;
    }

    protected float dp2px(float dp) {
        float scale = this.getResources().getDisplayMetrics().density;
        return dp * scale + 0.5f;
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putInt(ANGLE, this.angle);
        bundle.putFloat(BIGCIRCLECENTERX, this.bigCircleCenterX);
        bundle.putFloat(BIGCIRCLECENTERY, this.bigCircleCenterY);
        bundle.putFloat(RADIUS, this.radius);
        bundle.putFloat(CIRCLERADIUS, this.circleRadius);
        bundle.putFloat(MOVERADIUS, this.moveRadius);
        bundle.putFloat(STARTX1, this.startX1);
        bundle.putFloat(STARTY1, this.startY1);
        bundle.putFloat(ENDX1, this.endX1);
        bundle.putFloat(ENDY1, this.endY1);
        bundle.putFloat(STARTX2, this.startX2);
        bundle.putFloat(STARTY2, this.startY2);
        bundle.putFloat(ENDX2, this.endX2);
        bundle.putFloat(ENDY2, this.endY2);
        bundle.putFloat(CONTROLX1, this.controlX1);
        bundle.putFloat(CONTROLY1, this.controlY1);
        bundle.putInt(POINTCOLOR, this.pointColor);
        bundle.putInt(BIGSTEP, this.bigStep);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.angle = bundle.getInt(ANGLE);
            this.bigCircleCenterX = bundle.getFloat(BIGCIRCLECENTERX);
            this.bigCircleCenterY = bundle.getFloat(BIGCIRCLECENTERY);
            this.radius = bundle.getFloat(RADIUS);
            this.circleRadius = bundle.getFloat(CIRCLERADIUS);
            this.moveRadius = bundle.getFloat(MOVERADIUS);
            this.startX1 = bundle.getFloat(STARTX1);
            this.startY1 = bundle.getFloat(STARTY1);
            this.endX1 = bundle.getFloat(ENDX1);
            this.endY1 = bundle.getFloat(ENDY1);
            this.startX2 = bundle.getFloat(STARTX2);
            this.startY2 = bundle.getFloat(STARTY2);
            this.endX2 = bundle.getFloat(ENDX2);
            this.endY2 = bundle.getFloat(ENDY2);
            this.controlX1 = bundle.getFloat(CONTROLX1);
            this.controlY1 = bundle.getFloat(CONTROLY1);
            this.pointColor = bundle.getInt(POINTCOLOR);
            this.bigStep = bundle.getInt(BIGSTEP);
            this.init();
            super.onRestoreInstanceState(bundle.getParcelable(INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    static class CirclePoint {
        public int currentAngle;
        public float radius;
        public float x;
        public float y;
        public int color;

        CirclePoint() {
        }
    }
}

