/*
 * Decompiled with CFR 0.152.
 */
package com.aloj.progress;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.aloj.progress.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0018\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\tH\u0014J\u000e\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020\tJ\b\u00104\u001a\u00020,H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/aloj/progress/CircularProgressView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "accelerateInterpolator", "Landroid/view/animation/AccelerateInterpolator;", "circlePaint", "Landroid/graphics/Paint;", "circleRect", "Landroid/graphics/RectF;", "currentCircleLength", "", "currentProgressTime", "decelerateInterpolator", "Landroid/view/animation/DecelerateInterpolator;", "goalCircleLength", "indeterminate", "", "lastUpdateTime", "", "value", "progress", "getProgress", "()F", "setProgress", "(F)V", "progressPaint", "progressStarted", "getProgressStarted", "()Z", "setProgressStarted", "(Z)V", "radOffset", "radialPadding", "risingCircleLength", "size", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setProgressColor", "color", "updateAnimation", "Companion", "download-progress_release"})
public final class CircularProgressView
extends View {
    private final RectF circleRect;
    private final DecelerateInterpolator decelerateInterpolator;
    private final AccelerateInterpolator accelerateInterpolator;
    private final Paint progressPaint;
    private final int radialPadding;
    private final Paint circlePaint;
    private int size;
    private boolean indeterminate;
    private long lastUpdateTime;
    private float radOffset;
    private float currentCircleLength;
    private boolean risingCircleLength;
    private float currentProgressTime;
    private float goalCircleLength;
    private float progress;
    private boolean progressStarted;
    private static final int ROTATION_TIME = 2000;
    private static final float RISING_TIME = 500.0f;
    private static final int CIRCLE_ANIM_STEP = 3;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float value) {
        this.progress = value > 1.0f ? 1.0f : (value < 0.0f ? 0.0f : value);
        this.goalCircleLength = (float)360 * this.progress;
        this.indeterminate = this.progress == 0.0f;
        this.invalidate();
    }

    public final boolean getProgressStarted() {
        return this.progressStarted;
    }

    public final void setProgressStarted(boolean value) {
        this.progressStarted = value;
        this.invalidate();
    }

    public final void setProgressColor(int color) {
        this.progressPaint.setColor(color);
        this.invalidate();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.drawCircle((float)this.size / 2.0f, (float)this.size / 2.0f, (float)this.size / 2.0f, this.circlePaint);
        if (this.progressStarted) {
            int x = (this.getMeasuredWidth() - this.size) / 2;
            int y = (this.getMeasuredHeight() - this.size) / 2;
            float strokeWidth = this.progressPaint.getStrokeWidth();
            this.circleRect.set((float)x + strokeWidth + (float)this.radialPadding, (float)y + strokeWidth + (float)this.radialPadding, (float)(x + this.size) - strokeWidth - (float)this.radialPadding, (float)(y + this.size) - strokeWidth - (float)this.radialPadding);
            canvas.drawArc(this.circleRect, this.radOffset, this.currentCircleLength, false, this.progressPaint);
            this.updateAnimation();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.resolveSize((int)this.size, (int)widthMeasureSpec);
        int height = View.resolveSize((int)this.size, (int)heightMeasureSpec);
        this.size = Math.min(width, height);
        this.setMeasuredDimension(this.size, this.size);
        this.progressPaint.setStrokeWidth((float)this.size / 17.0f);
    }

    private final void updateAnimation() {
        long newTime = System.currentTimeMillis();
        long dt = newTime - this.lastUpdateTime;
        if (dt > (long)17) {
            dt = 17L;
        }
        this.lastUpdateTime = newTime;
        this.radOffset += (float)((long)360 * dt / (long)CircularProgressView.Companion.getROTATION_TIME());
        int count = (int)(this.radOffset / (float)360);
        this.radOffset -= (float)(count * 360);
        if (this.indeterminate) {
            this.currentProgressTime += (float)dt;
            if (this.currentProgressTime >= CircularProgressView.Companion.getRISING_TIME()) {
                this.currentProgressTime = CircularProgressView.Companion.getRISING_TIME();
            }
            this.currentCircleLength = this.risingCircleLength ? (float)4 + (float)266 * this.accelerateInterpolator.getInterpolation(this.currentProgressTime / CircularProgressView.Companion.getRISING_TIME()) : (float)4 - (float)270 * (1.0f - this.decelerateInterpolator.getInterpolation(this.currentProgressTime / CircularProgressView.Companion.getRISING_TIME()));
            if (this.currentProgressTime == CircularProgressView.Companion.getRISING_TIME()) {
                if (this.risingCircleLength) {
                    this.radOffset += 270.0f;
                    this.currentCircleLength = -266.0f;
                }
                this.risingCircleLength = !this.risingCircleLength;
                this.currentProgressTime = 0.0f;
            }
        } else if (Math.abs(this.currentCircleLength - this.goalCircleLength) > (float)(CircularProgressView.Companion.getCIRCLE_ANIM_STEP() * 2)) {
            this.currentCircleLength += (float)(this.currentCircleLength < this.goalCircleLength ? CircularProgressView.Companion.getCIRCLE_ANIM_STEP() : -1 * CircularProgressView.Companion.getCIRCLE_ANIM_STEP());
        }
        this.invalidate();
    }

    public CircularProgressView(@NotNull Context context) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.circleRect = new RectF();
        this.decelerateInterpolator = new DecelerateInterpolator();
        this.accelerateInterpolator = new AccelerateInterpolator();
        Paint paint2 = new Paint(1);
        CircularProgressView circularProgressView = this;
        Paint $receiver = paint2;
        $receiver.setStyle(Paint.Style.STROKE);
        $receiver.setStrokeCap(Paint.Cap.ROUND);
        $receiver.setStrokeWidth((float)this.getContext().getResources().getDimensionPixelSize(R.dimen.default_radial_progress_stroke_size));
        $receiver.setColor(-1);
        circularProgressView.progressPaint = paint = paint2;
        this.radialPadding = this.getContext().getResources().getDimensionPixelSize(R.dimen.radial_progress_padding);
        paint2 = new Paint(1);
        circularProgressView = this;
        $receiver = paint2;
        $receiver.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.progress_background));
        $receiver.setStrokeCap(Paint.Cap.ROUND);
        circularProgressView.circlePaint = paint = paint2;
        this.size = this.getContext().getResources().getDimensionPixelSize(R.dimen.radial_progress_size);
        this.indeterminate = true;
    }

    public CircularProgressView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.circleRect = new RectF();
        this.decelerateInterpolator = new DecelerateInterpolator();
        this.accelerateInterpolator = new AccelerateInterpolator();
        Paint paint2 = new Paint(1);
        CircularProgressView circularProgressView = this;
        Paint $receiver = paint2;
        $receiver.setStyle(Paint.Style.STROKE);
        $receiver.setStrokeCap(Paint.Cap.ROUND);
        $receiver.setStrokeWidth((float)this.getContext().getResources().getDimensionPixelSize(R.dimen.default_radial_progress_stroke_size));
        $receiver.setColor(-1);
        circularProgressView.progressPaint = paint = paint2;
        this.radialPadding = this.getContext().getResources().getDimensionPixelSize(R.dimen.radial_progress_padding);
        paint2 = new Paint(1);
        circularProgressView = this;
        $receiver = paint2;
        $receiver.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.progress_background));
        $receiver.setStrokeCap(Paint.Cap.ROUND);
        circularProgressView.circlePaint = paint = paint2;
        this.size = this.getContext().getResources().getDimensionPixelSize(R.dimen.radial_progress_size);
        this.indeterminate = true;
    }

    public CircularProgressView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.circleRect = new RectF();
        this.decelerateInterpolator = new DecelerateInterpolator();
        this.accelerateInterpolator = new AccelerateInterpolator();
        Paint paint2 = new Paint(1);
        CircularProgressView circularProgressView = this;
        Paint $receiver = paint2;
        $receiver.setStyle(Paint.Style.STROKE);
        $receiver.setStrokeCap(Paint.Cap.ROUND);
        $receiver.setStrokeWidth((float)this.getContext().getResources().getDimensionPixelSize(R.dimen.default_radial_progress_stroke_size));
        $receiver.setColor(-1);
        circularProgressView.progressPaint = paint = paint2;
        this.radialPadding = this.getContext().getResources().getDimensionPixelSize(R.dimen.radial_progress_padding);
        paint2 = new Paint(1);
        circularProgressView = this;
        $receiver = paint2;
        $receiver.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.progress_background));
        $receiver.setStrokeCap(Paint.Cap.ROUND);
        circularProgressView.circlePaint = paint = paint2;
        this.size = this.getContext().getResources().getDimensionPixelSize(R.dimen.radial_progress_size);
        this.indeterminate = true;
    }

    static {
        ROTATION_TIME = 2000;
        RISING_TIME = 500.0f;
        CIRCLE_ANIM_STEP = 3;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/aloj/progress/CircularProgressView$Companion;", "", "()V", "CIRCLE_ANIM_STEP", "", "getCIRCLE_ANIM_STEP", "()I", "RISING_TIME", "", "getRISING_TIME", "()F", "ROTATION_TIME", "getROTATION_TIME", "download-progress_release"})
    public static final class Companion {
        private final int getROTATION_TIME() {
            return ROTATION_TIME;
        }

        private final float getRISING_TIME() {
            return RISING_TIME;
        }

        private final int getCIRCLE_ANIM_STEP() {
            return CIRCLE_ANIM_STEP;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

